/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block.entity.behaviour;

import com.petrolpark.destroy.client.gui.menu.RedstoneProgrammerMenu;
import com.petrolpark.destroy.util.RedstoneProgram;
import com.simibubi.create.content.equipment.clipboard.ClipboardCloneable;
import com.simibubi.create.content.redstone.link.RedstoneLinkNetworkHandler;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.Couple;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class RedstoneProgrammerBehaviour
extends BlockEntityBehaviour
implements ClipboardCloneable,
MenuProvider {
    public static BehaviourType<RedstoneProgrammerBehaviour> TYPE = new BehaviourType();
    protected BooleanSupplier powerChecker;
    public BehaviourRedstoneProgram program;

    public RedstoneProgrammerBehaviour(SmartBlockEntity be, BooleanSupplier powerChecker) {
        super(be);
        this.powerChecker = powerChecker;
        this.program = new BehaviourRedstoneProgram();
        this.program.addBlankChannel((Couple<RedstoneLinkNetworkHandler.Frequency>)Couple.create((Object)RedstoneLinkNetworkHandler.Frequency.of((ItemStack)new ItemStack((ItemLike)Items.f_42415_)), (Object)RedstoneLinkNetworkHandler.Frequency.of((ItemStack)new ItemStack((ItemLike)Items.f_42415_))));
    }

    public void initialize() {
        super.initialize();
        if (this.getWorld().m_5776_()) {
            return;
        }
        this.program.load();
    }

    public void unload() {
        super.unload();
        if (this.getWorld().m_5776_()) {
            return;
        }
        this.program.unload();
    }

    public void tick() {
        this.program.tick();
        super.tick();
    }

    public void read(CompoundTag nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        this.setProgram(nbt.m_128469_("Program"));
    }

    public void setProgram(CompoundTag tag) {
        this.program = RedstoneProgram.read(() -> new BehaviourRedstoneProgram(), tag);
    }

    public void write(CompoundTag nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        nbt.m_128365_("Program", (Tag)this.program.write());
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public String getClipboardKey() {
        return "Frequencies";
    }

    public boolean writeToClipboard(CompoundTag tag, Direction side) {
        return false;
    }

    public boolean readFromClipboard(CompoundTag tag, Player player, Direction side, boolean simulate) {
        if (!tag.m_128441_("First") || !tag.m_128441_("Last")) {
            return false;
        }
        Couple frequencies = Couple.create((Object)RedstoneLinkNetworkHandler.Frequency.of((ItemStack)ItemStack.m_41712_((CompoundTag)tag.m_128469_("First"))), (Object)RedstoneLinkNetworkHandler.Frequency.of((ItemStack)ItemStack.m_41712_((CompoundTag)tag.m_128469_("Last"))));
        if (this.program.getChannels().stream().anyMatch(channel -> channel.networkKey.equals((Object)frequencies))) {
            return false;
        }
        if (!simulate) {
            this.program.addBlankChannel((Couple<RedstoneLinkNetworkHandler.Frequency>)frequencies);
        }
        return true;
    }

    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        return RedstoneProgrammerMenu.create(containerId, playerInventory, this.program);
    }

    public Component m_5446_() {
        return Component.m_237119_();
    }

    public class BehaviourRedstoneProgram
    extends RedstoneProgram {
        @Override
        public boolean hasPower() {
            return RedstoneProgrammerBehaviour.this.powerChecker.getAsBoolean();
        }

        @Override
        public BlockPos getBlockPos() {
            return RedstoneProgrammerBehaviour.this.getPos();
        }

        @Override
        public boolean shouldTransmit() {
            Level level = RedstoneProgrammerBehaviour.super.getWorld();
            BlockPos pos = RedstoneProgrammerBehaviour.this.getPos();
            if (RedstoneProgrammerBehaviour.this.blockEntity.isChunkUnloaded()) {
                return false;
            }
            if (RedstoneProgrammerBehaviour.this.blockEntity.m_58901_()) {
                return false;
            }
            if (!level.m_46749_(pos)) {
                return false;
            }
            return level.m_7702_(pos) == RedstoneProgrammerBehaviour.this.blockEntity;
        }

        @Override
        public LevelAccessor getWorld() {
            return RedstoneProgrammerBehaviour.super.getWorld();
        }
    }
}

