/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block.entity.behaviour;

import com.petrolpark.destroy.advancement.DestroyAdvancements;
import com.petrolpark.destroy.effect.DestroyMobEffects;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class SentimentalBehaviour
extends BlockEntityBehaviour {
    public static BehaviourType<SentimentalBehaviour> TYPE = new BehaviourType();
    public LivingEntity owner;

    public SentimentalBehaviour(SmartBlockEntity be) {
        super(be);
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public void setOwner(LivingEntity owner) {
        this.owner = owner;
        this.blockEntity.sendData();
    }

    public void onRemove(BlockState state, @Nullable Player player) {
        if (this.hasOwner() && this.getPos().m_203198_(this.owner.m_20185_(), this.owner.m_20186_(), this.owner.m_20189_()) < 16.0) {
            this.owner.m_7292_(new MobEffectInstance((MobEffect)DestroyMobEffects.CRYING.get(), 600, 0, false, false));
            LivingEntity livingEntity = this.owner;
            if (livingEntity instanceof Villager) {
                Villager villager = (Villager)livingEntity;
                if (player != null) {
                    villager.f_35377_.m_26191_(villager.m_20148_(), GossipType.MINOR_NEGATIVE, 20);
                    if (villager.m_6162_()) {
                        DestroyAdvancements.JUMP_ON_SAND_CASTLE.award(this.owner.m_9236_(), player);
                    }
                }
            }
        }
    }

    public void read(CompoundTag tag, boolean clientPacket) {
        Level level;
        if (!clientPacket && (level = this.getWorld()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.m_8791_(tag.m_128342_("BabyOwner"));
        }
        super.read(tag, clientPacket);
    }

    public void write(CompoundTag tag, boolean clientPacket) {
        if (this.hasOwner() && !clientPacket) {
            tag.m_128362_("BabyOwner", this.owner.m_20148_());
        }
        super.write(tag, clientPacket);
    }

    private boolean hasOwner() {
        return this.owner != null && this.owner.m_6084_();
    }
}

