/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block.entity.behaviour;

import com.google.common.collect.ImmutableList;
import com.petrolpark.destroy.MoveToPetrolparkLibrary;
import com.petrolpark.destroy.block.entity.behaviour.SmartValueSettingsBehaviour;
import com.petrolpark.destroy.util.DestroyLang;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBoard;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsFormatter;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;

@MoveToPetrolparkLibrary
public class SidedScrollValueBehaviour
extends BlockEntityBehaviour
implements SmartValueSettingsBehaviour {
    public static final BehaviourType<SidedScrollValueBehaviour> TYPE = new BehaviourType();
    protected ValueBoxTransform slotPositioning;
    protected Vec3 textShift;
    protected int min = 0;
    protected int max = 1;
    public int[] values = new int[]{0, 0, 0, 0, 0, 0};
    protected Direction lastSideAccessed;
    public Component label;
    protected BiConsumer<Direction, Integer> callback;
    public boolean oppositeSides;
    protected Function<Integer, String> formatter;
    private Supplier<Boolean> isActive;
    protected boolean needsWrench;

    public SidedScrollValueBehaviour(Component label, SmartBlockEntity be, ValueBoxTransform slot) {
        super(be);
        this.setLabel(label);
        this.slotPositioning = slot;
        this.callback = (d, i) -> {};
        this.oppositeSides = true;
        this.formatter = i -> Integer.toString(i);
        this.isActive = () -> true;
    }

    public boolean isSafeNBT() {
        return true;
    }

    public void write(CompoundTag nbt, boolean clientPacket) {
        nbt.m_128385_("Values", this.values);
        super.write(nbt, clientPacket);
    }

    public void read(CompoundTag nbt, boolean clientPacket) {
        this.values = nbt.m_128465_("Values");
        super.read(nbt, clientPacket);
    }

    public SidedScrollValueBehaviour withCallback(BiConsumer<Direction, Integer> valueCallback) {
        this.callback = valueCallback;
        return this;
    }

    public SidedScrollValueBehaviour oppositeSides() {
        this.oppositeSides = true;
        return this;
    }

    public SidedScrollValueBehaviour between(int min, int max) {
        this.min = min;
        this.max = max;
        return this;
    }

    public SidedScrollValueBehaviour requiresWrench() {
        this.needsWrench = true;
        return this;
    }

    public SidedScrollValueBehaviour withFormatter(Function<Integer, String> formatter) {
        this.formatter = formatter;
        return this;
    }

    public SidedScrollValueBehaviour onlyActiveWhen(Supplier<Boolean> condition) {
        this.isActive = condition;
        return this;
    }

    public void setValue(Direction direction, int newValue) {
        if ((newValue = Mth.m_14045_((int)newValue, (int)this.min, (int)this.max)) == this.values[direction.ordinal()]) {
            return;
        }
        this.values[direction.ordinal()] = newValue;
        this.callback.accept(direction, newValue);
        this.blockEntity.m_6596_();
        this.blockEntity.sendData();
    }

    public int getValue(Direction side) {
        return this.values[side.ordinal()];
    }

    public String formatValue(Direction side) {
        return this.formatter.apply(this.values[side.ordinal()]);
    }

    public boolean testHit(Vec3 hit) {
        BlockState state = this.blockEntity.m_58900_();
        Vec3 localHit = hit.m_82546_(Vec3.m_82528_((Vec3i)this.blockEntity.m_58899_()));
        return this.slotPositioning.testHit(state, localHit);
    }

    public boolean isActive() {
        return this.isActive.get();
    }

    public void setLabel(Component label) {
        this.label = label;
    }

    public ValueBoxTransform getSlotPositioning() {
        return this.slotPositioning;
    }

    public boolean readFromClipboard(CompoundTag tag, Player player, Direction side, boolean simulate) {
        if (!this.acceptsValueSettings()) {
            return false;
        }
        if (!tag.m_128441_("Values")) {
            return false;
        }
        if (simulate) {
            return true;
        }
        int[] newValues = tag.m_128465_("Values");
        for (Direction direction : Direction.values()) {
            this.setValue(direction, newValues[direction.ordinal()]);
        }
        this.playFeedbackSound(this);
        return true;
    }

    public boolean writeToClipboard(CompoundTag tag, Direction side) {
        if (!this.acceptsValueSettings()) {
            return false;
        }
        tag.m_128385_("Values", this.values);
        return true;
    }

    public void onShortInteract(Player player, InteractionHand hand, Direction side) {
        this.lastSideAccessed = side;
        if (player instanceof FakePlayer) {
            this.blockEntity.m_58900_().m_60664_(this.getWorld(), player, hand, new BlockHitResult(VecHelper.getCenterOf((Vec3i)this.getPos()), side, this.getPos(), true));
        }
    }

    public ValueSettingsBoard createBoard(Player player, BlockHitResult hitResult) {
        this.lastSideAccessed = hitResult.m_82434_();
        return new ValueSettingsBoard(this.label, this.max, 10, (List)ImmutableList.of((Object)DestroyLang.direction(this.oppositeSides ? this.lastSideAccessed.m_122424_() : this.lastSideAccessed).component()), new ValueSettingsFormatter(ValueSettingsBehaviour.ValueSettings::format));
    }

    @Override
    public void acceptAccessInformation(InteractionHand interactionHand, Direction face) {
        this.lastSideAccessed = face;
    }

    public void setValueSettings(Player player, ValueSettingsBehaviour.ValueSettings valueSetting, boolean ctrlDown) {
        this.setValue(this.lastSideAccessed, valueSetting.value());
        this.playFeedbackSound(this);
    }

    public ValueSettingsBehaviour.ValueSettings getValueSettings() {
        return new ValueSettingsBehaviour.ValueSettings(0, this.values[this.lastSideAccessed.ordinal()]);
    }

    public boolean onlyVisibleWithWrench() {
        return this.needsWrench;
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }
}

