/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block.entity.behaviour.fluidTankBehaviour;

import com.petrolpark.destroy.chemistry.Mixture;
import com.petrolpark.destroy.fluid.DestroyFluids;
import com.petrolpark.destroy.fluid.MixtureFluid;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class GeniusFluidTankBehaviour
extends SmartFluidTankBehaviour {
    public GeniusFluidTankBehaviour(BehaviourType<SmartFluidTankBehaviour> type, SmartBlockEntity be, int tanks, int tankCapacity, boolean enforceVariety) {
        super(type, be, tanks, tankCapacity, enforceVariety);
        IFluidHandler[] handlers = new IFluidHandler[tanks];
        for (int i = 0; i < tanks; ++i) {
            GeniusTankSegment tankSegment = new GeniusTankSegment(tankCapacity);
            this.tanks[i] = tankSegment;
            handlers[i] = tankSegment.getTank();
        }
        this.capability = LazyOptional.of(() -> new SmartFluidTankBehaviour.InternalFluidHandler((SmartFluidTankBehaviour)this, handlers, enforceVariety));
    }

    public class GeniusTankSegment
    extends SmartFluidTankBehaviour.TankSegment {
        public GeniusTankSegment(int capacity) {
            super((SmartFluidTankBehaviour)GeniusFluidTankBehaviour.this, capacity);
            this.tank = new GeniusFluidTank(capacity, f -> this.onFluidStackChanged());
        }

        protected GeniusFluidTank getTank() {
            return (GeniusFluidTank)this.tank;
        }
    }

    public static class GeniusFluidTank
    extends SmartFluidTank {
        public GeniusFluidTank(int capacity, Consumer<FluidStack> updateCallback) {
            super(capacity, updateCallback);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            int filled = super.fill(resource, action);
            if (filled == 0 && this.getSpace() > 0) {
                if (!DestroyFluids.isMixture(resource) || !DestroyFluids.isMixture(this.fluid)) {
                    return 0;
                }
                if (!resource.getOrCreateTag().m_128425_("Mixture", 10) || !this.fluid.getOrCreateTag().m_128425_("Mixture", 10)) {
                    return 0;
                }
                Mixture existingMixture = Mixture.readNBT(this.fluid.getOrCreateTag().m_128469_("Mixture"));
                Mixture addedMixture = Mixture.readNBT(resource.getOrCreateTag().m_128469_("Mixture"));
                int amountOfMixtureAdded = Math.min(this.getSpace(), resource.getAmount());
                int existingAmount = this.fluid.getAmount();
                if (!action.simulate()) {
                    Mixture newMixture = Mixture.mix(Map.of(existingMixture, (double)existingAmount / 1000.0, addedMixture, (double)amountOfMixtureAdded / 1000.0));
                    this.setFluid(MixtureFluid.of(existingAmount + amountOfMixtureAdded, newMixture));
                }
                return amountOfMixtureAdded;
            }
            return filled;
        }
    }
}

