/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block.entity.behaviour.fluidTankBehaviour;

import com.petrolpark.destroy.block.entity.behaviour.fluidTankBehaviour.GeniusFluidTankBehaviour;
import com.petrolpark.destroy.chemistry.Mixture;
import com.petrolpark.destroy.chemistry.Molecule;
import com.petrolpark.destroy.chemistry.ReadOnlyMixture;
import com.petrolpark.destroy.fluid.DestroyFluids;
import com.petrolpark.destroy.fluid.MixtureFluid;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class VatFluidTankBehaviour
extends GeniusFluidTankBehaviour {
    protected boolean liquidFull;
    protected int vatCapacity;

    public VatFluidTankBehaviour(SmartBlockEntity be, int vatCapacity) {
        super((BehaviourType<SmartFluidTankBehaviour>)SmartFluidTankBehaviour.TYPE, be, 2, vatCapacity, false);
        IFluidHandler[] handlers = new IFluidHandler[2];
        for (int i = 0; i < 2; ++i) {
            VatTankSegment tankSegment = new VatTankSegment(vatCapacity, i == 1);
            this.tanks[i] = tankSegment;
            handlers[i] = tankSegment.getTank();
        }
        this.capability = LazyOptional.of(() -> new VatFluidHandler(handlers));
        this.liquidFull = false;
        this.vatCapacity = vatCapacity;
    }

    public VatTankSegment.VatFluidTank getLiquidHandler() {
        return this.getLiquidTank().getTank();
    }

    public VatTankSegment.VatFluidTank getGasHandler() {
        return this.getGasTank().getTank();
    }

    public VatTankSegment getLiquidTank() {
        return (VatTankSegment)super.getPrimaryTank();
    }

    public VatTankSegment getGasTank() {
        return (VatTankSegment)this.tanks[1];
    }

    public void setVatCapacity(int capacity) {
        this.vatCapacity = capacity;
        for (SmartFluidTankBehaviour.TankSegment tankSegment : this.tanks) {
            ((VatTankSegment)tankSegment).getTank().setCapacity(capacity);
        }
    }

    public boolean isFull() {
        return this.liquidFull;
    }

    public Mixture getCombinedMixture() {
        FluidStack gasStack;
        HashMap<Mixture, Double> mixtures = new HashMap<Mixture, Double>(2);
        int totalVolume = 0;
        FluidStack liquidStack = this.getLiquidHandler().getFluid();
        if (!liquidStack.isEmpty()) {
            mixtures.put(Mixture.readNBT(liquidStack.getOrCreateChildTag("Mixture")), (double)liquidStack.getAmount() / 1000.0);
            totalVolume += liquidStack.getAmount();
        }
        if (!(gasStack = this.getGasHandler().getFluid()).isEmpty()) {
            mixtures.put(Mixture.readNBT(gasStack.getOrCreateChildTag("Mixture")), (double)gasStack.getAmount() / 1000.0);
            totalVolume += gasStack.getAmount();
        }
        Mixture mixture = Mixture.mix(mixtures);
        mixture.scale((float)this.vatCapacity / (float)totalVolume);
        return mixture;
    }

    public ReadOnlyMixture getCombinedReadOnlyMixture() {
        FluidStack gasStack;
        HashMap moleculesAndMoles = new HashMap();
        ReadOnlyMixture mixture = new ReadOnlyMixture();
        int totalVolume = 0;
        FluidStack liquidStack = this.getLiquidHandler().getFluid();
        if (!liquidStack.isEmpty()) {
            ReadOnlyMixture liquidMixture = ReadOnlyMixture.readNBT(ReadOnlyMixture::new, liquidStack.getOrCreateChildTag("Mixture"));
            liquidMixture.getContents(false).forEach(molecule -> moleculesAndMoles.merge(molecule, Float.valueOf(liquidMixture.getConcentrationOf((Molecule)molecule) * (float)liquidStack.getAmount()), (f1, f2) -> Float.valueOf(f1.floatValue() + f2.floatValue())));
            totalVolume += liquidStack.getAmount();
        }
        if (!(gasStack = this.getGasHandler().getFluid()).isEmpty()) {
            ReadOnlyMixture gasMixture = ReadOnlyMixture.readNBT(ReadOnlyMixture::new, gasStack.getOrCreateChildTag("Mixture"));
            gasMixture.getContents(false).forEach(molecule -> moleculesAndMoles.merge(molecule, Float.valueOf(gasMixture.getConcentrationOf((Molecule)molecule) * (float)gasStack.getAmount()), (f1, f2) -> Float.valueOf(f1.floatValue() + f2.floatValue())));
            totalVolume += gasStack.getAmount();
        }
        for (Map.Entry entry : moleculesAndMoles.entrySet()) {
            mixture.addMolecule((Molecule)entry.getKey(), ((Float)entry.getValue()).floatValue() / (float)totalVolume);
        }
        return mixture;
    }

    public void setMixture(Mixture mixture, int amount) {
        this.capability.ifPresent(fluidHandler -> {
            fluidHandler.drain(this.vatCapacity, IFluidHandler.FluidAction.EXECUTE);
            this.liquidFull = false;
            fluidHandler.fill(MixtureFluid.of(amount, mixture), IFluidHandler.FluidAction.EXECUTE);
        });
    }

    public FluidStack flush(float temperature) {
        FluidStack oldGas = this.getGasHandler().getFluid();
        this.getGasHandler().setFluid(DestroyFluids.air(this.vatCapacity - this.getLiquidHandler().getFluidAmount(), temperature));
        this.getGasHandler().flushed = true;
        return oldGas;
    }

    public void write(CompoundTag nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        if (clientPacket) {
            return;
        }
        nbt.m_128379_("Full", this.liquidFull);
    }

    public void read(CompoundTag nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        if (clientPacket) {
            return;
        }
        this.liquidFull = nbt.m_128471_("Full");
        this.vatCapacity = this.getLiquidHandler().getCapacity();
    }

    public void updateGasVolume() {
        if (this.getGasHandler().isEmpty()) {
            return;
        }
        double freeSpace = this.vatCapacity - this.getLiquidHandler().getFluidAmount();
        double gasVolume = this.getGasHandler().getFluidAmount();
        Mixture mixture = Mixture.readNBT(this.getGasHandler().getFluid().getOrCreateChildTag("Mixture"));
        mixture.scale((float)(freeSpace / gasVolume));
        this.getGasHandler().setFluid(MixtureFluid.of((int)freeSpace, mixture));
    }

    @Deprecated
    public SmartFluidTank getPrimaryHandler() {
        return null;
    }

    @Deprecated
    public SmartFluidTankBehaviour.TankSegment getPrimaryTank() {
        return null;
    }

    public class VatTankSegment
    extends GeniusFluidTankBehaviour.GeniusTankSegment {
        public VatTankSegment(int capacity, boolean isForGas) {
            super(capacity);
            this.tank = new VatFluidTank(capacity, isForGas, f -> this.onFluidStackChanged());
        }

        @Override
        public VatFluidTank getTank() {
            return (VatFluidTank)this.tank;
        }

        public class VatFluidTank
        extends GeniusFluidTankBehaviour.GeniusFluidTank {
            private final boolean isForGas;
            protected boolean flushed;

            public VatFluidTank(int capacity, boolean isForGas, Consumer<FluidStack> updateCallback) {
                super(capacity, updateCallback);
                this.isForGas = isForGas;
                this.flushed = false;
            }

            public boolean isEmptyOrFullOfAir() {
                return this.isEmpty() || this.flushed;
            }

            public boolean isFluidValid(int tank, FluidStack stack) {
                return DestroyFluids.isMixture(stack);
            }

            public void onContentsChanged() {
                super.onContentsChanged();
                this.flushed = false;
                if (this.fluid.getAmount() < this.getCapacity() && !this.isForGas) {
                    VatFluidTankBehaviour.this.liquidFull = false;
                }
            }

            public void setFluid(FluidStack stack) {
                super.setFluid(stack);
                this.flushed = false;
                if (stack.getAmount() < this.getCapacity() && !this.isForGas) {
                    VatFluidTankBehaviour.this.liquidFull = false;
                }
            }

            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                return super.drain(maxDrain, action);
            }
        }
    }

    public class VatFluidHandler
    extends SmartFluidTankBehaviour.InternalFluidHandler {
        public VatFluidHandler(IFluidHandler[] handlers) {
            super((SmartFluidTankBehaviour)VatFluidTankBehaviour.this, handlers, false);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (VatFluidTankBehaviour.this.liquidFull) {
                return 0;
            }
            if (!DestroyFluids.isMixture(resource)) {
                return 0;
            }
            boolean simulate = action == IFluidHandler.FluidAction.SIMULATE;
            Mixture.Phases phases = Mixture.readNBT(resource.getOrCreateChildTag("Mixture")).separatePhases(resource.getAmount());
            double amountScale = 1.0;
            if (phases.liquidVolume() > (double)VatFluidTankBehaviour.this.getLiquidHandler().getSpace()) {
                if (!simulate) {
                    VatFluidTankBehaviour.this.liquidFull = true;
                }
                amountScale = (phases.liquidVolume() - (double)VatFluidTankBehaviour.this.getLiquidHandler().getSpace()) / phases.liquidVolume();
            }
            VatFluidTankBehaviour.this.getLiquidHandler().fill(MixtureFluid.of((int)(phases.liquidVolume() * amountScale + 0.5), phases.liquidMixture(), ""), action);
            if (!simulate) {
                HashMap<Mixture, Double> mixtures = new HashMap<Mixture, Double>(2);
                double combinedVolume = 0.0;
                int freeSpace = VatFluidTankBehaviour.this.vatCapacity - VatFluidTankBehaviour.this.getLiquidHandler().getFluidAmount();
                if (!VatFluidTankBehaviour.this.getGasHandler().isEmpty()) {
                    FluidStack existingGas = VatFluidTankBehaviour.this.getGasHandler().getFluid();
                    mixtures.put(Mixture.readNBT(existingGas.getOrCreateChildTag("Mixture")), Double.valueOf(existingGas.getAmount()));
                    combinedVolume += (double)existingGas.getAmount();
                }
                if (!phases.gasMixture().isEmpty()) {
                    mixtures.put(phases.gasMixture(), phases.gasVolume());
                    combinedVolume += phases.gasVolume().doubleValue();
                }
                Mixture combinedGasMixture = Mixture.mix(mixtures);
                if (combinedVolume > 0.0 && !combinedGasMixture.isEmpty()) {
                    combinedGasMixture.scale((float)((double)freeSpace / combinedVolume));
                    VatFluidTankBehaviour.this.getGasHandler().setFluid(MixtureFluid.of(freeSpace, combinedGasMixture));
                }
            }
            return (int)((double)resource.getAmount() * amountScale);
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return DestroyFluids.isMixture(stack);
        }
    }
}

