/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block.instance;

import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.petrolpark.destroy.block.DoubleCardanShaftBlock;
import com.petrolpark.destroy.block.entity.DoubleCardanShaftBlockEntity;
import com.petrolpark.destroy.block.model.DestroyPartials;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityInstance;
import com.simibubi.create.content.kinetics.base.flwdata.KineticData;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class DoubleCardanShaftInstance
extends KineticBlockEntityInstance<DoubleCardanShaftBlockEntity>
implements DynamicInstance {
    protected final RotatingData shaft1;
    protected final RotatingData grip1;
    protected final ModelData gimbal1;
    protected final RotatingData shaft2;
    protected final RotatingData grip2;
    protected final ModelData gimbal2;
    protected final ModelData centerShaft;
    protected final Direction shaft1Direction;
    protected final Direction shaft2Direction;
    protected Direction sourceFacing;
    protected boolean secondaryPositive;

    public DoubleCardanShaftInstance(MaterialManager materialManager, DoubleCardanShaftBlockEntity blockEntity) {
        super(materialManager, (KineticBlockEntity)blockEntity);
        Material modelMaterial = this.getTransformMaterial();
        Material rotatingMaterial = this.getRotatingMaterial();
        Direction[] directions = DoubleCardanShaftBlock.getDirectionsConnectedByState(blockEntity.m_58900_());
        this.secondaryPositive = (Boolean)blockEntity.m_58900_().m_61143_((Property)DoubleCardanShaftBlock.AXIS_ALONG_FIRST_COORDINATE);
        this.shaft1Direction = directions[0];
        this.shaft2Direction = directions[1];
        int blockLight = this.world.m_45517_(LightLayer.BLOCK, this.pos);
        int skyLight = this.world.m_45517_(LightLayer.SKY, this.pos);
        this.updateSourceFacing();
        this.shaft1 = (RotatingData)rotatingMaterial.getModel(DestroyPartials.DCS_SIDE_SHAFT, blockEntity.m_58900_(), this.shaft1Direction).createInstance();
        this.shaft1.setRotationAxis(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.shaft1Direction.m_122434_()).m_253071_()).setRotationOffset(this.getRotationOffset(this.shaft1Direction.m_122434_()));
        this.transformShaft((KineticData)this.shaft1, this.shaft1Direction, blockLight, skyLight);
        this.grip1 = (RotatingData)rotatingMaterial.getModel(DestroyPartials.DCS_SIDE_GRIP, blockEntity.m_58900_(), this.shaft1Direction).createInstance();
        this.grip1.setRotationAxis(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.shaft1Direction.m_122434_()).m_253071_()).setRotationOffset(this.getAxis() == Direction.Axis.Z ? 90.0f : 0.0f);
        this.transformShaft((KineticData)this.grip1, this.shaft1Direction, blockLight, skyLight);
        this.gimbal1 = (ModelData)modelMaterial.getModel(DestroyPartials.DCS_GIMBAL, blockEntity.m_58900_(), this.shaft1Direction).createInstance();
        this.shaft2 = (RotatingData)rotatingMaterial.getModel(DestroyPartials.DCS_SIDE_SHAFT, blockEntity.m_58900_(), this.shaft2Direction).createInstance();
        this.shaft2.setRotationAxis(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.shaft2Direction.m_122434_()).m_253071_()).setRotationOffset(this.getRotationOffset(this.shaft2Direction.m_122434_())).setColor((KineticBlockEntity)blockEntity);
        this.transformShaft((KineticData)this.shaft2, this.shaft2Direction, blockLight, skyLight);
        this.grip2 = (RotatingData)rotatingMaterial.getModel(DestroyPartials.DCS_SIDE_GRIP, blockEntity.m_58900_(), this.shaft2Direction).createInstance();
        this.grip2.setRotationAxis(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.shaft2Direction.m_122434_()).m_253071_()).setRotationOffset(0.0f);
        this.transformShaft((KineticData)this.grip2, this.shaft2Direction, blockLight, skyLight);
        this.gimbal2 = (ModelData)modelMaterial.getModel(DestroyPartials.DCS_GIMBAL, blockEntity.m_58900_(), this.shaft2Direction).createInstance();
        this.centerShaft = (ModelData)modelMaterial.getModel(DestroyPartials.DCS_CENTER_SHAFT).createInstance();
    }

    public float getSpeed(Direction direction) {
        float speed = ((DoubleCardanShaftBlockEntity)this.blockEntity).getSpeed();
        if (speed != 0.0f && this.sourceFacing != null && this.sourceFacing.m_122421_() == direction.m_122421_() && direction != this.sourceFacing) {
            speed *= -1.0f;
        }
        return speed;
    }

    private void transformShaft(KineticData data, Direction face, int blockLight, int skyLight) {
        data.setRotationalSpeed(this.getSpeed(face)).setPosition(this.getInstancePosition()).setBlockLight(blockLight).setSkyLight(skyLight);
    }

    public void beginFrame() {
        Direction.Axis axis = this.getAxis();
        float gimbal1Angle = (float)Math.PI * (AnimationTickHolder.getRenderTime() * this.getSpeed(this.shaft1Direction) * 3.0f / 10.0f % 360.0f) / 180.0f;
        float gimbal2Angle = (float)Math.PI * (AnimationTickHolder.getRenderTime() * this.getSpeed(this.shaft2Direction) * 3.0f / 10.0f % 360.0f) / 180.0f;
        float fluctuatingAngle1 = (float)Math.atan2(Mth.m_14031_((float)gimbal1Angle), Mth.m_14089_((float)gimbal1Angle) * Mth.m_14116_((float)2.0f) / 2.0f) + (axis == Direction.Axis.Z ? 0.7853982f * (this.facesHaveSameSign() ? 1.0f : -1.0f) : 0.0f);
        float fluctuatingAngle2 = (float)Math.atan2(Mth.m_14031_((float)gimbal2Angle), Mth.m_14089_((float)gimbal2Angle) * Mth.m_14116_((float)2.0f) / 2.0f);
        float fluctuatingAngle3 = (float)Math.atan2(Mth.m_14031_((float)(gimbal1Angle + 1.5707964f)), Mth.m_14089_((float)(gimbal1Angle + 1.5707964f)) * Mth.m_14116_((float)2.0f) / 2.0f) + 1.5707964f;
        float gimbal1FluctuatingAngle = Mth.m_14031_((float)(fluctuatingAngle1 + (this.getAxis() == Direction.Axis.Z ? -0.7853982f : 0.0f) + (this.facesHaveSameSign() ^ (axis == Direction.Axis.X && this.shaft1Direction.m_122434_() == Direction.Axis.Z) ? (float)Math.PI : 0.0f) + (axis == Direction.Axis.X ? 1.5707964f : 0.0f))) * (float)Math.PI / 4.0f;
        float gimbal2FluctuatingAngle = Mth.m_14031_((float)(fluctuatingAngle2 + (this.facesHaveSameSign() ^ (axis == Direction.Axis.X && this.shaft2Direction.m_122434_() == Direction.Axis.Z) ? (float)Math.PI : 0.0f) + (axis == Direction.Axis.Z && !this.facesHaveSameSign() ? 1.5707964f : 0.0f) + (axis == Direction.Axis.X ? 1.5707964f : 0.0f))) * (float)Math.PI / 4.0f;
        ((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)this.centerShaft.loadIdentity().translate((Vec3i)this.getInstancePosition())).translate(this.shaft1Direction.m_253071_().mul(0.15625f))).translate(this.shaft2Direction.m_253071_().mul(0.15625f))).centre()).rotateY(axis == Direction.Axis.Z ? 90.0 : 0.0)).rotateX(axis == Direction.Axis.Z ? (double)(this.facesHaveSameSign() ? 45.0f : 135.0f) : 0.0)).rotate(this.facesHaveSameSign() ^ axis != Direction.Axis.Y ? 135.0 : 45.0, axis)).unCentre()).centre()).rotateZRadians((double)((axis == Direction.Axis.X ? fluctuatingAngle3 : fluctuatingAngle1) * (axis == Direction.Axis.X || axis == Direction.Axis.Y ^ this.facesHaveSameSign() ? 1.0f : -1.0f) * (axis == Direction.Axis.X ? -1.0f : 1.0f)))).unCentre();
        ((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)this.gimbal1.loadIdentity().translate((Vec3i)this.getInstancePosition())).centre()).rotate(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.shaft1Direction.m_122434_()), gimbal1Angle)).centre()).translateBack(DoubleCardanShaftInstance.gimbalTranslation(this.shaft1Direction))).rotate(DoubleCardanShaftInstance.gimbalRotation(this.shaft1Direction, axis == Direction.Axis.Z), gimbal1FluctuatingAngle)).rotateY(axis == Direction.Axis.Z && !this.secondaryPositive ? 90.0 : 0.0)).rotateX(axis == Direction.Axis.Z ? 90.0 : 0.0)).translate(DoubleCardanShaftInstance.gimbalTranslation(this.shaft1Direction))).unCentre()).unCentre();
        ((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)this.gimbal2.loadIdentity().translate((Vec3i)this.getInstancePosition())).centre()).rotate(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.shaft2Direction.m_122434_()), gimbal2Angle)).centre()).translateBack(DoubleCardanShaftInstance.gimbalTranslation(this.shaft2Direction))).rotate(DoubleCardanShaftInstance.gimbalRotation(this.shaft2Direction, false), gimbal2FluctuatingAngle)).translate(DoubleCardanShaftInstance.gimbalTranslation(this.shaft2Direction))).unCentre()).unCentre();
    }

    private boolean facesHaveSameSign() {
        return this.shaft1Direction.m_122421_() == this.shaft2Direction.m_122421_();
    }

    public static Vec3 gimbalTranslation(Direction face) {
        switch (face) {
            case NORTH: {
                return new Vec3(0.5, 0.5, 0.8125);
            }
            case EAST: {
                return new Vec3(0.1875, 0.5, 0.5);
            }
            case SOUTH: {
                return new Vec3(0.5, 0.5, 0.1875);
            }
            case WEST: {
                return new Vec3(0.8125, 0.5, 0.5);
            }
            case UP: {
                return new Vec3(0.5, 0.1875, 0.5);
            }
            case DOWN: {
                return new Vec3(0.5, 0.8125, 0.5);
            }
        }
        return new Vec3(0.5, 0.5, 0.5);
    }

    public static Direction gimbalRotation(Direction direction, boolean isZaxis) {
        switch (direction) {
            case NORTH: {
                return Direction.EAST;
            }
            case EAST: {
                return isZaxis ? Direction.UP : Direction.SOUTH;
            }
            case SOUTH: {
                return Direction.EAST;
            }
            case WEST: {
                return isZaxis ? Direction.UP : Direction.SOUTH;
            }
            case UP: {
                return isZaxis ? Direction.SOUTH : Direction.EAST;
            }
            case DOWN: {
                return isZaxis ? Direction.SOUTH : Direction.EAST;
            }
        }
        throw new IllegalStateException("Unknown direction");
    }

    protected void updateSourceFacing() {
        if (((DoubleCardanShaftBlockEntity)this.blockEntity).hasSource()) {
            BlockPos source = ((DoubleCardanShaftBlockEntity)this.blockEntity).source.m_121996_((Vec3i)this.pos);
            this.sourceFacing = Direction.m_122372_((float)source.m_123341_(), (float)source.m_123342_(), (float)source.m_123343_());
        } else {
            this.sourceFacing = null;
        }
    }

    private Direction.Axis getAxis() {
        ArrayList<Direction.Axis> axes = new ArrayList<Direction.Axis>();
        axes.addAll(List.of(Direction.Axis.values()));
        axes.remove(this.shaft1Direction.m_122434_());
        axes.remove(this.shaft2Direction.m_122434_());
        return (Direction.Axis)axes.get(0);
    }

    public void update() {
        super.update();
        this.updateSourceFacing();
        this.updateRotation(this.shaft1, this.shaft1Direction.m_122434_(), this.getSpeed(this.shaft1Direction));
        this.updateRotation(this.grip1, this.shaft1Direction.m_122434_(), this.getSpeed(this.shaft1Direction));
        this.grip1.setRotationOffset(this.getAxis() == Direction.Axis.Z ? 90.0f : 0.0f);
        this.updateRotation(this.shaft2, this.shaft2Direction.m_122434_(), this.getSpeed(this.shaft2Direction));
        this.updateRotation(this.grip2, this.shaft2Direction.m_122434_(), this.getSpeed(this.shaft2Direction));
        this.grip2.setRotationOffset(0.0f);
    }

    public void updateLight() {
        this.relight(this.pos, new FlatLit[]{this.shaft1, this.shaft2, this.grip1, this.grip2, this.gimbal1, this.gimbal2, this.centerShaft});
    }

    protected void remove() {
        this.shaft1.delete();
        this.shaft2.delete();
        this.grip1.delete();
        this.grip2.delete();
        this.gimbal1.delete();
        this.gimbal2.delete();
        this.centerShaft.delete();
    }
}

