/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block.instance;

import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.petrolpark.destroy.block.entity.PlanetaryGearsetBlockEntity;
import com.petrolpark.destroy.block.model.DestroyPartials;
import com.petrolpark.destroy.util.KineticsHelper;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityInstance;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntityRenderer;
import java.util.EnumMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PlanetaryGearsetInstance
extends KineticBlockEntityInstance<PlanetaryGearsetBlockEntity> {
    protected final RotatingData ringGear;
    protected final RotatingData sunGear;
    protected final EnumMap<Direction, RotatingData> keys;

    public PlanetaryGearsetInstance(MaterialManager materialManager, PlanetaryGearsetBlockEntity blockEntity) {
        super(materialManager, (KineticBlockEntity)blockEntity);
        BlockState blockState = blockEntity.m_58900_();
        Direction.Axis axis = KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)blockEntity);
        int blockLight = this.world.m_45517_(LightLayer.BLOCK, this.pos);
        int skyLight = this.world.m_45517_(LightLayer.SKY, this.pos);
        this.ringGear = (RotatingData)this.getRotatingMaterial().getModel(DestroyPartials.PG_RING_GEAR, blockState, Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis), () -> KineticsHelper.rotateToAxis(axis)).createInstance();
        this.ringGear.setRotationAxis(axis).setRotationOffset(this.getRotationOffset(axis)).setColor((KineticBlockEntity)blockEntity).setRotationalSpeed(this.getBlockEntitySpeed()).setPosition(this.getInstancePosition()).setBlockLight(blockLight).setSkyLight(skyLight);
        this.sunGear = (RotatingData)this.getRotatingMaterial().getModel(DestroyPartials.PG_SUN_GEAR, blockState, Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis), () -> KineticsHelper.rotateToAxis(axis)).createInstance();
        this.sunGear.setRotationAxis(axis).setRotationOffset(BracketedKineticBlockEntityRenderer.getShaftAngleOffset((Direction.Axis)axis, (BlockPos)this.pos)).setColor((KineticBlockEntity)blockEntity).setRotationalSpeed(-2.0f * this.getBlockEntitySpeed()).setPosition(this.getInstancePosition()).setBlockLight(blockLight).setSkyLight(skyLight);
        this.keys = new EnumMap(Direction.class);
        for (Direction direction : Direction.values()) {
            if (direction.m_122434_() == axis) continue;
            Instancer planetGear = this.getRotatingMaterial().getModel(DestroyPartials.PG_PLANET_GEAR, blockState, Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis), () -> KineticsHelper.rotateToAxis(axis));
            RotatingData key = (RotatingData)planetGear.createInstance();
            Vector3f position = new Vector3f((float)this.getInstancePosition().m_123341_(), (float)this.getInstancePosition().m_123342_(), (float)this.getInstancePosition().m_123343_());
            position.add((Vector3fc)direction.m_253071_().mul(0.390625f));
            key.setRotationAxis(axis).setRotationalSpeed(2.0f * this.getBlockEntitySpeed()).setRotationOffset(BracketedKineticBlockEntityRenderer.getShaftAngleOffset((Direction.Axis)axis, (BlockPos)this.pos)).setColor((KineticBlockEntity)blockEntity).setPosition(position).setBlockLight(blockLight).setSkyLight(skyLight);
            this.keys.put(direction, key);
        }
    }

    public void update() {
        Direction.Axis axis = KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)((KineticBlockEntity)this.blockEntity));
        this.updateRotation(this.ringGear, axis, this.getBlockEntitySpeed());
        this.updateRotation(this.sunGear, axis, -2.0f * this.getBlockEntitySpeed());
        this.sunGear.setRotationOffset(BracketedKineticBlockEntityRenderer.getShaftAngleOffset((Direction.Axis)axis, (BlockPos)this.pos));
        this.keys.values().forEach(gear -> {
            this.updateRotation((RotatingData)gear, axis, 2.0f * this.getBlockEntitySpeed());
            gear.setRotationOffset(BracketedKineticBlockEntityRenderer.getShaftAngleOffset((Direction.Axis)axis, (BlockPos)this.pos));
        });
    }

    public void updateLight() {
        this.relight(this.pos, new FlatLit[]{this.ringGear, this.sunGear});
        this.relight(this.pos, this.keys.values().stream());
    }

    protected void remove() {
        this.ringGear.delete();
        this.sunGear.delete();
        this.keys.values().forEach(InstanceData::delete);
        this.keys.clear();
    }
}

