/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block.instance;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.petrolpark.destroy.block.PumpjackBlock;
import com.petrolpark.destroy.block.entity.PumpjackBlockEntity;
import com.petrolpark.destroy.block.model.DestroyPartials;
import com.simibubi.create.foundation.utility.AngleHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PumpjackInstance
extends BlockEntityInstance<PumpjackBlockEntity>
implements DynamicInstance {
    protected final ModelData cam;
    protected final ModelData linkage;
    protected final ModelData beam;
    protected final ModelData pump;

    public PumpjackInstance(MaterialManager materialManager, PumpjackBlockEntity blockEntity) {
        super(materialManager, (BlockEntity)blockEntity);
        this.cam = (ModelData)materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(DestroyPartials.PUMPJACK_CAM, this.blockState).createInstance();
        this.linkage = (ModelData)materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(DestroyPartials.PUMPJACK_LINKAGE, this.blockState).createInstance();
        this.beam = (ModelData)materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(DestroyPartials.PUMPJACK_BEAM, this.blockState).createInstance();
        this.pump = (ModelData)materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(DestroyPartials.PUMPJACK_PUMP, this.blockState).createInstance();
    }

    public void beginFrame() {
        Float angle = ((PumpjackBlockEntity)this.blockEntity).getTargetAngle();
        if (angle == null) {
            this.cam.setEmptyTransform();
            this.linkage.setEmptyTransform();
            this.beam.setEmptyTransform();
            this.pump.setEmptyTransform();
            return;
        }
        Direction facing = PumpjackBlock.getFacing(this.blockState);
        ((ModelData)((ModelData)((ModelData)((ModelData)this.transformed(this.cam, facing).translate(0.0, 0.0, 1.0).centre()).rotateXRadians((double)(angle.floatValue() - 1.5707964f))).centre()).translate(0.0, 0.0, -1.0).unCentre()).unCentre();
        ((ModelData)((ModelData)((ModelData)((ModelData)this.transformed(this.linkage, facing).translate(0.0, -0.3125, 1.0).translate(0.0, (double)(Mth.m_14031_((float)angle.floatValue()) * 5.0f) / 16.0, (double)(-Mth.m_14089_((float)angle.floatValue()) * 5.0f) / 16.0).centre()).rotateX((double)Mth.m_14089_((float)angle.floatValue()) * 10.0)).centre()).translate(0.0, 0.0, -1.0).unCentre()).unCentre();
        ((ModelData)((ModelData)((ModelData)((ModelData)this.transformed(this.beam, facing).translate(0.0, 1.0, 0.0).centre()).rotateX((double)(Mth.m_14031_((float)angle.floatValue()) - 1.0f) * -18.0)).centre()).translate(0.0, -1.0, 0.0).unCentre()).unCentre();
        this.transformed(this.pump, facing).translate(0.0, 0.0 - (double)(Mth.m_14031_((float)angle.floatValue()) * 3.0f) / 16.0, 0.0);
    }

    protected ModelData transformed(ModelData modelData, Direction facing) {
        return (ModelData)((ModelData)((ModelData)((ModelData)modelData.loadIdentity().translate((Vec3i)this.getInstancePosition())).centre()).rotateY((double)AngleHelper.horizontalAngle((Direction)facing))).unCentre();
    }

    public void updateLight() {
        this.relight(this.pos.m_7494_(), new FlatLit[]{this.cam, this.linkage, this.beam, this.pump});
    }

    protected void remove() {
        this.cam.delete();
        this.linkage.delete();
        this.beam.delete();
        this.pump.delete();
    }
}

