/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block.movementbehaviour;

import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.petrolpark.destroy.advancement.DestroyAdvancements;
import com.petrolpark.destroy.block.DestroyBlocks;
import com.petrolpark.destroy.block.entity.behaviour.DestroyAdvancementBehaviour;
import com.petrolpark.destroy.block.movementbehaviour.ExtrudedBlockModel;
import com.petrolpark.destroy.util.BlockExtrusion;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.OrientedContraptionEntity;
import com.simibubi.create.content.contraptions.behaviour.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.render.BakedModelRenderHelper;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ExtrudableMovementBehaviour
implements MovementBehaviour {
    private final BlockExtrusion extrusion;

    public ExtrudableMovementBehaviour(BlockExtrusion extrusion) {
        this.extrusion = extrusion;
    }

    public void onSpeedChanged(MovementContext context, Vec3 oldMotion, Vec3 motion) {
        Direction direction;
        CompoundTag data = context.data;
        if (data.m_128471_("Extruding") && !VecHelper.isVecPointingTowards((Vec3)motion, (Direction)(direction = ExtrudableMovementBehaviour.getDirection(context))) && !VecHelper.isVecPointingTowards((Vec3)motion, (Direction)direction.m_122424_())) {
            this.abandonExtrusion(context);
        }
    }

    public void visitNewPosition(MovementContext context, BlockPos pos) {
        BlockState dieState = context.world.m_8055_(pos);
        CompoundTag data = context.data;
        if (DestroyBlocks.EXTRUSION_DIE.has(dieState) && !data.m_128471_("Extruding") && !data.m_128471_("Extruded")) {
            Direction.Axis axis = (Direction.Axis)dieState.m_61143_((Property)BlockStateProperties.f_61365_);
            for (Direction.AxisDirection axisDirection : Direction.AxisDirection.values()) {
                Direction direction = Direction.m_122390_((Direction.AxisDirection)axisDirection, (Direction.Axis)axis);
                BlockState state = this.extrusion.getExtruded(context.state, direction);
                if (!VecHelper.isVecPointingTowards((Vec3)context.relativeMotion, (Direction)direction) || state.m_60795_()) continue;
                data.m_128379_("Extruding", true);
                data.m_128405_("ExtrusionDirection", direction.ordinal());
                data.m_128365_("ExtrusionDiePos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
                data.m_128365_("ExtrudedBlockState", (Tag)NbtUtils.m_129202_((BlockState)state));
                break;
            }
        } else if (data.m_128471_("Extruding")) {
            OrientedContraptionEntity oce;
            BlockPos diePos = NbtUtils.m_129239_((CompoundTag)data.m_128469_("ExtrusionDiePos"));
            Direction direction = ExtrudableMovementBehaviour.getDirection(context);
            AbstractContraptionEntity abstractContraptionEntity = context.contraption.entity;
            if (abstractContraptionEntity instanceof OrientedContraptionEntity && (oce = (OrientedContraptionEntity)abstractContraptionEntity).getInitialYaw() != oce.yaw) {
                direction = direction.m_122424_();
            }
            if (pos.equals((Object)diePos.m_121945_(direction))) {
                DestroyAdvancementBehaviour advancementBehaviour;
                context.contraption.getBlocks().put(context.localPos, new StructureTemplate.StructureBlockInfo(context.localPos, ExtrudableMovementBehaviour.getBlockState(context), null));
                if (!context.world.m_5776_() && (advancementBehaviour = (DestroyAdvancementBehaviour)BlockEntityBehaviour.get((BlockGetter)context.world, (BlockPos)diePos, DestroyAdvancementBehaviour.TYPE)) != null) {
                    advancementBehaviour.awardDestroyAdvancement(DestroyAdvancements.EXTRUDE);
                }
                data.m_128379_("Extruded", true);
            }
            this.abandonExtrusion(context);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        CompoundTag data = context.data;
        if (!data.m_128471_("Extruding") && !data.m_128471_("Extruded")) {
            return;
        }
        PoseStack ms = matrices.getViewProjection();
        PoseStack modelTransform = matrices.getModel();
        VertexConsumer vbSolid = buffer.m_6299_(RenderType.m_110451_());
        Direction direction = ExtrudableMovementBehaviour.getDirection(context);
        float progress = 0.0f;
        if (data.m_128471_("Extruded")) {
            progress = 0.0f;
        } else {
            OrientedContraptionEntity oce;
            BlockPos diePos = NbtUtils.m_129239_((CompoundTag)data.m_128469_("ExtrusionDiePos"));
            Vec3 displacement = context.position.m_82546_(Vec3.m_82528_((Vec3i)diePos));
            progress = (float)direction.m_122434_().m_6150_(displacement.m_7096_(), displacement.m_7098_(), displacement.m_7094_());
            boolean invertProgess = direction.m_122421_() == Direction.AxisDirection.POSITIVE;
            AbstractContraptionEntity abstractContraptionEntity = context.contraption.entity;
            if (abstractContraptionEntity instanceof OrientedContraptionEntity && oce.yaw != (oce = (OrientedContraptionEntity)abstractContraptionEntity).getInitialYaw()) {
                boolean bl = invertProgess = !invertProgess;
            }
            if (invertProgess) {
                progress = 1.0f - progress;
            }
        }
        ms.m_85836_();
        ExtrudedBlockModel model = new ExtrudedBlockModel(ExtrudableMovementBehaviour.getBlockState(context), direction, progress);
        SuperByteBuffer extrudedBlockBuffer = BakedModelRenderHelper.standardModelRender((BakedModel)model, (BlockState)Blocks.f_50016_.m_49966_());
        if (modelTransform != null) {
            extrudedBlockBuffer.transform(modelTransform);
        }
        extrudedBlockBuffer.renderInto(ms, vbSolid);
        ms.m_85849_();
    }

    private void abandonExtrusion(MovementContext context) {
        CompoundTag data = context.data;
        data.m_128379_("Extruding", false);
        data.m_128473_("ExtrusionDiePos");
        data.m_128473_("ExtrusionDirection");
    }

    private static Direction getDirection(MovementContext context) {
        return Direction.values()[context.data.m_128451_("ExtrusionDirection")];
    }

    private static BlockState getBlockState(MovementContext context) {
        if (!context.data.m_128441_("ExtrudedBlockState")) {
            return Blocks.f_50016_.m_49966_();
        }
        return NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)context.data.m_128469_("ExtrudedBlockState"));
    }
}

