/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block.movementbehaviour;

import com.simibubi.create.content.decoration.copycat.CopycatModel;
import com.simibubi.create.foundation.model.BakedModelHelper;
import com.simibubi.create.foundation.model.BakedQuadHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.EmptyModel;
import net.minecraftforge.client.model.data.ModelData;

public class ExtrudedBlockModel
extends CopycatModel {
    protected static final AABB CUBE_AABB = new AABB(BlockPos.f_121853_);
    private final BlockState extrusionResult;
    private final Direction movementDirection;
    private final float progress;

    public ExtrudedBlockModel(BlockState extrusionResult, Direction movementDirection, float progress) {
        super(EmptyModel.BAKED);
        this.extrusionResult = extrusionResult;
        this.movementDirection = movementDirection;
        this.progress = progress;
    }

    protected List<BakedQuad> getCroppedQuads(BlockState state, Direction side, RandomSource rand, BlockState material, ModelData wrappedData, RenderType renderType) {
        BakedModel model = ExtrudedBlockModel.getModelOf((BlockState)this.extrusionResult);
        List templateQuads = model.getQuads(this.extrusionResult, side, rand, wrappedData, renderType);
        int size = templateQuads.size();
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Vec3 normal = Vec3.m_82528_((Vec3i)this.movementDirection.m_122424_().m_122436_());
        AABB bb = CUBE_AABB.m_82310_(normal.f_82479_ * (double)this.progress, normal.f_82480_ * (double)this.progress, normal.f_82481_ * (double)this.progress);
        for (int i = 0; i < size; ++i) {
            BakedQuad quad = (BakedQuad)templateQuads.get(i);
            quads.add(BakedQuadHelper.cloneWithCustomGeometry((BakedQuad)quad, (int[])ExtrudedBlockModel.scale(BakedModelHelper.cropAndMove((int[])quad.m_111303_(), (TextureAtlasSprite)quad.m_173410_(), (AABB)bb, (Vec3)Vec3.f_82478_), 1.01f)));
        }
        return quads;
    }

    public static int[] scale(int[] vertexData, float factor) {
        vertexData = Arrays.copyOf(vertexData, vertexData.length);
        for (int vertex = 0; vertex < 4; ++vertex) {
            Vec3 xyz = BakedQuadHelper.getXYZ((int[])vertexData, (int)vertex);
            BakedQuadHelper.setXYZ((int[])vertexData, (int)vertex, (Vec3)xyz.m_82492_(0.5, 0.5, 0.5).m_82490_((double)factor).m_82520_(0.5, 0.5, 0.5));
        }
        return vertexData;
    }
}

