/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block.renderer;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.petrolpark.destroy.Destroy;
import com.petrolpark.destroy.block.entity.AgingBarrelBlockEntity;
import com.petrolpark.destroy.util.DestroyTags;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.simibubi.create.foundation.fluid.FluidRenderer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class AgingBarrelRenderer
extends SmartBlockEntityRenderer<AgingBarrelBlockEntity> {
    private static float minY = 0.125f;

    public AgingBarrelRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(AgingBarrelBlockEntity barrel, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((SmartBlockEntity)barrel, partialTicks, ms, buffer, light, overlay);
        float fluidLevel = this.renderFluid(barrel, partialTicks, ms, buffer, light, overlay);
        ms.m_85836_();
        ms.m_252880_(0.5f, 0.0f, 0.5f);
        IItemHandlerModifiable inv = (IItemHandlerModifiable)barrel.itemCapability.orElse((Object)new ItemStackHandler());
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        boolean renderYeast = false;
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            if (inv.getStackInSlot(slot).m_41619_()) continue;
            if (inv.getStackInSlot(slot).m_204117_(DestroyTags.DestroyItemTags.YEAST.tag) && !renderYeast) {
                renderYeast = true;
                continue;
            }
            itemStacks.add(inv.getStackInSlot(slot));
        }
        float anglePartition = 360.0f / (float)itemStacks.size();
        for (int i = itemStacks.size(); i > 0; --i) {
            if (((ItemStack)itemStacks.get(i - 1)).m_41619_()) continue;
            ms.m_85836_();
            if (fluidLevel != minY) {
                ms.m_252880_(0.0f, (Mth.m_14031_((float)(AnimationTickHolder.getRenderTime((LevelAccessor)barrel.m_58904_()) / 12.0f + anglePartition * (float)i)) + 1.5f) * 1.0f / 32.0f, 0.0f);
            }
            Vec3 itemPosition = VecHelper.rotate((Vec3)new Vec3(itemStacks.size() == 1 ? 0.0 : (double)0.1f, (double)Mth.m_14036_((float)(fluidLevel - 0.05f), (float)0.125f, (float)0.8f), 0.0), (double)(anglePartition * (float)i), (Direction.Axis)Direction.Axis.Y);
            ms.m_85837_(itemPosition.f_82479_, itemPosition.f_82480_, itemPosition.f_82481_);
            ((TransformStack)TransformStack.cast((PoseStack)ms).rotateY((double)(anglePartition * (float)i + 35.0f))).rotateX(65.0);
            this.renderItem(barrel, partialTicks, ms, buffer, light, overlay, (ItemStack)itemStacks.get(i - 1));
            ms.m_85849_();
        }
        ms.m_85849_();
        ms.m_85836_();
        if (renderYeast) {
            FluidRenderer.renderStillTiledFace((Direction)Direction.UP, (float)0.125f, (float)0.125f, (float)0.875f, (float)0.875f, (float)(fluidLevel + 0.01f), (VertexConsumer)FluidRenderer.getFluidBuilder((MultiBufferSource)buffer), (PoseStack)ms, (int)light, (int)-1, (TextureAtlasSprite)((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(Destroy.asResource("block/yeast_overlay"))));
        }
        ms.m_85849_();
    }

    protected void renderItem(AgingBarrelBlockEntity barrel, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay, ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.GROUND, light, overlay, ms, buffer, barrel.m_58904_(), 0);
    }

    protected float renderFluid(AgingBarrelBlockEntity barrel, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        SmartFluidTankBehaviour.TankSegment tank = barrel.getTankToRender();
        float units = tank.getTotalUnits(partialTicks);
        float maxY = minY + Mth.m_14036_((float)(units / (float)barrel.getTank().getCapacity()), (float)0.0f, (float)1.0f) * 8.0f / 12.0f;
        if (units < 1.0f) {
            return minY;
        }
        FluidRenderer.renderFluidBox((FluidStack)tank.getRenderedFluid(), (float)0.125f, (float)minY, (float)0.125f, (float)0.875f, (float)maxY, (float)0.875f, (MultiBufferSource)buffer, (PoseStack)ms, (int)light, (boolean)false);
        return maxY;
    }

    public int m_142163_() {
        return 16;
    }
}

