/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.petrolpark.destroy.block.BubbleCapBlock;
import com.petrolpark.destroy.block.entity.BubbleCapBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.simibubi.create.foundation.fluid.FluidRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.FluidStack;

public class BubbleCapRenderer
extends SmartBlockEntityRenderer<BubbleCapBlockEntity> {
    public BubbleCapRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(BubbleCapBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((SmartBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        SmartFluidTankBehaviour.TankSegment visualTank = be.getTankToRender();
        if (!visualTank.isEmpty(partialTicks)) {
            boolean bottom = (Boolean)be.m_58900_().m_61143_((Property)BubbleCapBlock.BOTTOM);
            boolean top = (Boolean)be.m_58900_().m_61143_((Property)BubbleCapBlock.TOP);
            float bottomLevel = 0.0f;
            float centerLevel = 0.0f;
            float tolevel = 0.0f;
            float totalLevel = Mth.m_14036_((float)(visualTank.getTotalUnits(partialTicks) / (float)be.getTank().getCapacity()), (float)0.0f, (float)1.0f);
            if (bottom && top) {
                centerLevel = totalLevel;
            } else if (bottom && !top) {
                centerLevel = Math.min(1.0f, totalLevel * 1.3f);
                tolevel = Math.max(0.0f, totalLevel - 0.7692308f) * 4.3333335f;
            } else if (!bottom && !top) {
                bottomLevel = Math.min(1.0f, totalLevel * 5.3333335f);
                centerLevel = Math.min(1.0f, Math.max(0.0f, totalLevel - 0.1875f) * 1.6f);
                tolevel = Math.max(0.0f, totalLevel - 0.8125f) * 5.3333335f;
            } else if (!bottom && top) {
                bottomLevel = Math.min(1.0f, totalLevel * 4.3333335f);
                centerLevel = Math.max(0.0f, totalLevel - 0.23076923f) * 1.3f;
            }
            if (!bottom && bottomLevel > 0.0f) {
                FluidRenderer.renderFluidBox((FluidStack)visualTank.getRenderedFluid(), (float)0.25f, (float)0.0f, (float)0.25f, (float)0.75f, (float)(0.0f + bottomLevel * 3.0f / 16.0f), (float)0.75f, (MultiBufferSource)buffer, (PoseStack)ms, (int)light, (boolean)true);
            }
            if (centerLevel > 0.0f) {
                FluidRenderer.renderFluidBox((FluidStack)visualTank.getRenderedFluid(), (float)0.1875f, (float)0.1875f, (float)0.1875f, (float)0.8125f, (float)(0.1875f + centerLevel * 10.0f / 16.0f), (float)0.8125f, (MultiBufferSource)buffer, (PoseStack)ms, (int)light, (boolean)true);
            }
            if (!top && tolevel > 0.0f) {
                FluidRenderer.renderFluidBox((FluidStack)visualTank.getRenderedFluid(), (float)0.25f, (float)0.8125f, (float)0.25f, (float)0.75f, (float)(0.8125f + tolevel * 3.0f / 16.0f), (float)0.75f, (MultiBufferSource)buffer, (PoseStack)ms, (int)light, (boolean)false);
            }
        }
    }
}

