/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block.renderer;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.petrolpark.destroy.block.IChainableBlock;
import com.petrolpark.destroy.block.entity.ChainedCogwheelBlockEntity;
import com.petrolpark.destroy.block.model.DestroyPartials;
import com.petrolpark.destroy.util.MathsHelper;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.simpleRelays.SimpleKineticBlockEntity;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ChainedCogwheelRenderer
extends KineticBlockEntityRenderer<ChainedCogwheelBlockEntity> {
    public static final double linkLength = 0.25;

    public ChainedCogwheelRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(ChainedCogwheelBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (Backend.canUseInstancing((Level)be.m_58904_())) {
            return;
        }
        BlockState state = this.getRenderedBlockState(be);
        if (state == null) {
            return;
        }
        Direction.Axis axis = ChainedCogwheelRenderer.getRotationAxisOf((KineticBlockEntity)be);
        VertexConsumer vc = buffer.m_6299_(RenderType.m_110451_());
        Direction facing = Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)be.m_58904_());
        float targetAngle = time * be.getSpeed() * 3.0f / 10.0f % 360.0f;
        if (be.controller && be.m_58898_()) {
            BlockEntity otherBE = be.m_58904_().m_7702_(new BlockPos(MathsHelper.add((Vec3i)be.m_58899_(), (Vec3i)be.partner)));
            if (!(otherBE instanceof ChainedCogwheelBlockEntity)) {
                return;
            }
            ChainedCogwheelBlockEntity otherCBE = (ChainedCogwheelBlockEntity)otherBE;
            ms.m_85836_();
            for (Pair<Vec3, Double> posAndRot : ChainedCogwheelRenderer.getLinkPositionsAndRotations(axis, state, be.partner, otherCBE.copiedState, targetAngle)) {
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBufferer.partial((PartialModel)DestroyPartials.CHAIN_LINK, (BlockState)state).translate((Vec3)posAndRot.getFirst())).rotate((Double)posAndRot.getSecond() + (axis == Direction.Axis.Z ? 90.0 : 0.0), axis)).rotateX(axis == Direction.Axis.Z ? 90.0 : 0.0)).rotateZ(axis == Direction.Axis.X ? 90.0 : 0.0)).renderInto(ms, vc);
            }
            ms.m_85849_();
        }
        if (AllBlocks.LARGE_COGWHEEL.has(state)) {
            ChainedCogwheelRenderer.renderRotatingBuffer((KineticBlockEntity)be, (SuperByteBuffer)CachedBufferer.partialFacingVertical((PartialModel)AllPartialModels.SHAFTLESS_LARGE_COGWHEEL, (BlockState)be.m_58900_(), (Direction)facing), (PoseStack)ms, (VertexConsumer)vc, (int)light);
            float angle = BracketedKineticBlockEntityRenderer.getAngleForLargeCogShaft((SimpleKineticBlockEntity)be, (Direction.Axis)axis);
            SuperByteBuffer shaft = CachedBufferer.partialFacingVertical((PartialModel)AllPartialModels.COGWHEEL_SHAFT, (BlockState)be.m_58900_(), (Direction)facing);
            ChainedCogwheelRenderer.kineticRotationTransform((SuperByteBuffer)shaft, (KineticBlockEntity)be, (Direction.Axis)axis, (float)angle, (int)light);
            shaft.renderInto(ms, vc);
        } else {
            super.renderSafe((KineticBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        }
    }

    public static List<Pair<Vec3, Double>> getLinkPositionsAndRotations(Direction.Axis axis, BlockState thisCog, BlockPos otherPos, BlockState otherCog, float cogAngle) {
        Vec3 thisCenter = IChainableBlock.getRelativeCenterOfRotation(thisCog);
        Vec3 thatCenter = Vec3.m_82528_((Vec3i)otherPos).m_82549_(IChainableBlock.getRelativeCenterOfRotation(otherCog));
        Vec3 thisToThat = thatCenter.m_82546_(thisCenter);
        double d = thisToThat.m_82553_();
        double r1 = IChainableBlock.getRadius(thisCog);
        double r2 = IChainableBlock.getRadius(otherCog);
        double l = Math.sqrt(d * d - (r1 - r2) * (r1 - r2));
        Vec3 forward = new Vec3(axis == Direction.Axis.Y ? Direction.EAST.m_253071_() : Direction.UP.m_253071_());
        Vec3 up = new Vec3(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis).m_253071_());
        double angleToThat = MathsHelper.angleBetween(forward, thatCenter.m_82546_(thisCenter), up);
        double angle1 = Math.acos((r1 - r2) / d) * 180.0 / 3.1415927410125732;
        double angle2 = 180.0 - angle1;
        ArrayList<Pair<Vec3, Double>> pandrs = new ArrayList<Pair<Vec3, Double>>();
        return pandrs;
    }

    protected BlockState getRenderedBlockState(ChainedCogwheelBlockEntity be) {
        return be.copiedState;
    }
}

