/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block.renderer;

import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.petrolpark.destroy.block.entity.CoolerBlockEntity;
import com.petrolpark.destroy.block.model.DestroyPartials;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class CoolerRenderer
extends SafeBlockEntityRenderer<CoolerBlockEntity> {
    public CoolerRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(CoolerBlockEntity cooler, float partialTicks, PoseStack ms, MultiBufferSource bufferSource, int light, int overlay) {
        CoolerBlockEntity.ColdnessLevel coldnessLevel = cooler.getColdnessFromBlock();
        if (coldnessLevel == CoolerBlockEntity.ColdnessLevel.NONE) {
            return;
        }
        Level level = cooler.m_58904_();
        BlockState blockState = cooler.m_58900_();
        float animation = cooler.getHeadAnimation().getValue(partialTicks) * 0.175f;
        float horizontalAngle = AngleHelper.rad((double)cooler.getHeadAngle().getValue(partialTicks));
        int hashCode = ((Object)((Object)cooler)).hashCode();
        CoolerRenderer.renderShared(ms, null, bufferSource, level, blockState, coldnessLevel, animation, horizontalAngle, hashCode);
    }

    private static void renderShared(PoseStack ms, @Nullable PoseStack modelTransform, MultiBufferSource bufferSource, Level level, BlockState blockState, CoolerBlockEntity.ColdnessLevel coldnessLevel, float headAnimation, float headAngle, int hashCode) {
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)level);
        float renderTick = time + (float)(hashCode % 13) * 16.0f;
        float bobbing = Mth.m_14031_((float)((float)((double)(renderTick / 16.0f) % (Math.PI * 2)))) / 64.0f;
        float shivering = (coldnessLevel == CoolerBlockEntity.ColdnessLevel.FROSTING ? Mth.m_14031_((float)((float)((double)(renderTick * 3.0f) % (Math.PI * 2)))) / 24.0f : 0.0f) * Mth.m_14031_((float)(renderTick / 8.0f % ((float)Math.PI * 2)));
        float headY = bobbing - headAnimation * 0.75f;
        headAngle += shivering;
        ms.m_85836_();
        SuperByteBuffer headBuffer = CachedBufferer.partial((PartialModel)DestroyPartials.STRAY_SKULL, (BlockState)blockState);
        if (modelTransform != null) {
            headBuffer.transform(modelTransform);
        }
        headBuffer.translate(0.0, (double)headY, 0.0);
        CoolerRenderer.draw(headBuffer, headAngle, ms, bufferSource.m_6299_(RenderType.m_110463_()));
        ms.m_85849_();
    }

    private static void draw(SuperByteBuffer buffer, float horizontalAngle, PoseStack ms, VertexConsumer vc) {
        buffer.rotateCentered(Direction.UP, horizontalAngle).light(0xF000F0).renderInto(ms, vc);
    }
}

