/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block.renderer;

import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.petrolpark.destroy.block.DynamoBlock;
import com.petrolpark.destroy.block.entity.DynamoBlockEntity;
import com.petrolpark.destroy.block.model.DestroyPartials;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class DynamoRenderer
extends KineticBlockEntityRenderer<DynamoBlockEntity> {
    public DynamoRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(DynamoBlockEntity dynamo, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((KineticBlockEntity)dynamo, partialTicks, ms, buffer, light, overlay);
        if (!dynamo.isRunning() && dynamo.soundDuration <= 0 || !dynamo.m_58898_()) {
            return;
        }
        RandomSource rand = dynamo.m_58904_().m_213780_();
        if (rand.m_188501_() > 0.1f) {
            return;
        }
        boolean northSouthAligned = ((Direction)dynamo.m_58900_().m_61143_((Property)DynamoBlock.FACING)).m_122434_() == Direction.Axis.Z;
        Vec3 electrodePos1 = Vec3.m_82528_((Vec3i)dynamo.m_58899_()).m_82520_(northSouthAligned ? 0.1875 : 0.5, -0.125, northSouthAligned ? 0.5 : 0.1875);
        Vec3 electrodePos2 = Vec3.m_82528_((Vec3i)dynamo.m_58899_()).m_82520_(northSouthAligned ? 0.8125 : 0.5, -0.125, northSouthAligned ? 0.5 : 0.8125);
        Vec3 targetPos = dynamo.getLightningTargetPosition();
        for (boolean whichElectrode : Iterate.trueAndFalse) {
            Vec3 electrodePos = whichElectrode ? electrodePos1 : electrodePos2;
            Vec3 directPath = targetPos.m_82546_(electrodePos);
            Vec3 firstRandomPos = this.randomPointOnPlane(directPath, electrodePos.m_82549_(directPath.m_82490_((double)(rand.m_188501_() / 2.0f))), 0.5f, rand);
            Vec3 secondRandomPos = this.randomPointOnPlane(directPath, electrodePos.m_82549_(directPath.m_82490_((double)(0.5f + rand.m_188501_() / 2.0f))), 0.5f, rand);
            CreateClient.OUTLINER.showLine((Object)("dynamo_line_0_" + (whichElectrode ? "0" : "1")), electrodePos, firstRandomPos).colored(10744055).lineWidth(0.015625f).disableCull();
            CreateClient.OUTLINER.showLine((Object)("dynamo_line_1_" + (whichElectrode ? "0" : "1")), firstRandomPos, secondRandomPos).colored(10744055).lineWidth(0.015625f).disableCull();
            CreateClient.OUTLINER.showLine((Object)("dynamo_line_2_" + (whichElectrode ? "0" : "1")), secondRandomPos, targetPos).colored(10744055).lineWidth(0.015625f).disableCull();
        }
    }

    private Vec3 randomPointOnPlane(Vec3 normal, Vec3 pointOnPlane, float roughDiameter, RandomSource rand) {
        double radius = roughDiameter / 2.0f;
        double d = normal.m_82526_(pointOnPlane);
        double x = pointOnPlane.f_82479_ - radius + (double)(rand.m_188501_() * roughDiameter);
        double z = pointOnPlane.f_82481_ - radius + (double)(rand.m_188501_() * roughDiameter);
        return new Vec3(x, (d - normal.f_82479_ * x - normal.f_82481_ * z) / normal.f_82480_, z);
    }

    protected SuperByteBuffer getRotatedModel(DynamoBlockEntity be, BlockState state) {
        return CachedBufferer.partial((PartialModel)DestroyPartials.DYNAMO_COG, (BlockState)state);
    }
}

