/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block.renderer;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.petrolpark.destroy.block.entity.PlanetaryGearsetBlockEntity;
import com.petrolpark.destroy.block.model.DestroyPartials;
import com.petrolpark.destroy.util.KineticsHelper;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PlanetaryGearsetRenderer
extends KineticBlockEntityRenderer<PlanetaryGearsetBlockEntity> {
    public PlanetaryGearsetRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(PlanetaryGearsetBlockEntity planetaryGearsetBlockEntity, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (Backend.canUseInstancing((Level)planetaryGearsetBlockEntity.m_58904_())) {
            return;
        }
        BlockState state = this.getRenderedBlockState((KineticBlockEntity)planetaryGearsetBlockEntity);
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)RotatedPillarKineticBlock.AXIS);
        VertexConsumer vbSolid = buffer.m_6299_(RenderType.m_110451_());
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)planetaryGearsetBlockEntity.m_58904_());
        float offset1 = (float)Math.PI * PlanetaryGearsetRenderer.getRotationOffsetForPosition((KineticBlockEntity)planetaryGearsetBlockEntity, (BlockPos)planetaryGearsetBlockEntity.m_58899_(), (Direction.Axis)axis) / 180.0f;
        float offset2 = (float)Math.PI * BracketedKineticBlockEntityRenderer.getShaftAngleOffset((Direction.Axis)axis, (BlockPos)planetaryGearsetBlockEntity.m_58899_()) / 180.0f;
        float angle = (time * planetaryGearsetBlockEntity.getSpeed() * 3.0f / 10.0f + offset1) % 360.0f / 180.0f * (float)Math.PI;
        SuperByteBuffer ringGear = CachedBufferer.partialDirectional((PartialModel)DestroyPartials.PG_RING_GEAR, (BlockState)state, (Direction)Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis), () -> KineticsHelper.rotateToAxis(axis));
        PlanetaryGearsetRenderer.kineticRotationTransform((SuperByteBuffer)ringGear, (KineticBlockEntity)planetaryGearsetBlockEntity, (Direction.Axis)axis, (float)(angle + offset1), (int)light);
        ringGear.renderInto(ms, vbSolid);
        SuperByteBuffer sunGear = CachedBufferer.partialDirectional((PartialModel)DestroyPartials.PG_SUN_GEAR, (BlockState)state, (Direction)Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis), () -> KineticsHelper.rotateToAxis(axis));
        PlanetaryGearsetRenderer.kineticRotationTransform((SuperByteBuffer)sunGear, (KineticBlockEntity)planetaryGearsetBlockEntity, (Direction.Axis)axis, (float)(-2.0f * angle + offset2), (int)light);
        sunGear.renderInto(ms, vbSolid);
        for (Direction direction : Direction.values()) {
            if (direction.m_122434_() == axis) continue;
            SuperByteBuffer planetGear = CachedBufferer.partialDirectional((PartialModel)DestroyPartials.PG_PLANET_GEAR, (BlockState)state, (Direction)Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis), () -> KineticsHelper.rotateToAxis(axis));
            planetGear.translate(direction.m_253071_().mul(0.390625f));
            PlanetaryGearsetRenderer.kineticRotationTransform((SuperByteBuffer)planetGear, (KineticBlockEntity)planetaryGearsetBlockEntity, (Direction.Axis)axis, (float)(2.0f * angle + offset2), (int)light);
            planetGear.renderInto(ms, vbSolid);
        }
    }
}

