/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block.renderer;

import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.petrolpark.destroy.block.entity.DestroyBlockEntityTypes;
import com.petrolpark.destroy.block.entity.VatControllerBlockEntity;
import com.petrolpark.destroy.block.entity.VatSideBlockEntity;
import com.petrolpark.destroy.block.model.DestroyPartials;
import com.petrolpark.destroy.util.vat.Vat;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.fluid.FluidRenderer;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;

public class VatRenderer
extends SafeBlockEntityRenderer<VatControllerBlockEntity> {
    private static final float dialPivot = 0.5f;

    public VatRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(VatControllerBlockEntity controller, float partialTicks, PoseStack ms, MultiBufferSource bufferSource, int light, int overlay) {
        if (!controller.m_58898_() || !controller.getVatOptional().isPresent()) {
            return;
        }
        Vat vat = controller.getVatOptional().get();
        BlockState state = controller.m_58900_();
        VertexConsumer vbSolid = bufferSource.m_6299_(RenderType.m_110451_());
        VertexConsumer vbCutout = bufferSource.m_6299_(RenderType.m_110463_());
        SmartInventory inv = controller.inventory;
        Vec3 relativeInternalLowerCorner = Vec3.m_82528_((Vec3i)vat.getInternalLowerCorner().m_121996_((Vec3i)controller.m_58899_()));
        Vec3 relativeInternalUpperCorner = Vec3.m_82528_((Vec3i)vat.getUpperCorner().m_121996_((Vec3i)controller.m_58899_()));
        float fluidLevel = controller.getRenderedFluidLevel(partialTicks);
        float relativeFluidLevel = (float)(relativeInternalLowerCorner.m_7098_() + (double)fluidLevel);
        block6: for (BlockPos sidePos : vat.getSideBlockPositions()) {
            Optional vatSideOptional = controller.m_58904_().m_141902_(sidePos, (BlockEntityType)DestroyBlockEntityTypes.VAT_SIDE.get());
            if (vatSideOptional.isEmpty()) continue;
            VatSideBlockEntity vatSide = (VatSideBlockEntity)((Object)vatSideOptional.get());
            Direction facing = vatSide.direction;
            switch (vatSide.getDisplayType()) {
                case PIPE: {
                    ((SuperByteBuffer)CachedBufferer.partialFacing((PartialModel)DestroyPartials.VAT_SIDE_PIPE, (BlockState)state, (Direction)facing).translate((Vec3i)sidePos.m_121996_((Vec3i)controller.m_58899_()))).light(light).renderInto(ms, vbSolid);
                    break;
                }
                case BAROMETER: {
                    ((SuperByteBuffer)CachedBufferer.partialFacing((PartialModel)DestroyPartials.VAT_SIDE_BAROMETER, (BlockState)state, (Direction)facing).translate((Vec3i)sidePos.m_121996_((Vec3i)controller.m_58899_()))).light(light).renderInto(ms, vbSolid);
                    if (facing.m_122434_() == Direction.Axis.Y) break;
                    ms.m_85836_();
                    ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBufferer.partial((PartialModel)DestroyPartials.VAT_SIDE_BAROMETER_DIAL, (BlockState)state).translate((Vec3i)sidePos.m_121996_((Vec3i)controller.m_58899_()))).centre()).rotateY((double)(facing.m_122434_() == Direction.Axis.X ? facing.m_122427_() : facing.m_122428_()).m_122435_())).unCentre()).translate(0.125, 0.0, 0.0).translate(0.0, 0.5, 0.5).rotateX((double)(-90.0f - 180.0f * Mth.m_14036_((float)(controller.getClientPressure(partialTicks) / controller.getVatOptional().get().getMaxPressure()), (float)-1.0f, (float)1.0f)))).light(light).renderInto(ms, vbSolid);
                    ms.m_85849_();
                    break;
                }
                case THERMOMETER: {
                    ((SuperByteBuffer)CachedBufferer.partialFacing((PartialModel)DestroyPartials.VAT_SIDE_THERMOMETER, (BlockState)state, (Direction)facing).translate((Vec3i)sidePos.m_121996_((Vec3i)controller.m_58899_()))).light(light).renderInto(ms, vbCutout);
                    break;
                }
                case OPEN_VENT: 
                case CLOSED_VENT: {
                    ((SuperByteBuffer)CachedBufferer.partial((PartialModel)DestroyPartials.VAT_SIDE_VENT, (BlockState)state).translate((Vec3i)sidePos.m_121996_((Vec3i)controller.m_58899_()))).light(light).renderInto(ms, vbSolid);
                    for (boolean top : Iterate.trueAndFalse) {
                        for (int i = 0; i < 5; ++i) {
                            ((SuperByteBuffer)((SuperByteBuffer)CachedBufferer.partial((PartialModel)DestroyPartials.VAT_SIDE_VENT_BAR, (BlockState)state).translate((Vec3i)sidePos.m_121996_((Vec3i)controller.m_58899_()))).translate((double)(0.25f + (float)(i * 2) / 16.0f), top ? 1.09375 : -0.09375, 0.0).rotateZ((double)(vatSide.ventOpenness.getValue(partialTicks) * -75.0f))).light(light).renderInto(ms, vbSolid);
                        }
                    }
                    continue block6;
                }
            }
        }
        FluidStack fluidStack = controller.getLiquidTank().getFluid();
        if (!fluidStack.isEmpty()) {
            FluidRenderer.renderFluidBox((FluidStack)fluidStack, (float)((float)relativeInternalLowerCorner.f_82479_), (float)((float)relativeInternalLowerCorner.f_82480_), (float)((float)relativeInternalLowerCorner.f_82481_), (float)((float)relativeInternalUpperCorner.f_82479_), (float)relativeFluidLevel, (float)((float)relativeInternalUpperCorner.f_82481_), (MultiBufferSource)bufferSource, (PoseStack)ms, (int)light, (boolean)true);
        }
        int itemCount = 0;
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            if (inv.getStackInSlot(slot).m_41619_()) continue;
            itemCount += inv.getStackInSlot(slot).m_41613_();
        }
        if (itemCount != 0) {
            float offset = ((float)Math.min(relativeInternalUpperCorner.m_7096_() - relativeInternalLowerCorner.m_7096_(), relativeInternalUpperCorner.m_7094_() - relativeInternalLowerCorner.m_7094_()) - 0.5f) / (2.0f * (float)itemCount);
            float angle = 0.0f;
            Vec3 center = new Vec3(relativeInternalLowerCorner.m_7096_() + (double)((float)vat.getInternalWidth() / 2.0f), (double)(relativeFluidLevel - 0.1f), relativeInternalLowerCorner.m_7094_() + (double)((float)vat.getInternalLength() / 2.0f));
            Vec3 south = new Vec3(0.0, 0.0, 1.0);
            int nthItem = 1;
            for (int slot = 0; slot < inv.getSlots(); ++slot) {
                ItemStack stack = inv.getStackInSlot(slot);
                if (stack.m_41619_()) continue;
                for (int item = 0; item < stack.m_41613_(); ++item) {
                    Vec3 itemPosition = center.m_82549_(VecHelper.rotate((Vec3)south.m_82490_((double)(offset * (float)(nthItem - 1))), (double)angle, (Direction.Axis)Direction.Axis.Y));
                    ms.m_85836_();
                    if (fluidLevel > 0.0f) {
                        ms.m_252880_(0.0f, (Mth.m_14031_((float)(AnimationTickHolder.getRenderTime((LevelAccessor)controller.m_58904_()) / 12.0f + angle)) + 1.5f) * 1.0f / 32.0f, 0.0f);
                    }
                    ms.m_85837_(itemPosition.m_7096_(), itemPosition.m_7098_(), itemPosition.m_7094_());
                    ((TransformStack)TransformStack.cast((PoseStack)ms).rotateY((double)(angle + 35.0f))).rotateX(65.0);
                    this.renderItem(ms, bufferSource, light, overlay, stack);
                    ms.m_85849_();
                    angle += (float)(10 + 270 / ++nthItem);
                }
            }
        }
    }

    protected void renderItem(PoseStack ms, MultiBufferSource buffer, int light, int overlay, ItemStack stack) {
        Minecraft mc = Minecraft.m_91087_();
        mc.m_91291_().m_269128_(stack, ItemDisplayContext.GROUND, light, overlay, ms, buffer, (Level)mc.f_91073_, 0);
    }

    public boolean shouldRenderOffScreen(VatControllerBlockEntity controller) {
        return true;
    }
}

