/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block.renderer;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.petrolpark.destroy.block.entity.VatControllerBlockEntity;
import com.petrolpark.destroy.block.entity.VatSideBlockEntity;
import com.petrolpark.destroy.chemistry.ReadOnlyMixture;
import com.petrolpark.destroy.chemistry.index.DestroyMolecules;
import com.petrolpark.destroy.fluid.MixtureFluid;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.fluid.FluidRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;

public class VatSideRenderer
extends SafeBlockEntityRenderer<VatSideBlockEntity> {
    private static final FluidStack THERMOMETER_FLUID;

    public VatSideRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(VatSideBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource bufferSource, int light, int overlay) {
        VatControllerBlockEntity controller = be.getController();
        if (controller == null) {
            return;
        }
        Direction facing = be.direction.m_122424_();
        switch (be.getDisplayType()) {
            case PIPE: {
                if (be.spoutingTicks == 0 || be.isPipeSubmerged(true, Float.valueOf(partialTicks)) || facing == Direction.UP) break;
                float fluidLevel = controller.getRenderedFluidLevel(partialTicks);
                if (facing == Direction.DOWN) {
                    FluidRenderer.renderFluidBox((FluidStack)be.spoutingFluid, (float)0.40625f, (float)(fluidLevel - (float)be.getVatOptional().get().getInternalHeight()), (float)0.40625f, (float)0.59375f, (float)0.0f, (float)0.59375f, (MultiBufferSource)bufferSource, (PoseStack)ms, (int)light, (boolean)false);
                    break;
                }
                ms.m_85836_();
                ms.m_85837_(0.5, 0.5, 0.5);
                ((TransformStack)TransformStack.cast((PoseStack)ms).rotateY((double)AngleHelper.horizontalAngle((Direction)facing))).rotateX((double)AngleHelper.verticalAngle((Direction)facing));
                ms.m_85837_(-0.5, -0.5, -0.5);
                FluidRenderer.renderFluidBox((FluidStack)be.spoutingFluid, (float)0.40625f, (float)0.25f, (float)1.0625f, (float)0.59375f, (float)0.375f, (float)1.1875f, (MultiBufferSource)bufferSource, (PoseStack)ms, (int)light, (boolean)false);
                FluidRenderer.renderFluidBox((FluidStack)be.spoutingFluid, (float)0.40625f, (float)(fluidLevel - be.pipeHeightAboveVatBase() + 0.25f), (float)1.1875f, (float)0.59375f, (float)0.375f, (float)1.375f, (MultiBufferSource)bufferSource, (PoseStack)ms, (int)light, (boolean)false);
                ms.m_85849_();
                break;
            }
            case THERMOMETER: {
                ms.m_85836_();
                ms.m_85837_(0.5, 0.5, 0.5);
                ((TransformStack)TransformStack.cast((PoseStack)ms).rotateY((double)AngleHelper.horizontalAngle((Direction)facing))).rotateX((double)AngleHelper.verticalAngle((Direction)facing));
                ms.m_85837_(-0.5, -0.5, -0.5);
                Vec3 v0 = new Vec3(0.4375, 0.09375, -0.125);
                Vec3 v1 = new Vec3(0.5625, (double)0.24375f, 0.0);
                Vec3 v2 = new Vec3(0.46875, (double)0.24375f, -0.09375);
                Vec3 v3 = new Vec3(0.53125, (double)((10.1f * Mth.m_14036_((float)((controller.getClientTemperature(partialTicks) - 298.0f) / 202.0f), (float)0.0f, (float)1.0f) + 3.9f) / 16.0f), -0.03125);
                FluidRenderer.renderFluidBox((FluidStack)THERMOMETER_FLUID, (float)((float)v0.f_82479_), (float)((float)v0.f_82480_), (float)((float)v0.f_82481_), (float)((float)v1.f_82479_), (float)((float)v1.f_82480_), (float)((float)v1.f_82481_), (MultiBufferSource)bufferSource, (PoseStack)ms, (int)light, (boolean)true);
                FluidRenderer.renderFluidBox((FluidStack)THERMOMETER_FLUID, (float)((float)v2.f_82479_), (float)((float)v2.f_82480_), (float)((float)v2.f_82481_), (float)((float)v3.f_82479_), (float)((float)v3.f_82480_), (float)((float)v3.f_82481_), (MultiBufferSource)bufferSource, (PoseStack)ms, (int)light, (boolean)false);
                ms.m_85849_();
                break;
            }
        }
    }

    public boolean shouldRenderOffScreen(VatSideBlockEntity be) {
        return true;
    }

    public boolean shouldRender(VatSideBlockEntity vatSide, Vec3 cameraPos) {
        return true;
    }

    static {
        ReadOnlyMixture mixture = new ReadOnlyMixture();
        mixture.addMolecule(DestroyMolecules.MERCURY, DestroyMolecules.MERCURY.getPureConcentration());
        THERMOMETER_FLUID = MixtureFluid.of(1000, mixture, "");
    }
}

