/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.capability.blockEntity;

import com.petrolpark.destroy.block.entity.VatControllerBlockEntity;
import com.petrolpark.destroy.block.entity.VatSideBlockEntity;
import com.petrolpark.destroy.fluid.DestroyFluids;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class VatSideTankCapability
extends CombinedTankWrapper {
    private final VatSideBlockEntity vatSide;

    public VatSideTankCapability(VatSideBlockEntity vatSide, IFluidHandler liquidOutput, IFluidHandler gasOutput, IFluidHandler input) {
        super(new IFluidHandler[]{liquidOutput, gasOutput, input});
        this.vatSide = vatSide;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return DestroyFluids.isMixture(stack);
    }

    public IFluidHandler getLiquidOutput() {
        return this.itemHandler[0];
    }

    public IFluidHandler getGasOutput() {
        return this.itemHandler[1];
    }

    public IFluidHandler getInput() {
        return this.itemHandler[2];
    }

    public int fill(FluidStack stack, IFluidHandler.FluidAction fluidAction) {
        VatControllerBlockEntity controller = this.vatSide.getController();
        if (controller == null || !controller.canFitFluid()) {
            return 0;
        }
        return this.getInput().fill(stack, fluidAction);
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack drained = (this.vatSide.isPipeSubmerged(false, null) ? this.getLiquidOutput() : this.getGasOutput()).drain(resource, action);
        this.updateVatGasVolume(drained, action);
        return drained;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack drained = (this.vatSide.isPipeSubmerged(false, null) ? this.getLiquidOutput() : this.getGasOutput()).drain(maxDrain, action);
        this.updateVatGasVolume(drained, action);
        return drained;
    }

    protected void updateVatGasVolume(FluidStack drained, IFluidHandler.FluidAction action) {
        if (action == IFluidHandler.FluidAction.EXECUTE && !drained.isEmpty() && this.vatSide.getController() != null && !this.vatSide.m_58904_().m_5776_()) {
            this.vatSide.getController().updateCachedMixture();
            this.vatSide.getController().updateGasVolume();
        }
    }
}

