/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.capability.chunk;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.synth.PerlinNoise;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChunkCrudeOil {
    public static final long SALT = 5252525252L;
    private boolean generated = false;
    private int amount;

    public void generate(LevelChunk chunk, @Nullable Player player) {
        if (this.generated) {
            return;
        }
        Level level = chunk.m_62953_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            ChunkPos pos = chunk.m_7697_();
            RandomSource random = RandomSource.m_216335_((long)(level2.m_7328_() ^ 0x139132CC4L));
            double value = PerlinNoise.m_230520_((RandomSource)random, (int)-2, (double)1.0, (double[])new double[0]).m_75408_((double)pos.f_45578_ * 0.7, (double)pos.f_45579_ * 0.7, 0.0);
            this.amount = value < 0.3 ? 0 : (int)(value * 100000.0);
            this.generated = true;
        }
    }

    public int getAmount() {
        return this.amount;
    }

    public void decreaseAmount(int decrease) {
        this.amount = Math.max(0, this.amount - decrease);
    }

    public static class Provider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        public static Capability<ChunkCrudeOil> CHUNK_CRUDE_OIL = CapabilityManager.get((CapabilityToken)new CapabilityToken<ChunkCrudeOil>(){});
        private ChunkCrudeOil crudeOil = null;
        private final LazyOptional<ChunkCrudeOil> optional = LazyOptional.of(this::createChunkCrudeOil);

        private ChunkCrudeOil createChunkCrudeOil() {
            if (this.crudeOil == null) {
                this.crudeOil = new ChunkCrudeOil();
            }
            return this.crudeOil;
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("Generated", this.createChunkCrudeOil().generated);
            tag.m_128405_("Amount", this.createChunkCrudeOil().amount);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            this.createChunkCrudeOil().amount = tag.m_128451_("Amount");
            this.createChunkCrudeOil().generated = tag.m_128471_("Generated");
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            if (cap == CHUNK_CRUDE_OIL) {
                return this.optional.cast();
            }
            return LazyOptional.empty();
        }
    }
}

