/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.capability.entity;

import com.petrolpark.destroy.chemistry.Molecule;
import com.petrolpark.destroy.network.DestroyMessages;
import com.petrolpark.destroy.network.packet.ChemicalPoisonS2CPacket;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityChemicalPoison {
    private Molecule molecule;

    public static void setMolecule(Entity entity, Molecule molecule) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        entity.getCapability(Provider.ENTITY_CHEMICAL_POISON).ifPresent(cp -> {
            if (cp.molecule != null) {
                return;
            }
            cp.molecule = molecule;
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                DestroyMessages.sendToClient(new ChemicalPoisonS2CPacket(molecule), serverPlayer);
            }
        });
    }

    public static void removeMolecule(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        entity.getCapability(Provider.ENTITY_CHEMICAL_POISON).ifPresent(cp -> {
            cp.molecule = null;
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                DestroyMessages.sendToClient(new ChemicalPoisonS2CPacket((Molecule)null), serverPlayer);
            }
        });
    }

    @Nullable
    public Molecule getMolecule() {
        return this.molecule;
    }

    public static class Provider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        public static Capability<EntityChemicalPoison> ENTITY_CHEMICAL_POISON = CapabilityManager.get((CapabilityToken)new CapabilityToken<EntityChemicalPoison>(){});
        private EntityChemicalPoison chemicalPoison = null;
        private final LazyOptional<EntityChemicalPoison> optional = LazyOptional.of(this::createEntityChemicalPoison);

        private EntityChemicalPoison createEntityChemicalPoison() {
            if (this.chemicalPoison == null) {
                this.chemicalPoison = new EntityChemicalPoison();
            }
            return this.chemicalPoison;
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            if (this.createEntityChemicalPoison().molecule != null) {
                tag.m_128359_("ToxicMolecule", this.createEntityChemicalPoison().molecule.getFullID());
            }
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("ToxicMolecule", 8)) {
                this.createEntityChemicalPoison().molecule = Molecule.getMolecule(tag.m_128461_("ToxicMolecule"));
            }
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            if (cap == ENTITY_CHEMICAL_POISON) {
                return this.optional.cast();
            }
            return LazyOptional.empty();
        }
    }
}

