/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.capability.level.pollution;

import com.petrolpark.destroy.capability.level.pollution.LevelPollutionProvider;
import com.petrolpark.destroy.chemistry.MoleculeTag;
import com.petrolpark.destroy.chemistry.index.DestroyMolecules;
import com.petrolpark.destroy.client.gui.DestroyIcons;
import com.petrolpark.destroy.config.DestroyAllConfigs;
import com.petrolpark.destroy.util.PollutionHelper;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.utility.Lang;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class LevelPollution {
    private Map<PollutionType, Integer> levels = new HashMap<PollutionType, Integer>();
    private float outdoorTemperature;
    private boolean hasPollutionEverBeenMaxed;
    private boolean hasPollutionEverBeenFullyReduced;

    public LevelPollution() {
        List.of(PollutionType.values()).forEach(p -> this.levels.put((PollutionType)((Object)p), 0));
        this.hasPollutionEverBeenMaxed = false;
        this.hasPollutionEverBeenFullyReduced = false;
        this.outdoorTemperature = 289.0f;
    }

    public int get(PollutionType pollutionType) {
        if (pollutionType == null) {
            return 0;
        }
        return this.levels.get((Object)pollutionType);
    }

    public float getGlobalTemperature() {
        return this.outdoorTemperature;
    }

    public static float getLocalTemperature(Level level, BlockPos pos) {
        return level.getCapability(LevelPollutionProvider.LEVEL_POLLUTION).map(pollution -> Float.valueOf(pollution.outdoorTemperature + 10.0f * ((Biome)level.m_204166_(pos).get()).m_47554_())).orElse(Float.valueOf(289.0f)).floatValue();
    }

    public int set(PollutionType pollutionType, int value) {
        if (pollutionType == null) {
            return 0;
        }
        value = Mth.m_14045_((int)value, (int)0, (int)pollutionType.max);
        this.levels.replace(pollutionType, value);
        if (this.levels.get((Object)PollutionType.ACID_RAIN) == PollutionType.ACID_RAIN.max && this.levels.get((Object)PollutionType.OZONE_DEPLETION) == PollutionType.OZONE_DEPLETION.max && this.levels.get((Object)PollutionType.SMOG) == PollutionType.SMOG.max && this.levels.get((Object)PollutionType.GREENHOUSE) == PollutionType.GREENHOUSE.max) {
            this.hasPollutionEverBeenMaxed = true;
        } else if (this.hasPollutionEverBeenMaxed && this.levels.get((Object)PollutionType.ACID_RAIN) == 0 && this.levels.get((Object)PollutionType.OZONE_DEPLETION) == 0 && this.levels.get((Object)PollutionType.SMOG) == 0 && this.levels.get((Object)PollutionType.GREENHOUSE) == 0) {
            this.hasPollutionEverBeenFullyReduced = true;
        }
        this.updateTemperature();
        return value;
    }

    public int change(PollutionType pollutionType, int change) {
        if (pollutionType == null) {
            return 0;
        }
        return this.set(pollutionType, this.levels.get((Object)pollutionType) + change);
    }

    public void saveNBTData(CompoundTag tag) {
        this.levels.forEach((pollutionType, value) -> tag.m_128405_(pollutionType.name(), value.intValue()));
        tag.m_128379_("EverMaxed", this.hasPollutionEverBeenMaxed);
        tag.m_128379_("EverReduced", this.hasPollutionEverBeenFullyReduced);
    }

    public void loadNBTData(CompoundTag tag) {
        this.levels.keySet().forEach(pollutionType -> this.levels.replace((PollutionType)((Object)pollutionType), tag.m_128451_(pollutionType.name())));
        this.hasPollutionEverBeenMaxed = tag.m_128471_("EverMaxed");
        this.hasPollutionEverBeenFullyReduced = tag.m_128471_("EverReduced");
        this.updateTemperature();
    }

    public void updateTemperature() {
        this.outdoorTemperature = 289.0f;
        if (!PollutionHelper.pollutionEnabled() || !((Boolean)DestroyAllConfigs.SERVER.pollution.temperatureAffected.get()).booleanValue()) {
            return;
        }
        this.outdoorTemperature += (float)(this.levels.get((Object)PollutionType.GREENHOUSE) / PollutionType.GREENHOUSE.max) * 20.0f + (float)(this.levels.get((Object)PollutionType.OZONE_DEPLETION) / PollutionType.OZONE_DEPLETION.max) * 4.0f;
    }

    public boolean hasPollutionEverBeenMaxed() {
        return this.hasPollutionEverBeenMaxed;
    }

    public boolean hasPollutionEverBeenFullyReduced() {
        return this.hasPollutionEverBeenFullyReduced;
    }

    public static enum PollutionType implements INamedIconOptions
    {
        GREENHOUSE(DestroyIcons.GREENHOUSE, 65536, DestroyMolecules.Tags.GREENHOUSE),
        OZONE_DEPLETION(DestroyIcons.OZONE_DEPLETION, 65536, DestroyMolecules.Tags.OZONE_DEPLETER),
        SMOG(DestroyIcons.SMOG, 65536, DestroyMolecules.Tags.SMOG),
        ACID_RAIN(DestroyIcons.ACID_RAIN, 65536, DestroyMolecules.Tags.ACID_RAIN),
        RADIOACTIVITY(DestroyIcons.RADIOACTIVITY, 65536, null);

        private final AllIcons icon;
        public final int max;
        public final MoleculeTag moleculeTag;

        private PollutionType(AllIcons icon, int max, MoleculeTag moleculeTag) {
            this.icon = icon;
            this.max = max;
            this.moleculeTag = moleculeTag;
        }

        public AllIcons getIcon() {
            return this.icon;
        }

        public String getTranslationKey() {
            return "destroy.pollution." + Lang.asId((String)this.name());
        }
    }
}

