/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.capability.player.previousposition;

import com.google.common.collect.EvictingQueue;
import com.petrolpark.destroy.config.DestroyAllConfigs;
import java.util.List;
import java.util.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class PlayerPreviousPositions {
    private static int QUEUE_SIZE = 20;
    private static final int TICKS_PER_SECOND = 20;
    private Queue<BlockPos> previousPositions = EvictingQueue.create((int)QUEUE_SIZE);
    private int tickCounter = 0;

    public BlockPos getOldestPosition() {
        return this.previousPositions.peek();
    }

    public void recordPosition(BlockPos pos) {
        this.previousPositions.add(pos);
    }

    public void clearPositions() {
        this.previousPositions.clear();
    }

    public void incrementTickCounter() {
        ++this.tickCounter;
        if (this.tickCounter >= 20) {
            this.tickCounter = 0;
        }
    }

    public boolean hasBeenSecond() {
        return this.tickCounter == 0;
    }

    public void saveNBTData(CompoundTag tag) {
        ListTag positionsTag = new ListTag();
        for (BlockPos pos : this.previousPositions) {
            positionsTag.add((Object)new IntArrayTag(List.of(Integer.valueOf(pos.m_123341_()), Integer.valueOf(pos.m_123342_()), Integer.valueOf(pos.m_123343_()))));
        }
        tag.m_128365_("PreviousPositions", (Tag)positionsTag);
    }

    public void loadNBTData(CompoundTag tag) {
        this.previousPositions = EvictingQueue.create((int)QUEUE_SIZE);
        ListTag positionsTag = tag.m_128437_("PreviousPositions", 11);
        for (int i = 0; i < positionsTag.size(); ++i) {
            int[] posTag = positionsTag.m_128767_(i);
            this.previousPositions.add(new BlockPos(posTag[0], posTag[1], posTag[2]));
        }
    }

    public static void updateQueueSize() {
        QUEUE_SIZE = (Integer)DestroyAllConfigs.COMMON.substances.teleportTime.get();
    }

    public static int getQueueSize() {
        return QUEUE_SIZE;
    }
}

