/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.chemistry;

import com.jozufozu.flywheel.core.PartialModel;
import com.petrolpark.destroy.chemistry.Atom;

public class Bond {
    private volatile BondType type;
    private Atom srcAtom;
    private Atom destAtom;

    public Bond(Atom sourceAtom, Atom destinationAtom, BondType type) {
        this.srcAtom = sourceAtom;
        this.destAtom = destinationAtom;
        this.type = type;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Bond)) {
            return false;
        }
        Bond otherBond = (Bond)obj;
        return this.type == otherBond.type && this.srcAtom == otherBond.srcAtom && this.destAtom == otherBond.destAtom;
    }

    public Atom getSourceAtom() {
        return this.srcAtom;
    }

    public Atom getDestinationAtom() {
        return this.destAtom;
    }

    public BondType getType() {
        return this.type;
    }

    public void setType(BondType type) {
        this.type = type;
    }

    public Bond getMirror() {
        return new Bond(this.destAtom, this.srcAtom, this.type);
    }

    public static enum BondType {
        SINGLE(1.0f, ""),
        DOUBLE(2.0f, "="),
        TRIPLE(3.0f, "#"),
        AROMATIC(1.5f, "~");

        private float singleBondEquivalent;
        private String FROWNSCode;
        private PartialModel partial;

        private BondType(float singleBondEquivalent, String FROWNSCode) {
            this.singleBondEquivalent = singleBondEquivalent;
            this.FROWNSCode = FROWNSCode;
        }

        public float getEquivalent() {
            return this.singleBondEquivalent;
        }

        public String getFROWNSCode() {
            return this.FROWNSCode;
        }

        public static BondType fromFROWNSCode(char c) {
            BondType bondType = SINGLE;
            switch (c) {
                case '=': {
                    bondType = DOUBLE;
                    break;
                }
                case '#': {
                    bondType = TRIPLE;
                    break;
                }
                case '~': {
                    bondType = AROMATIC;
                }
            }
            return bondType;
        }

        public PartialModel getPartial() {
            return this.partial;
        }

        public void setPartial(PartialModel partial) {
            this.partial = partial;
        }
    }
}

