/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.chemistry;

import com.jozufozu.flywheel.util.Color;
import com.petrolpark.destroy.chemistry.Mixture;
import com.petrolpark.destroy.chemistry.Molecule;
import com.petrolpark.destroy.chemistry.ReadOnlyMixture;
import com.petrolpark.destroy.chemistry.index.DestroyMolecules;
import com.petrolpark.destroy.chemistry.naming.INameableProduct;
import com.petrolpark.destroy.chemistry.naming.NamedSalt;
import com.petrolpark.destroy.config.DestroyAllConfigs;
import com.petrolpark.destroy.util.DestroyLang;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.network.chat.Component;

public class ClientMixture
extends ReadOnlyMixture {
    @Override
    public void updateColor() {
        float totalColorContribution = 0.0f;
        float totalRed = 0.0f;
        float totalGreen = 0.0f;
        float totalBlue = 0.0f;
        int totalAlpha = 64;
        for (Map.Entry entry : this.contents.entrySet()) {
            Color color = new Color(((Molecule)entry.getKey()).getColor());
            float colorContribution = ((Float)entry.getValue()).floatValue() * color.getAlphaAsFloat();
            totalColorContribution += colorContribution;
            totalRed += (float)color.getRed() * colorContribution;
            totalGreen += (float)color.getGreen() * colorContribution;
            totalBlue += (float)color.getBlue() * colorContribution;
            totalAlpha = Math.max(totalAlpha, color.getAlpha());
        }
        this.color = new Color((int)(totalRed / totalColorContribution), (int)(totalGreen / totalColorContribution), (int)(totalBlue / totalColorContribution), totalAlpha).getRGB();
    }

    @Override
    protected void updateName() {
        try {
            boolean thereAreImpurities;
            if (this.translationKey != "") {
                this.name = Component.m_237115_((String)this.translationKey);
                return;
            }
            boolean iupac = (Boolean)DestroyAllConfigs.CLIENT.chemistry.iupacNames.get();
            if (this.contents.size() == 1) {
                this.name = ((Molecule)this.contents.entrySet().iterator().next().getKey()).getName(iupac);
                return;
            }
            boolean neutral = Mixture.areVeryClose(Float.valueOf(this.getConcentrationOf(DestroyMolecules.PROTON)), Float.valueOf(this.getConcentrationOf(DestroyMolecules.HYDROXIDE)));
            ArrayList<INameableProduct> products = new ArrayList<INameableProduct>();
            ArrayList<Molecule> cations = new ArrayList<Molecule>();
            ArrayList<Molecule> anions = new ArrayList<Molecule>();
            ArrayList<Molecule> solvents = new ArrayList<Molecule>();
            ArrayList<Molecule> impurities = new ArrayList<Molecule>();
            boolean thereAreNeutralMolecules = false;
            for (Map.Entry entry : this.contents.entrySet()) {
                Molecule molecule = (Molecule)entry.getKey();
                if (neutral && (molecule == DestroyMolecules.HYDROXIDE || molecule == DestroyMolecules.PROTON)) continue;
                if (((Float)entry.getValue()).floatValue() < 0.1f) {
                    impurities.add(molecule);
                } else if (molecule.hasTag(DestroyMolecules.Tags.SOLVENT)) {
                    solvents.add(molecule);
                } else if (molecule.getCharge() > 0) {
                    cations.add(molecule);
                } else if (molecule.getCharge() < 0) {
                    anions.add(molecule);
                } else {
                    products.add(molecule);
                }
                if (molecule.getCharge() != 0) continue;
                thereAreNeutralMolecules = true;
            }
            if (cations.size() != 0 || anions.size() != 0) {
                if (cations.size() == 1 && anions.size() == 1) {
                    if (cations.get(0) != DestroyMolecules.PROTON || anions.get(0) != DestroyMolecules.HYDROXIDE) {
                        products.add(new NamedSalt((Molecule)cations.get(0), (Molecule)anions.get(0)));
                    }
                } else {
                    products.add(b -> DestroyLang.translate("mixture.salts", new Object[0]).component());
                }
            }
            boolean thereAreSolvents = solvents.size() != 0;
            boolean bl = thereAreImpurities = impurities.size() != 0;
            if (products.size() == 2 && ((INameableProduct)products.get(0)).getName(iupac).getString().equals(((INameableProduct)products.get(1)).getName(iupac).getString())) {
                products.remove(1);
            }
            if (products.size() == 0) {
                if (solvents.size() == 1) {
                    this.name = ((Molecule)solvents.get(0)).getName(iupac).m_6879_();
                } else if (solvents.size() == 2) {
                    this.name = DestroyLang.translate("mixture.and", ((Molecule)solvents.get(0)).getName(iupac).getString(), ((Molecule)solvents.get(1)).getName(iupac).getString()).component();
                } else if (thereAreSolvents) {
                    this.name = DestroyLang.translate("mixture.solvents", new Object[0]).component();
                }
                if (thereAreImpurities && this.name != null) {
                    this.name = DestroyLang.translate("mixture.dirty", this.name.getString()).component();
                }
            } else if (products.size() <= 2) {
                this.name = products.size() == 1 ? ((INameableProduct)products.get(0)).getName(iupac).m_6879_() : DestroyLang.translate("mixture.and", ((INameableProduct)products.get(0)).getName(iupac).getString(), ((INameableProduct)products.get(1)).getName(iupac).getString()).component();
                if (thereAreSolvents) {
                    this.name = DestroyLang.translate("mixture.solution", this.name.getString()).component();
                }
                if (thereAreImpurities) {
                    this.name = DestroyLang.translate("mixture.impure", this.name.getString()).component();
                }
            }
            if (this.name == null) {
                this.name = DestroyLang.translate("mixture.mixture", new Object[0]).component();
            }
            if (!thereAreNeutralMolecules && this.name != null) {
                this.name = DestroyLang.translate("mixture.supersaturated", this.name.getString()).component();
            }
        }
        catch (Throwable e) {
            this.name = DestroyLang.translate("mixture.mixture", new Object[0]).component();
        }
    }
}

