/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.chemistry;

import com.jozufozu.flywheel.core.PartialModel;
import com.petrolpark.destroy.client.gui.MoleculeRenderer;
import java.util.function.Function;

public enum Element {
    R_GROUP("R", Float.valueOf(1.0E-4f), Float.valueOf(2.5f), new double[]{1.0, 2.0, 3.0}),
    CARBON("C", Float.valueOf(12.01f), Float.valueOf(2.5f), new double[]{4.0}),
    HYDROGEN("H", Float.valueOf(1.01f), Float.valueOf(2.1f), new double[]{1.0}),
    SULFUR("S", Float.valueOf(32.07f), Float.valueOf(2.5f), new double[]{2.0, 0.0, 4.0, 6.0}),
    NITROGEN("N", Float.valueOf(14.01f), Float.valueOf(3.0f), new double[]{3.0, 4.0, 5.0}, i -> i == 3 ? MoleculeRenderer.Geometry.TRIGONAL_PYRAMIDAL : null),
    OXYGEN("O", Float.valueOf(16.0f), Float.valueOf(3.5f), new double[]{1.5, 2.0}, i -> i == 2 ? MoleculeRenderer.Geometry.V_SHAPE : null),
    FLUORINE("F", Float.valueOf(19.0f), Float.valueOf(4.0f), new double[]{1.0}),
    SODIUM("Na", Float.valueOf(23.0f), Float.valueOf(0.9f), new double[]{1.0}),
    CHLORINE("Cl", Float.valueOf(35.45f), Float.valueOf(3.0f), new double[]{1.0}),
    POTASSIUM("K", Float.valueOf(39.1f), Float.valueOf(0.8f), new double[]{1.0}),
    CALCIUM("Ca", Float.valueOf(40.08f), Float.valueOf(1.0f), new double[]{2.0}),
    IRON("Fe", Float.valueOf(55.85f), Float.valueOf(1.8f), new double[]{0.0, 2.0, 3.0}),
    NICKEL("Ni", Float.valueOf(58.69f), Float.valueOf(1.8f), new double[]{1.0}),
    COPPER("Cu", Float.valueOf(63.55f), Float.valueOf(1.9f), new double[]{1.0, 2.0}),
    ZINC("Zn", Float.valueOf(65.38f), Float.valueOf(1.6f), new double[]{1.0}),
    ZIRCONIUM("Zr", Float.valueOf(91.22f), Float.valueOf(1.4f), new double[]{1.0}),
    IODINE("I", Float.valueOf(126.9f), Float.valueOf(2.7f), new double[]{1.0}),
    PLATINUM("Pt", Float.valueOf(195.08f), Float.valueOf(2.2f), new double[]{1.0}),
    GOLD("Au", Float.valueOf(196.97f), Float.valueOf(2.4f), new double[]{0.0, 4.0}),
    MERCURY("Hg", Float.valueOf(200.59f), Float.valueOf(1.9f), new double[]{2.0});

    private String symbol;
    private Float mass;
    private Float electronegativity;
    private double[] valencies;
    private Function<Integer, MoleculeRenderer.Geometry> geometryOverride;
    private PartialModel partial;

    private Element(String symbol, Float mass, Float electronegativity, double[] valencies) {
        this(symbol, mass, electronegativity, valencies, null);
    }

    private Element(String symbol, Float mass, Float electronegativity, double[] valencies, Function<Integer, MoleculeRenderer.Geometry> geometryOverride) {
        this.symbol = symbol;
        this.mass = mass;
        this.electronegativity = electronegativity;
        this.valencies = valencies;
        this.geometryOverride = geometryOverride;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public Float getMass() {
        return this.mass;
    }

    public Float getElectronegativity() {
        return this.electronegativity;
    }

    public Boolean isValidValency(double valency) {
        for (double possibleValency : this.valencies) {
            if (!(Math.abs(possibleValency - valency) < 1.0E-6)) continue;
            return true;
        }
        return false;
    }

    public double getNextLowestValency(double valency) {
        for (double validValency : this.valencies) {
            if (!(validValency >= valency)) continue;
            return validValency;
        }
        return 0.0;
    }

    public double getMaxValency() {
        double currentMax = this.valencies[0];
        for (double valency : this.valencies) {
            if (!(valency > currentMax)) continue;
            valency = currentMax;
        }
        return currentMax;
    }

    public static Element fromSymbol(String symbol) {
        for (Element element : Element.values()) {
            if (!element.symbol.equals(symbol)) continue;
            return element;
        }
        throw new EnumConstantNotPresentException(Element.class, "Unknown Element of symbol " + symbol);
    }

    public MoleculeRenderer.Geometry getGeometry(int connections) {
        MoleculeRenderer.Geometry geometry = null;
        if (this.geometryOverride != null) {
            geometry = this.geometryOverride.apply(connections);
        }
        if (geometry != null) {
            return geometry;
        }
        switch (connections) {
            case 0: 
            case 1: 
            case 2: {
                return MoleculeRenderer.Geometry.LINEAR;
            }
            case 3: {
                return MoleculeRenderer.Geometry.TRIGONAL_PLANAR;
            }
            case 4: {
                return MoleculeRenderer.Geometry.TETRAHEDRAL;
            }
            case 5: 
            case 6: {
                return MoleculeRenderer.Geometry.OCTAHEDRAL;
            }
        }
        return MoleculeRenderer.Geometry.OCTAHEDRAL;
    }

    public PartialModel getPartial() {
        return this.partial;
    }

    public void setPartial(PartialModel partial) {
        this.partial = partial;
    }
}

