/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.chemistry;

import com.petrolpark.destroy.chemistry.Atom;
import com.petrolpark.destroy.chemistry.Bond;
import com.petrolpark.destroy.chemistry.Element;
import com.petrolpark.destroy.chemistry.Group;
import com.petrolpark.destroy.chemistry.GroupFinder;
import com.petrolpark.destroy.chemistry.error.ChemistryException;
import com.petrolpark.destroy.chemistry.serializer.Branch;
import com.petrolpark.destroy.chemistry.serializer.Node;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.world.phys.Vec3;

public class Formula
implements Cloneable {
    private Map<Atom, List<Bond>> structure = new HashMap<Atom, List<Bond>>();
    private Atom startingAtom;
    private Atom currentAtom;
    private List<Group<?>> groups = new ArrayList();
    private Topology topology = Topology.LINEAR;
    private List<Pair<Topology.SideChainInformation, Formula>> sideChains = new ArrayList<Pair<Topology.SideChainInformation, Formula>>();
    @Nullable
    private String optimumFROWNSCode = null;

    private Formula() {
    }

    public Formula(Atom startingAtom) {
        this();
        this.structure.put(startingAtom, new ArrayList());
        this.startingAtom = startingAtom;
        this.currentAtom = startingAtom;
    }

    private static Formula nothing() {
        return new Formula();
    }

    public Formula moveTo(Atom atom) {
        if (!this.structure.containsKey(atom)) {
            throw new ChemistryException.FormulaException.FormulaModificationException(this, "Can't set the current Atom to an Atom not in the Formula");
        }
        this.currentAtom = atom;
        return this;
    }

    public Formula setStartingAtom(Atom atom) {
        if (!this.structure.containsKey(atom)) {
            throw new ChemistryException.FormulaException.FormulaModificationException(this, "Can't set the starting Atom to an Atom not in the Formula");
        }
        this.startingAtom = atom;
        return this;
    }

    public static Formula atom(Element element) {
        return new Formula(new Atom(element));
    }

    public static Formula carbonChain(int length) {
        Formula carbonChain = Formula.atom(Element.CARBON);
        for (int i = 0; i < length - 1; ++i) {
            carbonChain.addGroup(Formula.atom(Element.CARBON));
        }
        return carbonChain;
    }

    public static Formula alcohol() {
        return Formula.atom(Element.OXYGEN).addAtom(Element.HYDROGEN);
    }

    public Formula addAtom(Element element) {
        return this.addAtom(element, Bond.BondType.SINGLE);
    }

    public Formula addAtom(Element element, Bond.BondType bondType) {
        Formula.addAtomToStructure(this.structure, this.currentAtom, new Atom(element), bondType);
        return this;
    }

    public Formula addAtom(Atom atom) {
        return this.addAtom(atom, Bond.BondType.SINGLE);
    }

    public Formula addAtom(Atom atom, Bond.BondType bondType) {
        Formula.addAtomToStructure(this.structure, this.currentAtom, atom, bondType);
        return this;
    }

    public Formula addGroup(Formula group) {
        return this.addGroup(group, true);
    }

    public Formula addGroup(Formula group, boolean isSideGroup) {
        return this.addGroup(group, isSideGroup, Bond.BondType.SINGLE);
    }

    public static Formula joinFormulae(Formula formula1, Formula formula2, Bond.BondType bondType) {
        Formula formula;
        if (formula2.isCyclic()) {
            if (formula1.isCyclic()) {
                throw new ChemistryException.FormulaException.FormulaModificationException(formula1, "Cannot join two cyclic structures.");
            }
            formula1.startingAtom = formula1.currentAtom;
            formula2.addGroup(formula1, false, bondType);
            formula = formula2;
        } else {
            formula2.startingAtom = formula2.currentAtom;
            formula1.addGroup(formula2, true, bondType);
            formula = formula1;
        }
        return formula.shallowCopy();
    }

    public Formula addGroup(Formula group, Boolean isSideGroup, Bond.BondType bondType) {
        if (this.topology.atomsAndLocations.stream().anyMatch(pair -> pair.getSecond() == this.currentAtom)) {
            throw new ChemistryException.FormulaException.FormulaModificationException(this, "Cannot modify Atoms in cycle");
        }
        Formula.addGroupToStructure(this.structure, this.currentAtom, group, bondType);
        if (!isSideGroup.booleanValue()) {
            this.currentAtom = group.currentAtom;
        }
        return this;
    }

    @Deprecated
    public Formula addGroupToPosition(Formula group, int position) {
        return this.addGroupToPosition(group, position, Bond.BondType.SINGLE);
    }

    @Deprecated
    public Formula addGroupToPosition(Formula group, int position, Bond.BondType bondType) {
        Formula.addGroupToStructure(this.structure, ((Topology.SideChainInformation)this.sideChains.get(position).getFirst()).atom(), group, bondType);
        this.sideChains.get(position).setSecond((Object)group);
        this.currentAtom = group.currentAtom;
        return this;
    }

    public boolean isCyclic() {
        return this.topology != Topology.LINEAR;
    }

    public List<Pair<Vec3, Atom>> getCyclicAtomsForRendering() {
        return this.topology.atomsAndLocations;
    }

    public List<Bond> getCyclicBondsForRendering() {
        return this.topology.bonds;
    }

    public List<Pair<Topology.SideChainInformation, Branch>> getSideChainsForRendering() {
        return this.sideChains.stream().map(pair -> {
            Formula sideChain = (Formula)pair.getSecond();
            return Pair.of((Object)((Topology.SideChainInformation)pair.getFirst()), (Object)Formula.getMaximumBranch(sideChain.startingAtom, sideChain.structure));
        }).toList();
    }

    public Formula remove(Atom atom) {
        if (!this.structure.containsKey(atom)) {
            throw new ChemistryException.FormulaException.FormulaModificationException(this, "Cannot remove " + atom.getElement().getSymbol() + " atom (does not exist).");
        }
        if (atom == this.currentAtom) {
            throw new ChemistryException.FormulaException.FormulaModificationException(this, "Cannot remove the currently selected Atom from a structure being built.");
        }
        if (this.topology.atomsAndLocations.stream().anyMatch(pair -> pair.getSecond() == atom)) {
            throw new ChemistryException.FormulaException.FormulaModificationException(this, "Cannot remove Atoms in the cyclic part of a cyclic Molecule ");
        }
        for (Bond bondToOtherAtom : this.structure.get(atom)) {
            this.structure.get(bondToOtherAtom.getDestinationAtom()).removeIf(bondToThisAtom -> bondToThisAtom.getDestinationAtom() == atom);
        }
        this.structure.remove(atom);
        return this;
    }

    public Formula replace(Atom oldAtom, Atom newAtom) {
        if (!this.structure.containsKey(oldAtom)) {
            throw new ChemistryException.FormulaException.FormulaModificationException(this, "Cannot replace " + oldAtom.getElement().getSymbol() + " atom (does not exist).");
        }
        if (oldAtom == this.currentAtom) {
            this.currentAtom = newAtom;
        }
        if (oldAtom == this.startingAtom) {
            this.startingAtom = newAtom;
        }
        if (this.topology.atomsAndLocations.stream().anyMatch(pair -> pair.getSecond() == oldAtom)) {
            throw new ChemistryException.FormulaException.FormulaModificationException(this, "Cannot replace Atoms in the cyclic part of a cyclic Molecule ");
        }
        for (Bond bondToOtherAtom : this.structure.get(oldAtom)) {
            this.structure.get(bondToOtherAtom.getDestinationAtom()).replaceAll(bond -> {
                if (bond.getDestinationAtom() == oldAtom) {
                    return new Bond(bond.getSourceAtom(), newAtom, bond.getType());
                }
                return bond;
            });
        }
        List<Bond> oldBonds = this.structure.get(oldAtom);
        this.structure.put(newAtom, oldBonds);
        this.structure.remove(oldAtom);
        return this;
    }

    public Formula replaceBondTo(Atom otherAtom, Bond.BondType bondType) {
        for (Bond bond : this.structure.get(this.currentAtom)) {
            if (bond.getDestinationAtom() != otherAtom) continue;
            bond.setType(bondType);
            for (Bond reverseBond : this.structure.get(otherAtom)) {
                if (reverseBond.getDestinationAtom() != this.currentAtom) continue;
                reverseBond.setType(bondType);
                this.refreshFunctionalGroups();
                return this;
            }
        }
        throw new ChemistryException.FormulaException.FormulaModificationException(this, "Cannot modify bond between two Atoms if they do not already have a Bond");
    }

    public Formula addCarbonyl() {
        this.addAtom(Element.OXYGEN, Bond.BondType.DOUBLE);
        return this;
    }

    public Formula addAllHydrogens() {
        HashMap<Atom, List<Bond>> newStructure = new HashMap<Atom, List<Bond>>(this.structure);
        if (this.topology != Topology.LINEAR) {
            for (int i = 0; i < this.sideChains.size(); ++i) {
                Atom atom = ((Topology.SideChainInformation)this.sideChains.get(i).getFirst()).atom();
                double totalBonds = this.getTotalBonds((List)newStructure.get(atom));
                if (!(atom.getElement().getNextLowestValency(totalBonds) - totalBonds > 0.0)) continue;
                this.sideChains.get(i).setSecond((Object)Formula.atom(Element.HYDROGEN));
            }
        }
        for (Map.Entry<Atom, List<Bond>> entry : this.structure.entrySet()) {
            Atom atom = entry.getKey();
            List<Bond> bonds = entry.getValue();
            double totalBonds = this.getTotalBonds(bonds);
            int i = 0;
            while ((double)i < atom.getElement().getNextLowestValency(totalBonds) - totalBonds) {
                Atom hydrogen = new Atom(Element.HYDROGEN);
                Formula.addAtomToStructure(newStructure, atom, hydrogen, Bond.BondType.SINGLE);
                ++i;
            }
        }
        this.structure = newStructure;
        return this;
    }

    public void updateSideChainStructures() {
        if (this.topology == Topology.LINEAR) {
            return;
        }
        ArrayList<Pair<Topology.SideChainInformation, Formula>> newSideChains = new ArrayList<Pair<Topology.SideChainInformation, Formula>>();
        for (Pair<Topology.SideChainInformation, Formula> sideChain : this.sideChains) {
            Formula sideChainFormula = (Formula)sideChain.getSecond();
            Topology.SideChainInformation info = (Topology.SideChainInformation)sideChain.getFirst();
            Formula newSideChainFormula = sideChainFormula.shallowCopy();
            for (Atom atom : sideChainFormula.structure.keySet()) {
                ArrayList<Bond> bonds = new ArrayList<Bond>();
                if (this.structure.get(atom) == null) continue;
                for (Bond bond : this.structure.get(atom)) {
                    Atom potentialNewAtom = bond.getDestinationAtom();
                    if (this.topology.formula.structure.keySet().contains(potentialNewAtom)) continue;
                    if (!sideChainFormula.structure.keySet().contains(potentialNewAtom)) {
                        newSideChainFormula.structure.put(potentialNewAtom, this.structure.get(potentialNewAtom));
                    }
                    bonds.add(bond);
                }
                newSideChainFormula.structure.put(atom, bonds);
            }
            newSideChains.add((Pair<Topology.SideChainInformation, Formula>)Pair.of((Object)info, (Object)newSideChainFormula));
        }
        this.sideChains = newSideChains;
    }

    public Set<Atom> getAllAtoms() {
        return this.structure.keySet();
    }

    public List<Atom> getBondedAtomsOfElement(Element element) {
        return GroupFinder.bondedAtomsOfElementTo(this.structure, this.currentAtom, element);
    }

    public double getTotalBonds(List<Bond> bonds) {
        float total = 0.0f;
        for (Bond bond : bonds) {
            total += bond.getType().getEquivalent();
        }
        return total;
    }

    public List<Group<?>> getFunctionalGroups() {
        return this.groups;
    }

    private Branch getStrippedBranchStartingWithAtom(Atom atom) {
        Map<Atom, List<Bond>> newStructure = Formula.stripHydrogens(this.structure);
        if (this.topology == Topology.LINEAR) {
            return Formula.getMaximumBranch(atom, newStructure);
        }
        throw new ChemistryException.FormulaSerializationException("Cannot serialize branch if it is cyclic.");
    }

    public String serialize() {
        if (this.optimumFROWNSCode != null) {
            return this.optimumFROWNSCode;
        }
        Object body = "";
        String prefix = this.topology.getID();
        if (this.topology == Topology.LINEAR) {
            Map<Atom, List<Bond>> newStructure = Formula.stripHydrogens(this.structure);
            body = Formula.getMaximumBranchWithHighestMass(newStructure).serialize();
        } else {
            this.updateSideChainStructures();
            ArrayList<Branch> identity = new ArrayList<Branch>(this.topology.getConnections());
            if (this.topology.getConnections() > 0) {
                for (int i = 0; i < this.topology.getConnections(); ++i) {
                    Formula sideChain = (Formula)this.sideChains.get(i).getSecond();
                    if (sideChain.getAllAtoms().size() == 0 || sideChain.startingAtom.isHydrogen().booleanValue()) {
                        identity.add(new Branch(new Node(new Atom(Element.HYDROGEN))));
                        continue;
                    }
                    identity.add(sideChain.getStrippedBranchStartingWithAtom(sideChain.startingAtom));
                }
            }
            ArrayList possibleReflections = new ArrayList(this.topology.getReflections().length + 1);
            possibleReflections.add(identity);
            for (Object reflectionOrder : (Formula)this.topology.getReflections()) {
                ArrayList<Branch> reflection = new ArrayList<Branch>(this.topology.getConnections());
                for (Object reflectedBranchPosition : reflectionOrder) {
                    reflection.add((Branch)identity.get((int)reflectedBranchPosition));
                }
                possibleReflections.add(reflection);
            }
            Collections.sort(possibleReflections, (r1, r2) -> Formula.getReflectionComparison(r1).compareTo(Formula.getReflectionComparison(r2)));
            List bestReflection = (List)possibleReflections.get(0);
            if (bestReflection.size() > 0) {
                for (int i = 0; i < this.topology.getConnections(); ++i) {
                    Branch branch = (Branch)bestReflection.get(i);
                    if (!branch.getStartNode().getAtom().isHydrogen().booleanValue()) {
                        body = (String)body + branch.serialize();
                    }
                    body = (String)body + ",";
                }
            }
            if (((String)body).length() > 0) {
                body = ((String)body).substring(0, ((String)body).length() - 1);
            }
        }
        this.optimumFROWNSCode = prefix + ":" + (String)body;
        return this.optimumFROWNSCode;
    }

    private static Float getReflectionComparison(List<Branch> reflection) {
        float total = 0.0f;
        for (int i = 0; i < reflection.size(); ++i) {
            total += (float)i * reflection.get(i).getMassOfLongestChain().floatValue();
        }
        return Float.valueOf(total);
    }

    private static Branch getMaximumBranchWithHighestMass(Map<Atom, List<Bond>> structure) {
        ArrayList<Atom> terminalAtoms = new ArrayList<Atom>();
        for (Atom atom : structure.keySet()) {
            if (structure.get(atom).size() != 1) continue;
            terminalAtoms.add(atom);
        }
        Collections.sort(terminalAtoms, (a1, a2) -> Formula.getMaximumBranch(a2, structure).getMassOfLongestChain().compareTo(Formula.getMaximumBranch(a1, structure).getMassOfLongestChain()));
        Collections.sort(terminalAtoms, (a1, a2) -> Branch.getMassForComparisonInSerialization(a1).compareTo(Branch.getMassForComparisonInSerialization(a2)));
        return Formula.getMaximumBranch((Atom)terminalAtoms.get(0), structure);
    }

    public static Formula deserialize(String FROWNSstring) {
        try {
            Formula formula;
            String[] topologyAndFormula = FROWNSstring.strip().split(":");
            if (topologyAndFormula.length != 3) {
                throw new ChemistryException.MoleculeDeserializationException("Badly formatted FROWNS string '" + FROWNSstring + "'. They should be in the format 'namespace:topology:chains'.");
            }
            Topology topology = Topology.getTopology(topologyAndFormula[0] + ":" + topologyAndFormula[1]);
            String formulaString = topologyAndFormula[2];
            if (topology == Topology.LINEAR) {
                List<String> symbols = Arrays.stream(formulaString.split("(?=\\p{Upper})")).toList();
                formula = Formula.groupFromString(symbols);
            } else {
                if (topology.formula == null) {
                    throw new ChemistryException.MoleculeDeserializationException("Missing base formula for Topology " + topology.getID());
                }
                formula = topology.formula.shallowCopy();
                if (topology.getConnections() == 0) {
                    return formula.refreshFunctionalGroups();
                }
                int i = 0;
                for (String group : formulaString.split(",")) {
                    if (i > formula.topology.connections.size()) {
                        throw new ChemistryException.MoleculeDeserializationException("Formula '" + FROWNSstring + "' has too many groups for its Topology. There should be " + formula.topology.connections.size() + ".");
                    }
                    Formula sideChain = group.isBlank() ? new Formula(new Atom(Element.HYDROGEN)) : Formula.groupFromString(Arrays.stream(group.split("(?=\\p{Upper})")).toList());
                    formula.addGroupToPosition(sideChain, i, formula.topology.connections.get(i).bondType());
                    ++i;
                }
            }
            formula.addAllHydrogens().refreshFunctionalGroups();
            formula.updateSideChainStructures();
            return formula;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Could not parse FROWNS String '" + FROWNSstring + "'", e);
        }
    }

    public Formula refreshFunctionalGroups() {
        this.groups = new ArrayList();
        for (GroupFinder finder : GroupFinder.allGroupFinders()) {
            this.groups.addAll(finder.findGroups(this.structure));
        }
        return this;
    }

    public Formula shallowCopy() {
        try {
            Formula newFormula = (Formula)super.clone();
            newFormula.structure = new HashMap<Atom, List<Bond>>(this.structure.size());
            newFormula.structure = Formula.shallowCopyStructure(this.structure);
            newFormula.groups = new ArrayList(this.groups);
            newFormula.topology = this.topology;
            this.updateSideChainStructures();
            newFormula.sideChains = this.sideChains.stream().map(pair -> Pair.of((Object)((Topology.SideChainInformation)pair.getFirst()), (Object)((Formula)pair.getSecond()).shallowCopy())).toList();
            newFormula.optimumFROWNSCode = null;
            return newFormula;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public Float getCarbocationStability(Atom carbon, boolean isCarbanion) {
        Float totalElectronegativity = Float.valueOf(0.0f);
        for (Bond bond : this.structure.get(carbon)) {
            totalElectronegativity = Float.valueOf(totalElectronegativity.floatValue() + bond.getDestinationAtom().getElement().getElectronegativity().floatValue() * bond.getType().getEquivalent());
        }
        Float relativeElectronegativity = Float.valueOf(totalElectronegativity.floatValue() - Element.CARBON.getElectronegativity().floatValue() * 4.0f);
        Float relativeStability = Float.valueOf(1.0f + (float)Math.pow(relativeElectronegativity.floatValue(), 4.0) / Math.abs(relativeElectronegativity.floatValue()));
        return Float.valueOf(isCarbanion ^ relativeElectronegativity.floatValue() < 0.0f ? 1.0f / relativeStability.floatValue() : relativeStability.floatValue());
    }

    public Branch getRenderBranch() {
        if (this.topology != Topology.LINEAR) {
            throw new ChemistryException.FormulaException.FormulaRenderingException(this, "Cannot get a Render branch for a cyclic Molecule.");
        }
        return Formula.getMaximumBranchWithHighestMass(this.structure);
    }

    private static Map<Atom, List<Bond>> shallowCopyStructure(Map<Atom, List<Bond>> structureToCopy) {
        HashMap<Atom, List<Bond>> newStructure = new HashMap<Atom, List<Bond>>();
        for (Atom atom : structureToCopy.keySet()) {
            List<Bond> oldBonds = structureToCopy.get(atom);
            ArrayList<Bond> newBonds = new ArrayList<Bond>();
            for (Bond oldBond : oldBonds) {
                newBonds.add(new Bond(atom, oldBond.getDestinationAtom(), oldBond.getType()));
            }
            newStructure.put(atom, newBonds);
        }
        return newStructure;
    }

    private static Branch getMaximumBranch(Atom startAtom, Map<Atom, List<Bond>> structure) {
        HashMap<Atom, Node> allNodes = new HashMap<Atom, Node>();
        for (Atom atom : structure.keySet()) {
            allNodes.put(atom, new Node(atom));
        }
        Node currentNode = (Node)allNodes.get(startAtom);
        currentNode.visited = true;
        Branch maximumBranch = new Branch(currentNode);
        Boolean nodesAdded = true;
        while (nodesAdded.booleanValue()) {
            nodesAdded = false;
            HashMap<Node, Bond.BondType> connectedUnvisitedNodesAndTheirBondTypes = new HashMap<Node, Bond.BondType>();
            for (Bond bond : structure.get(currentNode.getAtom())) {
                Node connectedNode = (Node)allNodes.get(bond.getDestinationAtom());
                if (connectedNode == null || connectedNode.visited.booleanValue()) continue;
                connectedUnvisitedNodesAndTheirBondTypes.put(connectedNode, bond.getType());
            }
            if (connectedUnvisitedNodesAndTheirBondTypes.size() == 1) {
                Node onlyNode = (Node)connectedUnvisitedNodesAndTheirBondTypes.keySet().iterator().next();
                maximumBranch.add(onlyNode, (Bond.BondType)((Object)connectedUnvisitedNodesAndTheirBondTypes.get(onlyNode)));
                currentNode = onlyNode;
                nodesAdded = true;
                continue;
            }
            if (connectedUnvisitedNodesAndTheirBondTypes.size() == 0) continue;
            HashMap<Branch, Bond.BondType> connectedBranchesAndTheirBondTypes = new HashMap<Branch, Bond.BondType>();
            for (Node node : connectedUnvisitedNodesAndTheirBondTypes.keySet()) {
                Map<Atom, List<Bond>> newStructure = Formula.shallowCopyStructure(structure);
                Bond bondToRemove = null;
                for (Bond bond3 : structure.get(node.getAtom())) {
                    if (bond3.getDestinationAtom() != currentNode.getAtom()) continue;
                    bondToRemove = bond3;
                }
                if (bondToRemove != null) {
                    newStructure.get(node.getAtom()).remove(bondToRemove);
                }
                newStructure.remove(currentNode.getAtom());
                Branch branch = Formula.getMaximumBranch(node.getAtom(), newStructure);
                connectedBranchesAndTheirBondTypes.put(branch, (Bond.BondType)((Object)connectedUnvisitedNodesAndTheirBondTypes.get(node)));
            }
            ArrayList arrayList = new ArrayList(connectedBranchesAndTheirBondTypes.keySet());
            Collections.sort(arrayList, (b1, b2) -> b2.getMass().compareTo(b1.getMass()));
            Branch biggestBranch = (Branch)arrayList.get(0);
            maximumBranch.add(biggestBranch, (Bond.BondType)((Object)connectedBranchesAndTheirBondTypes.get(biggestBranch)));
            arrayList.remove(0);
            for (Branch sideBranch : arrayList) {
                currentNode.addSideBranch(sideBranch, (Bond.BondType)((Object)connectedBranchesAndTheirBondTypes.get(sideBranch)));
            }
        }
        return maximumBranch;
    }

    private static Map<Atom, List<Bond>> addAtomToStructure(Map<Atom, List<Bond>> structureToMutate, Atom rootAtom, Atom newAtom, Bond.BondType bondType) {
        structureToMutate.put(newAtom, new ArrayList());
        Formula.addBondBetweenAtoms(structureToMutate, rootAtom, newAtom, bondType);
        return structureToMutate;
    }

    private static void addGroupToStructure(Map<Atom, List<Bond>> structureToMutate, Atom rootAtom, Formula group, Bond.BondType bondType) {
        if (group.topology != Topology.LINEAR) {
            throw new ChemistryException.FormulaException.FormulaModificationException(group, "Cannot add Cycles as side-groups - to create a Cyclic Molecule, start with the Cycle and use addGroupAtPosition(), or use Formula.joinFormulae if this is in a Generic Reaction");
        }
        for (Map.Entry<Atom, List<Bond>> entry : group.structure.entrySet()) {
            if (structureToMutate.containsKey(entry.getKey())) {
                throw new ChemistryException.FormulaException.FormulaModificationException(group, "Cannot add a derivative of a Formula to itself.");
            }
            structureToMutate.put(entry.getKey(), entry.getValue());
        }
        Formula.addBondBetweenAtoms(structureToMutate, rootAtom, group.startingAtom, bondType);
    }

    private static void addBondBetweenAtoms(Map<Atom, List<Bond>> structureToMutate, Atom atom1, Atom atom2, Bond.BondType type) {
        Bond bond = new Bond(atom1, atom2, type);
        structureToMutate.get(atom1).add(bond);
        structureToMutate.get(atom2).add(bond.getMirror());
    }

    private static Formula groupFromString(List<String> symbols) {
        Formula formula = Formula.nothing();
        Boolean hasFormulaBeenInstantiated = false;
        Bond.BondType nextAtomBond = Bond.BondType.SINGLE;
        for (int i = 0; i < symbols.size(); ++i) {
            String symbol;
            if (symbols.get(i).matches(".*\\)")) {
                throw new ChemistryException.MoleculeDeserializationException("Chain bond type symbols must preceed side groups; for example chloroethene must be 'destroy:linear:C=(Cl)C' and not 'destroy:linear:C(Cl)=C'.");
            }
            HashMap<Formula, Bond.BondType> groupsToAdd = new HashMap<Formula, Bond.BondType>();
            Bond.BondType thisAtomBond = nextAtomBond;
            if (symbols.get(i).contains("(")) {
                Bond.BondType groupBond = Formula.trailingBondType(symbols.get(i));
                symbol = symbols.get(i).substring(0, symbols.get(i).indexOf(40));
                int brackets = 1;
                ArrayList<String> subSymbols = new ArrayList<String>();
                while (brackets > 0) {
                    ++i;
                    Boolean added = false;
                    for (int j = 0; j < symbols.get(i).length(); ++j) {
                        char c = symbols.get(i).charAt(j);
                        if (c == ')') {
                            --brackets;
                        } else if (c == '(') {
                            ++brackets;
                        }
                        if (brackets != 0) continue;
                        subSymbols.add(symbols.get(i).substring(0, j));
                        groupsToAdd.put(Formula.groupFromString(subSymbols), groupBond);
                        subSymbols = new ArrayList();
                        groupBond = Formula.trailingBondType(symbols.get(i));
                        added = true;
                    }
                    if (added.booleanValue()) continue;
                    subSymbols.add(symbols.get(i));
                }
            } else {
                symbol = symbols.get(i);
            }
            Boolean stripBond = true;
            nextAtomBond = Bond.BondType.SINGLE;
            switch (symbol.charAt(symbol.length() - 1)) {
                case '=': {
                    nextAtomBond = Bond.BondType.DOUBLE;
                    break;
                }
                case '#': {
                    nextAtomBond = Bond.BondType.TRIPLE;
                    break;
                }
                case '~': {
                    nextAtomBond = Bond.BondType.AROMATIC;
                    break;
                }
                default: {
                    stripBond = false;
                }
            }
            if (stripBond.booleanValue()) {
                symbol = symbol.substring(0, symbol.length() - 1);
            }
            char lastChar = symbol.charAt(symbol.length() - 1);
            int rGroupNumber = 0;
            if (Character.isDigit(lastChar)) {
                symbol = symbol.substring(0, symbol.length() - 1);
                rGroupNumber = lastChar - 48;
            }
            Atom atom = new Atom(Element.fromSymbol(symbol));
            atom.rGroupNumber = rGroupNumber;
            if (hasFormulaBeenInstantiated.booleanValue()) {
                formula.addGroup(new Formula(atom), false, thisAtomBond);
            } else {
                formula = new Formula(atom);
                hasFormulaBeenInstantiated = true;
            }
            for (Formula group : groupsToAdd.keySet()) {
                formula.addGroup(group, true, (Bond.BondType)((Object)groupsToAdd.get(group)));
            }
        }
        return formula;
    }

    private static Bond.BondType trailingBondType(String symbol) {
        return Bond.BondType.fromFROWNSCode(symbol.charAt(symbol.length() - 1));
    }

    private static Map<Atom, List<Bond>> stripHydrogens(Map<Atom, List<Bond>> structure) {
        HashMap<Atom, List<Bond>> newStructure = new HashMap<Atom, List<Bond>>();
        for (Atom atom : structure.keySet()) {
            ArrayList<Bond> bondsToAdd = new ArrayList<Bond>();
            for (Bond bond : structure.get(atom)) {
                if (bond.getDestinationAtom().isHydrogen().booleanValue()) continue;
                bondsToAdd.add(bond);
            }
            if (atom.isHydrogen().booleanValue()) continue;
            newStructure.put(atom, bondsToAdd);
        }
        return newStructure;
    }

    public static class Topology {
        private static final Map<String, Topology> TOPOLOGIES = new HashMap<String, Topology>();
        public static final Topology LINEAR = new Builder("destroy").build("linear");
        private final String nameSpace;
        private String id;
        private Formula formula;
        private final List<Pair<Vec3, Atom>> atomsAndLocations;
        private final List<Bond> bonds;
        private final List<SideChainInformation> connections;
        private int[][] reflections = null;

        private Topology(String nameSpace) {
            this.nameSpace = nameSpace;
            this.formula = null;
            this.atomsAndLocations = new ArrayList<Pair<Vec3, Atom>>();
            this.bonds = new ArrayList<Bond>();
            this.connections = new ArrayList<SideChainInformation>();
        }

        public static Topology getTopology(String id) {
            return TOPOLOGIES.get(id);
        }

        public String getID() {
            return this.nameSpace + ":" + this.id;
        }

        public int getConnections() {
            return this.connections.size();
        }

        public int[][] getReflections() {
            return this.reflections;
        }

        public static class Builder {
            private final String nameSpace;
            private final Topology topology;

            public Builder(String nameSpace) {
                this.nameSpace = nameSpace;
                this.topology = new Topology(nameSpace);
            }

            public Builder startWith(Element element) {
                this.topology.formula = Formula.atom(element);
                this.topology.atomsAndLocations.add((Pair<Vec3, Atom>)Pair.of((Object)new Vec3(0.0, 0.0, 0.0), (Object)this.topology.formula.startingAtom));
                return this;
            }

            public Builder sideChain(Vec3 bondDirection, Vec3 branchDirection) {
                return this.sideChain(bondDirection, branchDirection, Bond.BondType.SINGLE);
            }

            public Builder sideChain(Vec3 bondDirection, Vec3 branchDirection, Bond.BondType bondType) {
                if (this.topology.reflections != null) {
                    throw new ChemistryException.TopologyDefinitionException("Cannot add more side chains once the reflections have been declared.");
                }
                this.topology.connections.add(new SideChainInformation((Atom)this.topology.atomsAndLocations.get(0).getSecond(), bondDirection, branchDirection, bondType));
                return this;
            }

            public AttachedAtom atom(Element element, Vec3 location) {
                if (this.topology.formula == null) {
                    throw new ChemistryException.TopologyDefinitionException("Cannot add Atoms to a Topology that hasn't been initialized with startWith(Element)");
                }
                Atom atom = new Atom(element);
                this.topology.formula.structure.put(atom, new ArrayList());
                this.topology.atomsAndLocations.add((Pair<Vec3, Atom>)Pair.of((Object)location, (Object)atom));
                AttachedAtom attachedAtom = new AttachedAtom(this, atom);
                return attachedAtom;
            }

            public Builder reflections(int[][] reflections) {
                int connections = this.topology.getConnections();
                for (int[] reflection : reflections) {
                    int sum = 0;
                    for (int i : reflection) {
                        sum = (int)((double)sum + Math.pow(2.0, i));
                    }
                    if (sum == (int)Math.pow(2.0, connections) - 1 && reflection.length == connections) continue;
                    throw new ChemistryException.TopologyDefinitionException("Isomer configurations must match the number of side chains this Topology has.");
                }
                this.topology.reflections = reflections;
                return this;
            }

            public Topology build(String id) {
                this.topology.id = id;
                if (this.topology.formula != null) {
                    this.topology.formula.topology = this.topology;
                    this.topology.connections.forEach(sideChainInfo -> this.topology.formula.sideChains.add((Pair<SideChainInformation, Formula>)Pair.of((Object)sideChainInfo, (Object)new Formula())));
                }
                if (this.topology.reflections == null) {
                    this.topology.reflections = new int[this.topology.connections.size()][0];
                }
                TOPOLOGIES.put(this.nameSpace + ":" + id, this.topology);
                return this.topology;
            }
        }

        public record SideChainInformation(Atom atom, Vec3 bondDirection, Vec3 branchDirection, Bond.BondType bondType) {
        }

        public static class AttachedAtom {
            private final Builder builder;
            private final Atom atom;

            private AttachedAtom(Builder builder, Atom atom) {
                this.builder = builder;
                this.atom = atom;
            }

            public AttachedAtom withBondTo(int n, Bond.BondType bondType) {
                if (n >= this.builder.topology.atomsAndLocations.size()) {
                    throw new ChemistryException.TopologyDefinitionException("Tried to Bond an Atom back to Atom " + n + " but the " + n + "th atom has not yet been added to the Topology.");
                }
                if (this.builder.topology.formula == null) {
                    throw new ChemistryException.TopologyDefinitionException("Cannot add Bonds between Atoms that do not exist on the structure.");
                }
                Atom atomToWhichToAttach = (Atom)this.builder.topology.atomsAndLocations.get(n).getSecond();
                this.builder.topology.bonds.add(new Bond(this.atom, atomToWhichToAttach, bondType));
                Formula.addBondBetweenAtoms(this.builder.topology.formula.structure, this.atom, atomToWhichToAttach, bondType);
                return this;
            }

            public AttachedAtom withSideBranch(Vec3 bondDirection, Vec3 branchDirection) {
                return this.withSideBranch(bondDirection, branchDirection, Bond.BondType.SINGLE);
            }

            public AttachedAtom withSideBranch(Vec3 bondDirection, Vec3 branchDirection, Bond.BondType bondType) {
                if (this.builder.topology.reflections != null) {
                    throw new ChemistryException.TopologyDefinitionException("Cannot add more side chains once the reflections have been declared.");
                }
                this.builder.topology.connections.add(new SideChainInformation(this.atom, bondDirection, branchDirection, bondType));
                return this;
            }

            public Builder attach() {
                return this.builder;
            }
        }
    }
}

