/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.chemistry;

import com.petrolpark.destroy.chemistry.Atom;
import com.petrolpark.destroy.chemistry.Bond;
import com.petrolpark.destroy.chemistry.Element;
import com.petrolpark.destroy.chemistry.Group;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class GroupFinder {
    private static Set<GroupFinder> FINDERS = new HashSet<GroupFinder>();

    public GroupFinder() {
        FINDERS.add(this);
    }

    public static Set<GroupFinder> allGroupFinders() {
        return FINDERS;
    }

    public abstract List<Group<?>> findGroups(Map<Atom, List<Bond>> var1);

    public static List<Atom> bondedAtomsOfElementTo(Map<Atom, List<Bond>> structure, Atom atom, Element element) {
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        for (Bond bond : structure.get(atom)) {
            Atom destAtom = bond.getDestinationAtom();
            if (destAtom.getElement() != element || !structure.containsKey(destAtom)) continue;
            atoms.add(destAtom);
        }
        return atoms;
    }

    public static List<Atom> bondedAtomsOfElementTo(Map<Atom, List<Bond>> structure, Atom atom, Element element, Bond.BondType bondType) {
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        for (Bond bond : structure.get(atom)) {
            Atom destAtom = bond.getDestinationAtom();
            if (destAtom.getElement() != element || bond.getType() != bondType || !structure.containsKey(destAtom)) continue;
            atoms.add(destAtom);
        }
        return atoms;
    }
}

