/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.chemistry;

import com.google.common.base.MoreObjects;
import com.petrolpark.destroy.chemistry.Group;
import com.petrolpark.destroy.chemistry.Molecule;
import com.petrolpark.destroy.chemistry.error.ChemistryException;
import java.util.function.Supplier;

public class GroupType<G extends Group<G>> {
    private final Supplier<Molecule> exampleMolecule;
    private boolean exampleMoleculeVerified = false;

    public GroupType(Supplier<Molecule> exampleMoleculeSupplier) {
        this.exampleMolecule = exampleMoleculeSupplier;
    }

    public Molecule getExampleMolecule() {
        if (!this.exampleMoleculeVerified) {
            this.verifyExampleMolecule();
        }
        return this.exampleMolecule.get();
    }

    private void verifyExampleMolecule() {
        if (!this.exampleMolecule.get().getFunctionalGroups().stream().anyMatch(group -> group.getType() == this)) {
            throw new ChemistryException.ExampleMoleculeMissingGroupException(this.exampleMolecule.get());
        }
        this.exampleMoleculeVerified = true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Example Molecule", (Object)this.getExampleMolecule().getFullID()).toString();
    }
}

