/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.chemistry;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;

public interface IItemReactant {
    public boolean isItemValid(ItemStack var1);

    default public void consume(ItemStack stack) {
        stack.m_41774_(1);
    }

    public List<ItemStack> getDisplayedItemStacks();

    default public boolean isCatalyst() {
        return false;
    }

    public static class SimpleItemTagCatalyst
    extends SimpleItemTagReactant {
        public SimpleItemTagCatalyst(TagKey<Item> tag) {
            super(tag);
        }

        @Override
        public boolean isCatalyst() {
            return true;
        }

        @Override
        public void consume(ItemStack stack) {
        }
    }

    public static class SimpleItemTagReactant
    implements IItemReactant {
        protected final TagKey<Item> tag;

        public SimpleItemTagReactant(TagKey<Item> tag) {
            this.tag = tag;
        }

        @Override
        public boolean isItemValid(ItemStack stack) {
            return stack.m_204117_(this.tag);
        }

        @Override
        public List<ItemStack> getDisplayedItemStacks() {
            ITag tagIterable = ForgeRegistries.ITEMS.tags().getTag(this.tag);
            ArrayList<ItemStack> displayedStacks = new ArrayList<ItemStack>(tagIterable.size());
            tagIterable.forEach(item -> displayedStacks.add(new ItemStack((ItemLike)item)));
            return displayedStacks;
        }
    }

    public static class SimpleItemCatalyst
    extends SimpleItemReactant {
        public SimpleItemCatalyst(Supplier<Item> item) {
            super(item);
        }

        @Override
        public boolean isCatalyst() {
            return true;
        }

        @Override
        public void consume(ItemStack stack) {
        }
    }

    public static class SimpleItemReactant
    implements IItemReactant {
        protected final Supplier<Item> item;

        public SimpleItemReactant(Supplier<Item> item) {
            this.item = item;
        }

        @Override
        public boolean isItemValid(ItemStack stack) {
            return stack.m_150930_(this.item.get());
        }

        @Override
        public List<ItemStack> getDisplayedItemStacks() {
            return List.of(new ItemStack((ItemLike)this.item.get()));
        }
    }
}

