/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.chemistry;

import com.google.common.collect.ImmutableList;
import com.petrolpark.destroy.Destroy;
import com.petrolpark.destroy.chemistry.Group;
import com.petrolpark.destroy.chemistry.GroupType;
import com.petrolpark.destroy.chemistry.IItemReactant;
import com.petrolpark.destroy.chemistry.Molecule;
import com.petrolpark.destroy.chemistry.Reaction;
import com.petrolpark.destroy.chemistry.ReactionResult;
import com.petrolpark.destroy.chemistry.ReadOnlyMixture;
import com.petrolpark.destroy.chemistry.error.ChemistryException;
import com.petrolpark.destroy.chemistry.genericreaction.DoubleGroupGenericReaction;
import com.petrolpark.destroy.chemistry.genericreaction.GenericReactant;
import com.petrolpark.destroy.chemistry.genericreaction.GenericReaction;
import com.petrolpark.destroy.chemistry.genericreaction.SingleGroupGenericReaction;
import com.petrolpark.destroy.chemistry.index.DestroyMolecules;
import com.petrolpark.destroy.recipe.ReactionInBasinRecipe;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class Mixture
extends ReadOnlyMixture {
    protected static final int TICKS_PER_SECOND = 20;
    protected Map<ReactionResult, Float> reactionResults = new HashMap<ReactionResult, Float>();
    protected List<Molecule> novelMolecules = new ArrayList<Molecule>();
    protected List<Reaction> possibleReactions = new ArrayList<Reaction>();
    protected Map<GroupType<?>, List<GenericReactant<?>>> groupIDsAndMolecules = new HashMap();
    protected boolean equilibrium = false;
    Pair<Float, Molecule> nextHigherBoilingPoint = Pair.of((Object)Float.valueOf(Float.MAX_VALUE), null);
    Pair<Float, Molecule> nextLowerBoilingPoint = Pair.of((Object)Float.valueOf(0.0f), null);
    Map<Molecule, Integer> moleculesToRemove = new HashMap<Molecule, Integer>();

    public static Mixture pure(Molecule molecule) {
        Mixture mixture = new Mixture();
        if (molecule.getCharge() == 0) {
            mixture.addMolecule(molecule, molecule.getPureConcentration());
            return mixture;
        }
        Molecule otherIon = molecule.getCharge() < 0 ? DestroyMolecules.SODIUM_ION : DestroyMolecules.CHLORIDE;
        int chargeMagnitude = Math.abs(molecule.getCharge());
        mixture.addMolecule(molecule, 1.0f);
        mixture.addMolecule(otherIon, chargeMagnitude);
        mixture.recalculateVolume(1000);
        return mixture;
    }

    public static Mixture readNBT(CompoundTag compound) {
        Mixture mixture = new Mixture();
        if (compound == null) {
            Destroy.LOGGER.warn("Null Mixture loaded");
            return mixture;
        }
        mixture.translationKey = compound.m_128461_("TranslationKey");
        if (compound.m_128441_("Temperature")) {
            mixture.temperature = compound.m_128457_("Temperature");
        }
        ListTag contents = compound.m_128437_("Contents", 10);
        contents.forEach(tag -> {
            CompoundTag moleculeTag = (CompoundTag)tag;
            Molecule molecule = Molecule.getMolecule(moleculeTag.m_128461_("Molecule"));
            mixture.internalAddMolecule(molecule, moleculeTag.m_128457_("Concentration"), false);
            if (moleculeTag.m_128425_("Gaseous", 5)) {
                mixture.states.put(molecule, Float.valueOf(moleculeTag.m_128457_("Gaseous")));
            } else {
                mixture.states.put(molecule, Float.valueOf(molecule.getBoilingPoint() < mixture.temperature ? 1.0f : 0.0f));
            }
        });
        mixture.equilibrium = compound.m_128471_("AtEquilibrium");
        if (compound.m_128425_("Results", 9)) {
            ListTag results = compound.m_128437_("Results", 10);
            results.forEach(tag -> {
                CompoundTag resultTag = (CompoundTag)tag;
                ReactionResult result = Reaction.get(resultTag.m_128461_("Result")).getResult();
                if (result == null) {
                    return;
                }
                mixture.reactionResults.put(result, Float.valueOf(resultTag.m_128457_("MolesPerBucket")));
            });
        }
        mixture.updateName();
        mixture.updateColor();
        mixture.refreshPossibleReactions();
        mixture.updateNextBoilingPoints();
        return mixture;
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag tag = super.writeNBT();
        tag.m_128379_("AtEquilibrium", this.equilibrium);
        if (!this.reactionResults.isEmpty()) {
            tag.m_128365_("Results", (Tag)NBTHelper.writeCompoundList(this.reactionResults.entrySet(), entry -> {
                CompoundTag resultTag = new CompoundTag();
                resultTag.m_128359_("Result", ((ReactionResult)entry.getKey()).getReaction().getFullId());
                resultTag.m_128350_("MolesPerBucket", ((Float)entry.getValue()).floatValue());
                return resultTag;
            }));
        }
        return tag;
    }

    public Mixture setTemperature(float temperature) {
        this.temperature = temperature;
        for (Molecule molecule : this.contents.keySet()) {
            if (molecule.getBoilingPoint() < temperature) {
                this.states.put(molecule, Float.valueOf(1.0f));
                continue;
            }
            this.states.put(molecule, Float.valueOf(0.0f));
        }
        return this;
    }

    @Override
    public Mixture addMolecule(Molecule molecule, float concentration) {
        if (this.getConcentrationOf(molecule) > 0.0f) {
            this.changeConcentrationOf(molecule, concentration, true);
            this.updateName();
            this.updateColor();
            return this;
        }
        this.internalAddMolecule(molecule, concentration, true);
        this.equilibrium = false;
        return this;
    }

    @Override
    public List<Molecule> getContents(boolean excludeNovel) {
        return this.contents.keySet().stream().filter(molecule -> this.getConcentrationOf((Molecule)molecule) > 0.0f && (!molecule.isNovel() || !excludeNovel)).toList();
    }

    public static Mixture mix(Map<Mixture, Double> mixtures) {
        if (mixtures.size() == 0) {
            return new Mixture();
        }
        if (mixtures.size() == 1) {
            return mixtures.keySet().iterator().next();
        }
        Mixture resultMixture = new Mixture();
        HashMap<Molecule, Double> moleculesAndMoles = new HashMap<Molecule, Double>();
        HashMap<ReactionResult, Double> reactionResultsAndMoles = new HashMap<ReactionResult, Double>();
        double totalAmount = 0.0;
        float totalEnergy = 0.0f;
        for (Map.Entry<Mixture, Double> entry : mixtures.entrySet()) {
            Mixture mixture = entry.getKey();
            double amount = entry.getValue();
            totalAmount += amount;
            for (Map.Entry entry2 : mixture.contents.entrySet()) {
                Molecule molecule = (Molecule)entry2.getKey();
                float concentration = ((Float)entry2.getValue()).floatValue();
                moleculesAndMoles.merge(molecule, (double)concentration * amount, (m1, m2) -> m1 + m2);
                totalEnergy = (float)((double)totalEnergy + (double)(molecule.getMolarHeatCapacity() * concentration * mixture.temperature) * amount);
                totalEnergy = (float)((double)totalEnergy + (double)(molecule.getLatentHeat() * concentration * ((Float)mixture.states.get(molecule)).floatValue()) * amount);
            }
            for (Map.Entry<Object, Object> entry3 : mixture.reactionResults.entrySet()) {
                reactionResultsAndMoles.merge((ReactionResult)entry3.getKey(), (double)((Float)entry3.getValue()).floatValue() * amount, (r1, r2) -> r1 + r2);
            }
        }
        for (Map.Entry<Mixture, Double> entry : moleculesAndMoles.entrySet()) {
            Molecule molecule = (Molecule)((Object)entry.getKey());
            resultMixture.internalAddMolecule(molecule, (float)(entry.getValue() / totalAmount), false);
            resultMixture.states.put(molecule, Float.valueOf(0.0f));
        }
        for (Map.Entry<Mixture, Double> entry : reactionResultsAndMoles.entrySet()) {
            resultMixture.incrementReactionResults(((ReactionResult)((Object)entry.getKey())).getReaction(), (float)(entry.getValue() / totalAmount));
        }
        resultMixture.temperature = 0.0f;
        resultMixture.updateNextBoilingPoints();
        resultMixture.heat(totalEnergy / (float)totalAmount);
        resultMixture.refreshPossibleReactions();
        resultMixture.updateName();
        resultMixture.updateColor();
        resultMixture.updateNextBoilingPoints();
        return resultMixture;
    }

    @Override
    public float getConcentrationOf(Molecule molecule) {
        return super.getConcentrationOf(molecule);
    }

    public boolean isAtEquilibrium() {
        return this.equilibrium;
    }

    public void disturbEquilibrium() {
        this.equilibrium = false;
    }

    public void reactForTick(ReactionContext context, int cycles) {
        boolean shouldUpdateDisplay = true;
        for (int cycle = 0; cycle < cycles; ++cycle) {
            if (this.equilibrium) {
                shouldUpdateDisplay = false;
                break;
            }
            this.equilibrium = true;
            boolean shouldRefreshPossibleReactions = false;
            HashMap oldContents = new HashMap(this.contents);
            HashMap<Reaction, Float> reactionRates = new HashMap<Reaction, Float>();
            ArrayList<Reaction> orderedReactions = new ArrayList<Reaction>();
            block1: for (Reaction possibleReaction : this.possibleReactions) {
                if (possibleReaction.consumesItem()) continue;
                for (IItemReactant itemReactant : possibleReaction.getItemReactants()) {
                    boolean validStackFound = false;
                    for (ItemStack stack : context.availableItemStacks) {
                        if (!itemReactant.isItemValid(stack)) continue;
                        validStackFound = true;
                        break;
                    }
                    if (validStackFound) continue;
                    continue block1;
                }
                reactionRates.put(possibleReaction, Float.valueOf(this.calculateReactionRate(possibleReaction, context) / (float)cycles));
                orderedReactions.add(possibleReaction);
            }
            Collections.sort(orderedReactions, (r1, r2) -> ((Float)reactionRates.get(r1)).compareTo((Float)reactionRates.get(r2)));
            for (Reaction reaction : orderedReactions) {
                Float molesOfReaction = (Float)reactionRates.get(reaction);
                for (Molecule reactant : reaction.getReactants()) {
                    int reactantMolarRatio = reaction.getReactantMolarRatio(reactant);
                    float reactantConcentration = this.getConcentrationOf(reactant);
                    if (!(reactantConcentration < (float)reactantMolarRatio * molesOfReaction.floatValue())) continue;
                    molesOfReaction = Float.valueOf(reactantConcentration / (float)reactantMolarRatio);
                }
                if (molesOfReaction.floatValue() <= 0.0f) continue;
                shouldRefreshPossibleReactions |= this.doReaction(reaction, molesOfReaction.floatValue());
            }
            for (Molecule molecule : oldContents.keySet()) {
                if (Mixture.areVeryClose((Float)oldContents.get(molecule), Float.valueOf(this.getConcentrationOf(molecule)))) continue;
                this.equilibrium = false;
            }
            if (!shouldRefreshPossibleReactions) continue;
            this.refreshPossibleReactions();
        }
        boolean shouldUpdateReactions = false;
        Iterator<Map.Entry<Molecule, Integer>> iterator = this.moleculesToRemove.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Molecule, Integer> entry = iterator.next();
            entry.setValue(entry.getValue() - 1);
            if (entry.getValue() > 0) continue;
            this.removeMolecule(entry.getKey());
            iterator.remove();
            shouldUpdateReactions = true;
        }
        if (shouldUpdateReactions) {
            this.refreshPossibleReactions();
        }
        if (shouldUpdateDisplay) {
            this.updateName();
            this.updateColor();
        }
    }

    public void heat(float energyDensity) {
        float volumetricHeatCapacity = this.getVolumetricHeatCapacity();
        if (volumetricHeatCapacity == 0.0f) {
            return;
        }
        float temperatureChange = energyDensity / volumetricHeatCapacity;
        if (temperatureChange == 0.0f) {
            return;
        }
        if (temperatureChange > 0.0f) {
            if (this.nextHigherBoilingPoint.getSecond() != null && this.temperature + temperatureChange >= ((Float)this.nextHigherBoilingPoint.getFirst()).floatValue()) {
                Molecule molecule;
                float liquidConcentration;
                float energyRequiredToFullyBoil;
                temperatureChange = ((Float)this.nextHigherBoilingPoint.getFirst()).floatValue() - this.temperature;
                this.temperature += temperatureChange;
                if ((energyDensity -= temperatureChange * this.getVolumetricHeatCapacity()) > (energyRequiredToFullyBoil = (liquidConcentration = this.getConcentrationOf(molecule = (Molecule)this.nextHigherBoilingPoint.getSecond()) * (1.0f - ((Float)this.states.get(molecule)).floatValue())) * molecule.getLatentHeat())) {
                    this.states.put(molecule, Float.valueOf(1.0f));
                    this.temperature += 0.01f;
                    this.updateNextBoilingPoints();
                    this.heat(energyDensity - energyRequiredToFullyBoil);
                } else {
                    float boiled = energyDensity / (molecule.getLatentHeat() * this.getConcentrationOf(molecule));
                    this.states.merge(molecule, Float.valueOf(boiled), (f1, f2) -> Float.valueOf(f1.floatValue() + f2.floatValue()));
                }
                this.equilibrium = false;
            } else {
                this.temperature += temperatureChange;
            }
        } else if (this.nextLowerBoilingPoint.getSecond() != null && this.temperature + temperatureChange < ((Float)this.nextLowerBoilingPoint.getFirst()).floatValue()) {
            Molecule molecule;
            float gasConcentration;
            float energyReleasedWhenFullyCondensed;
            temperatureChange = ((Float)this.nextLowerBoilingPoint.getFirst()).floatValue() - this.temperature;
            this.temperature += temperatureChange;
            if ((energyDensity -= temperatureChange * this.getVolumetricHeatCapacity()) < -(energyReleasedWhenFullyCondensed = (gasConcentration = this.getConcentrationOf(molecule = (Molecule)this.nextLowerBoilingPoint.getSecond()) * ((Float)this.states.get(molecule)).floatValue()) * molecule.getLatentHeat())) {
                this.states.put(molecule, Float.valueOf(0.0f));
                this.temperature -= 0.01f;
                this.updateNextBoilingPoints();
                this.heat(energyDensity + energyReleasedWhenFullyCondensed);
            } else {
                float condensed = -energyDensity / (molecule.getLatentHeat() * this.getConcentrationOf(molecule));
                this.states.merge(molecule, Float.valueOf(1.0f - condensed), (f1, f2) -> Float.valueOf(f1.floatValue() + f2.floatValue() - 1.0f));
            }
            this.equilibrium = false;
        } else {
            this.temperature += temperatureChange;
        }
        this.temperature = Math.max(this.temperature, 1.0E-4f);
    }

    public void dissolveItems(ReactionContext context, double volume) {
        List<ItemStack> availableStacks = List.copyOf(context.availableItemStacks);
        if (availableStacks.isEmpty()) {
            return;
        }
        boolean shouldRefreshReactions = false;
        ArrayList<Reaction> orderedReactions = new ArrayList<Reaction>();
        for (Reaction possibleReaction : this.possibleReactions) {
            if (!possibleReaction.consumesItem()) continue;
            orderedReactions.add(possibleReaction);
        }
        if (orderedReactions.isEmpty()) {
            return;
        }
        Collections.sort(this.possibleReactions, (r1, r2) -> Float.valueOf(this.calculateReactionRate((Reaction)r1, context)).compareTo(Float.valueOf(this.calculateReactionRate((Reaction)r2, context))));
        block1: for (Reaction reaction : orderedReactions) {
            HashMap<ItemStack, ItemStack> copiesAndStacks = new HashMap<ItemStack, ItemStack>(availableStacks.size());
            HashMap<IItemReactant, ItemStack> reactantsAndStacks = new HashMap<IItemReactant, ItemStack>(reaction.getItemReactants().size());
            for (ItemStack stack : availableStacks) {
                if (stack.m_41619_()) continue;
                copiesAndStacks.put(stack.m_41777_(), stack);
            }
            while (true) {
                for (Molecule reactant : reaction.getReactants()) {
                    if (!(this.getConcentrationOf(reactant) < (float)reaction.getReactantMolarRatio(reactant).intValue() * reaction.getMolesPerItem() / (float)volume)) continue;
                    continue block1;
                }
                for (IItemReactant itemReactant : reaction.getItemReactants()) {
                    boolean validItemFound = false;
                    for (ItemStack stackCopy : copiesAndStacks.keySet()) {
                        if (!itemReactant.isItemValid(stackCopy)) continue;
                        validItemFound = true;
                        if (itemReactant.isCatalyst()) continue;
                        itemReactant.consume(stackCopy);
                        reactantsAndStacks.put(itemReactant, (ItemStack)copiesAndStacks.get(stackCopy));
                    }
                    if (validItemFound) continue;
                    continue block1;
                }
                for (IItemReactant itemReactant : reaction.getItemReactants()) {
                    if (itemReactant.isCatalyst()) continue;
                    itemReactant.consume((ItemStack)reactantsAndStacks.get(itemReactant));
                }
                this.equilibrium = false;
                shouldRefreshReactions |= this.doReaction(reaction, reaction.getMolesPerItem() / (float)volume);
            }
        }
        this.updateName();
        this.updateColor();
        if (shouldRefreshReactions) {
            this.refreshPossibleReactions();
        }
    }

    @Deprecated
    public int recalculateVolume(int initialVolume) {
        if (this.contents.isEmpty()) {
            return 0;
        }
        double initialVolumeInBuckets = (double)initialVolume / 1000.0;
        double newVolumeInBuckets = 0.0;
        HashMap<Molecule, Double> molesOfMolecules = new HashMap<Molecule, Double>();
        for (Map.Entry entry : this.contents.entrySet()) {
            Molecule molecule = (Molecule)entry.getKey();
            double molesOfMolecule = (double)((Float)entry.getValue()).floatValue() * initialVolumeInBuckets;
            molesOfMolecules.put(molecule, molesOfMolecule);
            newVolumeInBuckets += molesOfMolecule / (double)molecule.getPureConcentration();
        }
        for (Map.Entry entry : molesOfMolecules.entrySet()) {
            this.contents.replace((Molecule)entry.getKey(), Float.valueOf((float)((Double)entry.getValue() / newVolumeInBuckets)));
        }
        HashMap<ReactionResult, Float> resultsCopy = new HashMap<ReactionResult, Float>(this.reactionResults);
        for (Map.Entry entry : resultsCopy.entrySet()) {
            this.reactionResults.replace((ReactionResult)entry.getKey(), Float.valueOf((float)((double)((Float)entry.getValue()).floatValue() * initialVolumeInBuckets / newVolumeInBuckets)));
        }
        return (int)(newVolumeInBuckets * 1000.0 + 0.5);
    }

    public void scale(float volumeIncreaseFactor) {
        this.contents.replaceAll((molecule, concentration) -> Float.valueOf(concentration.floatValue() / volumeIncreaseFactor));
        this.reactionResults.replaceAll((reactionResult, molesPerBucket) -> Float.valueOf(molesPerBucket.floatValue() / volumeIncreaseFactor));
    }

    public Phases separatePhases(double initialVolume) {
        HashMap<Molecule, Double> liquidMoles = new HashMap<Molecule, Double>();
        HashMap<Molecule, Double> gasMoles = new HashMap<Molecule, Double>();
        double newLiquidVolume = 0.0;
        double newGasVolume = 1.0;
        Mixture liquidMixture = new Mixture();
        Mixture gasMixture = new Mixture();
        for (Map.Entry entry : this.contents.entrySet()) {
            Molecule molecule = (Molecule)entry.getKey();
            float concentration = ((Float)entry.getValue()).floatValue();
            float proportionGaseous = ((Float)this.states.get(molecule)).floatValue();
            double molesOfLiquidMolecule = (double)(concentration * (1.0f - proportionGaseous)) * initialVolume;
            liquidMoles.put(molecule, molesOfLiquidMolecule);
            newLiquidVolume += molesOfLiquidMolecule / (double)molecule.getPureConcentration();
            gasMoles.put(molecule, (double)(concentration * proportionGaseous) * initialVolume);
        }
        for (Map.Entry entry : liquidMoles.entrySet()) {
            double moles = (Double)entry.getValue();
            if (moles == 0.0) continue;
            liquidMixture.internalAddMolecule((Molecule)entry.getKey(), (float)(moles / newLiquidVolume), false);
            liquidMixture.states.put((Molecule)entry.getKey(), Float.valueOf(0.0f));
        }
        for (Map.Entry entry : gasMoles.entrySet()) {
            double moles = (Double)entry.getValue();
            if (moles == 0.0) continue;
            gasMixture.internalAddMolecule((Molecule)entry.getKey(), (float)(moles / newGasVolume), false);
            gasMixture.states.put((Molecule)entry.getKey(), Float.valueOf(1.0f));
        }
        for (Map.Entry<Object, Object> entry : this.reactionResults.entrySet()) {
            double resultMoles = (double)((Float)entry.getValue()).floatValue() * initialVolume;
            liquidMixture.reactionResults.put((ReactionResult)entry.getKey(), Float.valueOf((float)(resultMoles / newLiquidVolume)));
            gasMixture.reactionResults.put((ReactionResult)entry.getKey(), Float.valueOf((float)(resultMoles / newGasVolume)));
        }
        liquidMixture.temperature = this.temperature;
        gasMixture.temperature = this.temperature;
        liquidMixture.refreshPossibleReactions();
        gasMixture.refreshPossibleReactions();
        liquidMixture.equilibrium = this.equilibrium;
        gasMixture.equilibrium = this.equilibrium;
        return new Phases(gasMixture, newGasVolume, liquidMixture, newLiquidVolume);
    }

    protected boolean doReaction(Reaction reaction, float molesPerBucket) {
        boolean shouldRefreshPossibleReactions = false;
        for (Molecule reactant : reaction.getReactants()) {
            this.changeConcentrationOf(reactant, -(molesPerBucket * (float)reaction.getReactantMolarRatio(reactant).intValue()), false);
        }
        for (Molecule product : reaction.getProducts()) {
            if (product.isNovel() && this.getConcentrationOf(product) == 0.0f) {
                if (!this.internalAddMolecule(product, molesPerBucket * (float)reaction.getProductMolarRatio(product).intValue(), false)) continue;
                shouldRefreshPossibleReactions = true;
                continue;
            }
            if (this.getConcentrationOf(product) == 0.0f) {
                shouldRefreshPossibleReactions = true;
            }
            this.changeConcentrationOf(product, molesPerBucket * (float)reaction.getProductMolarRatio(product).intValue(), false);
        }
        this.heat(-reaction.getEnthalpyChange() * 1000.0f * molesPerBucket);
        this.incrementReactionResults(reaction, molesPerBucket);
        return shouldRefreshPossibleReactions;
    }

    protected void incrementReactionResults(Reaction reaction, float molesPerBucket) {
        if (!reaction.hasResult()) {
            return;
        }
        ReactionResult result = reaction.getResult();
        this.reactionResults.merge(result, Float.valueOf(molesPerBucket), (f1, f2) -> Float.valueOf(f1.floatValue() + f2.floatValue()));
    }

    public ReactionInBasinRecipe.ReactionInBasinResult reactInBasin(int volume, List<ItemStack> availableStacks, float heatingPower, float outsideTemperature) {
        int ticks;
        float volumeInBuckets = (float)volume / 1000.0f;
        ReactionContext context = new ReactionContext(availableStacks, 0.0f);
        this.dissolveItems(context, volumeInBuckets);
        for (ticks = 0; !this.equilibrium && ticks < 600; ++ticks) {
            float energyChange = heatingPower / 20.0f;
            if (Math.abs(energyChange += (outsideTemperature - this.temperature) * 100.0f / 20.0f) > 1.0E-4f) {
                this.heat(1000.0f * energyChange / (float)volume);
            }
            this.reactForTick(context, 1);
        }
        if (ticks == 0) {
            return new ReactionInBasinRecipe.ReactionInBasinResult(0, Map.of(), volume);
        }
        int amount = this.recalculateVolume(volume);
        return new ReactionInBasinRecipe.ReactionInBasinResult(ticks, this.getCompletedResults(volumeInBuckets), amount);
    }

    public Map<ReactionResult, Integer> getCompletedResults(double volumeInBuckets) {
        HashMap<ReactionResult, Integer> results = new HashMap<ReactionResult, Integer>();
        if (this.reactionResults.isEmpty()) {
            return results;
        }
        for (ReactionResult result : this.reactionResults.keySet()) {
            if (result.isOneOff()) {
                results.put(result, 1);
                continue;
            }
            Float molesPerBucketOfReaction = this.reactionResults.get(result);
            int numberOfResult = (int)(volumeInBuckets * (double)molesPerBucketOfReaction.floatValue() / (double)result.getRequiredMoles());
            if (numberOfResult == 0) continue;
            this.reactionResults.replace(result, Float.valueOf(molesPerBucketOfReaction.floatValue() - (float)numberOfResult * result.getRequiredMoles() / (float)volumeInBuckets));
            results.put(result, numberOfResult);
        }
        return results;
    }

    public float getVolumetricHeatCapacity() {
        float totalHeatCapacity = 0.0f;
        for (Map.Entry entry : this.contents.entrySet()) {
            totalHeatCapacity += ((Molecule)entry.getKey()).getMolarHeatCapacity() * ((Float)entry.getValue()).floatValue();
        }
        return totalHeatCapacity;
    }

    protected void updateNextBoilingPoints() {
        this.nextHigherBoilingPoint = Pair.of((Object)Float.valueOf(Float.MAX_VALUE), null);
        this.nextLowerBoilingPoint = Pair.of((Object)Float.valueOf(0.0f), null);
        for (Molecule molecule : this.contents.keySet()) {
            float bp = molecule.getBoilingPoint();
            if (bp <= this.temperature && bp > ((Float)this.nextLowerBoilingPoint.getFirst()).floatValue()) {
                this.nextLowerBoilingPoint = Pair.of((Object)Float.valueOf(bp), (Object)molecule);
            }
            if (!(bp >= this.temperature) || !(bp < ((Float)this.nextHigherBoilingPoint.getFirst()).floatValue())) continue;
            this.nextHigherBoilingPoint = Pair.of((Object)Float.valueOf(bp), (Object)molecule);
        }
    }

    private boolean internalAddMolecule(Molecule molecule, float concentration, boolean shouldRefreshReactions) {
        List<Group<?>> functionalGroups;
        boolean newMoleculeAdded = true;
        if (this.contents.containsKey(molecule)) {
            this.changeConcentrationOf(molecule, concentration, shouldRefreshReactions);
            return false;
        }
        if (!molecule.isNovel()) {
            super.addMolecule(molecule, concentration);
        }
        if ((functionalGroups = molecule.getFunctionalGroups()).size() != 0) {
            for (Group<?> group : functionalGroups) {
                this.addGroupToMixture(molecule, group);
            }
        }
        if (molecule.isNovel()) {
            boolean found = false;
            for (Molecule novelMolecule : this.novelMolecules) {
                if (!novelMolecule.getFullID().equals(molecule.getFullID())) continue;
                found = true;
                newMoleculeAdded = false;
                this.changeConcentrationOf(novelMolecule, concentration, true);
                this.equilibrium = false;
            }
            if (!found) {
                super.addMolecule(molecule, concentration);
                this.novelMolecules.add(molecule);
            }
        }
        if (shouldRefreshReactions && newMoleculeAdded) {
            this.refreshPossibleReactions();
        }
        this.equilibrium = false;
        return newMoleculeAdded;
    }

    private <G extends Group<G>> void addGroupToMixture(Molecule molecule, G group) {
        GroupType<G> groupType = group.getType();
        if (!this.groupIDsAndMolecules.containsKey(groupType)) {
            this.groupIDsAndMolecules.put(groupType, new ArrayList());
        }
        this.groupIDsAndMolecules.get(groupType).add(new GenericReactant<G>(molecule, group));
    }

    private Mixture removeMolecule(Molecule molecule) {
        List<Group<?>> functionalGroups = molecule.getFunctionalGroups();
        if (functionalGroups.size() != 0) {
            for (Group<?> group : functionalGroups) {
                this.groupIDsAndMolecules.get(group.getType()).removeIf(reactant -> reactant.getMolecule() == molecule);
            }
        }
        if (molecule.isNovel()) {
            this.novelMolecules.remove(molecule);
        }
        this.contents.remove(molecule);
        this.equilibrium = false;
        this.updateNextBoilingPoints();
        return this;
    }

    private Mixture changeConcentrationOf(Molecule molecule, float change, boolean shouldRefreshReactions) {
        Float currentConcentration = Float.valueOf(this.getConcentrationOf(molecule));
        if (!this.contents.containsKey(molecule) && change > 0.0f) {
            this.internalAddMolecule(molecule, change, shouldRefreshReactions);
        }
        if (currentConcentration.floatValue() <= 0.0f && change < 0.0f) {
            throw new IllegalArgumentException("Attempted to decrease concentration of Molecule '" + molecule.getFullID() + "', which was not in a Mixture. The Mixture contains " + this.getContentsString());
        }
        float newConcentration = Math.max(currentConcentration.floatValue() + change, 0.0f);
        this.contents.replace(molecule, Float.valueOf(newConcentration));
        if (newConcentration <= 0.0f) {
            this.moleculesToRemove.put(molecule, 10);
        }
        if (newConcentration > 0.0f) {
            this.moleculesToRemove.remove(molecule);
        }
        return this;
    }

    private float calculateReactionRate(Reaction reaction, ReactionContext context) {
        float rate = reaction.getRateConstant(this.temperature) / 20.0f;
        for (Molecule molecule : reaction.getOrders().keySet()) {
            rate *= (float)Math.pow(this.getConcentrationOf(molecule), reaction.getOrders().get(molecule).intValue());
        }
        if (reaction.needsUV()) {
            rate *= context.UVPower;
        }
        return rate;
    }

    private void refreshPossibleReactions() {
        this.possibleReactions = new ArrayList<Reaction>();
        HashSet<Reaction> newPossibleReactions = new HashSet<Reaction>();
        for (GroupType<?> groupType : this.groupIDsAndMolecules.keySet()) {
            for (GenericReaction genericReaction : Group.getReactionsOfGroupByID(groupType)) {
                DoubleGroupGenericReaction dggr;
                if (genericReaction.involvesSingleGroup()) {
                    newPossibleReactions.addAll(this.specifySingleGroupGenericReactions(genericReaction, this.groupIDsAndMolecules.get(groupType)));
                    continue;
                }
                if (!(genericReaction instanceof DoubleGroupGenericReaction) || groupType != (dggr = (DoubleGroupGenericReaction)genericReaction).getFirstGroupType()) continue;
                GroupType secondGroupType = dggr.getSecondGroupType();
                if (!this.groupIDsAndMolecules.keySet().contains(secondGroupType)) continue;
                ArrayList reactantPairs = new ArrayList();
                for (GenericReactant<?> firstGenericReactant : this.groupIDsAndMolecules.get(groupType)) {
                    for (GenericReactant<?> secondGenericReactant : this.groupIDsAndMolecules.get(secondGroupType)) {
                        reactantPairs.add(Pair.of(firstGenericReactant, secondGenericReactant));
                    }
                }
                newPossibleReactions.addAll(this.specifyDoubleGroupGenericReactions(dggr, reactantPairs));
            }
        }
        for (Molecule possibleReactant : this.contents.keySet()) {
            newPossibleReactions.addAll(possibleReactant.getReactantReactions());
        }
        for (Reaction reaction : newPossibleReactions) {
            Boolean reactionHasAllReactants = true;
            for (Molecule necessaryReactantOrCatalyst : reaction.getOrders().keySet()) {
                if (this.getConcentrationOf(necessaryReactantOrCatalyst) != 0.0f) continue;
                reactionHasAllReactants = false;
                break;
            }
            if (!reactionHasAllReactants.booleanValue()) continue;
            this.possibleReactions.add(reaction);
        }
    }

    private <G extends Group<G>> List<Reaction> specifySingleGroupGenericReactions(GenericReaction genericReaction, List<GenericReactant<?>> reactants) {
        ArrayList<Reaction> reactions = new ArrayList<Reaction>();
        SingleGroupGenericReaction singleGroupGenericReaction = (SingleGroupGenericReaction)genericReaction;
        for (GenericReactant<?> reactant : reactants) {
            try {
                Reaction reaction = singleGroupGenericReaction.generateReaction(reactant);
                if (reaction == null) continue;
                reactions.add(reaction);
            }
            catch (ChemistryException chemistryException) {}
        }
        return reactions;
    }

    private <G1 extends Group<G1>, G2 extends Group<G2>> List<Reaction> specifyDoubleGroupGenericReactions(GenericReaction genericReaction, List<Pair<GenericReactant<?>, GenericReactant<?>>> reactantPairs) {
        DoubleGroupGenericReaction doubleGroupGenericReaction = (DoubleGroupGenericReaction)genericReaction;
        ArrayList<Reaction> reactions = new ArrayList<Reaction>();
        for (Pair<GenericReactant<?>, GenericReactant<?>> reactantPair : reactantPairs) {
            if (((GenericReactant)reactantPair.getFirst()).getMolecule() == ((GenericReactant)reactantPair.getSecond()).getMolecule()) continue;
            try {
                Reaction reaction = doubleGroupGenericReaction.generateReaction((GenericReactant)reactantPair.getFirst(), (GenericReactant)reactantPair.getSecond());
                if (reaction == null) continue;
                reactions.add(reaction);
            }
            catch (ChemistryException chemistryException) {}
        }
        return reactions;
    }

    public static boolean areVeryClose(Float f1, Float f2) {
        return Math.abs(f1.floatValue() - f2.floatValue()) <= 1.0E-4f;
    }

    public static class ReactionContext {
        public final ImmutableList<ItemStack> availableItemStacks;
        public final float UVPower;

        public ReactionContext(List<ItemStack> availableItemStacks, float UVPower) {
            this.availableItemStacks = ImmutableList.copyOf(availableItemStacks);
            this.UVPower = UVPower;
        }
    }

    public record Phases(Mixture gasMixture, Double gasVolume, Mixture liquidMixture, Double liquidVolume) {
    }
}

