/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.chemistry;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.petrolpark.destroy.Destroy;
import com.petrolpark.destroy.chemistry.Atom;
import com.petrolpark.destroy.chemistry.Bond;
import com.petrolpark.destroy.chemistry.Element;
import com.petrolpark.destroy.chemistry.Formula;
import com.petrolpark.destroy.chemistry.Group;
import com.petrolpark.destroy.chemistry.GroupType;
import com.petrolpark.destroy.chemistry.MoleculeTag;
import com.petrolpark.destroy.chemistry.Reaction;
import com.petrolpark.destroy.chemistry.error.ChemistryException;
import com.petrolpark.destroy.chemistry.index.DestroyGroupTypes;
import com.petrolpark.destroy.chemistry.index.DestroyMolecules;
import com.petrolpark.destroy.chemistry.naming.INameableProduct;
import com.petrolpark.destroy.chemistry.serializer.Branch;
import com.petrolpark.destroy.client.gui.MoleculeRenderer;
import com.petrolpark.destroy.util.DestroyLang;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec3;

public class Molecule
implements INameableProduct {
    public static final Set<String> NAMESPACES = new HashSet<String>();
    public static final Set<String> FORBIDDEN_NAMESPACES = new HashSet<String>();
    public static final Map<String, Molecule> MOLECULES = new HashMap<String, Molecule>();
    public final String nameSpace;
    private String id;
    private int charge;
    private float mass;
    private float density;
    private float boilingPoint;
    private float dipoleMoment;
    private float molarHeatCapacity;
    private float latentHeat;
    private Formula structure;
    private Set<MoleculeTag> tags;
    private List<Reaction> reactantReactions;
    private List<Reaction> productReactions;
    private String translationKey;
    private int color;
    private MoleculeRenderer renderer;

    private Molecule(String nameSpace) {
        this.nameSpace = nameSpace;
        this.id = null;
        this.structure = null;
        this.tags = new HashSet<MoleculeTag>();
        this.reactantReactions = new ArrayList<Reaction>();
        this.productReactions = new ArrayList<Reaction>();
    }

    @Nullable
    public static Molecule getMolecule(String id) {
        String[] idComponents = id.split(":");
        Molecule molecule = MOLECULES.get(id);
        if (molecule != null) {
            return molecule;
        }
        if (idComponents.length == 3) {
            return new MoleculeBuilder("novel").structure(Formula.deserialize(id)).build();
        }
        if (idComponents.length == 2) {
            return MOLECULES.get(id);
        }
        if (!id.matches("NO_MOLECULE")) {
            Destroy.LOGGER.warn("Could not find Molecule '" + id + "'.");
        }
        return null;
    }

    public String getFullID() {
        if (this.id == null) {
            return this.structure.serialize();
        }
        return this.nameSpace + ":" + this.id;
    }

    public Molecule getEquivalent() {
        for (Molecule molecule : MOLECULES.values()) {
            if (!((double)Math.abs(this.getMass() - molecule.getMass()) < 0.001) || !this.structure.serialize().equals(molecule.structure.serialize())) continue;
            return molecule;
        }
        return this;
    }

    public String getFROWNSCode() {
        return this.structure.serialize();
    }

    public int getCharge() {
        return this.charge;
    }

    public float getMass() {
        return this.mass;
    }

    public float getDensity() {
        return this.density;
    }

    public float getPureConcentration() {
        return this.getDensity() / this.getMass();
    }

    public float getBoilingPoint() {
        return this.boilingPoint;
    }

    public float getDipoleMoment() {
        return this.dipoleMoment;
    }

    public float getMolarHeatCapacity() {
        return this.molarHeatCapacity;
    }

    public float getLatentHeat() {
        return this.latentHeat;
    }

    public boolean isCyclic() {
        return this.structure.isCyclic();
    }

    public Formula shallowCopyStructure() {
        return this.structure.shallowCopy();
    }

    public Set<Atom> getAtoms() {
        return this.structure.getAllAtoms();
    }

    public boolean isHypothetical() {
        return this.tags.contains(DestroyMolecules.Tags.HYPOTHETICAL);
    }

    public ImmutableSet<MoleculeTag> getTags() {
        return ImmutableSet.copyOf(this.tags);
    }

    public boolean hasTag(MoleculeTag tag) {
        if (tag == null) {
            return false;
        }
        return this.tags.contains(tag);
    }

    public boolean isNovel() {
        return this.nameSpace == "novel";
    }

    public Map<Element, Integer> getMolecularFormula() {
        HashMap<Element, Integer> empiricalFormula = new HashMap<Element, Integer>();
        for (Atom atom : this.structure.getAllAtoms()) {
            Element element = atom.getElement();
            if (empiricalFormula.containsKey((Object)element)) {
                int count = (Integer)empiricalFormula.get((Object)element);
                empiricalFormula.replace(element, count + 1);
                continue;
            }
            empiricalFormula.put(element, 1);
        }
        return empiricalFormula;
    }

    public String getSerlializedMolecularFormula(boolean subscript) {
        Map<Element, Integer> formulaMap = this.getMolecularFormula();
        ArrayList<Element> elements = new ArrayList<Element>(formulaMap.keySet());
        elements.sort(Comparator.naturalOrder());
        Object formula = "";
        for (Element element : elements) {
            int count = formulaMap.get((Object)element);
            String number = count == 1 ? "" : (subscript ? DestroyLang.toSubscript(count) : String.valueOf(count));
            formula = (String)formula + element.getSymbol() + number;
        }
        return formula;
    }

    public String getStructuralFormula() {
        return this.structure.serialize();
    }

    public Float getCarbocationStability(Atom carbon, boolean isCarbanion) {
        return this.structure.getCarbocationStability(carbon, isCarbanion);
    }

    public void addReactantReaction(Reaction reaction) {
        if (reaction.containsReactant(this).booleanValue()) {
            this.reactantReactions.add(reaction);
        }
    }

    public void addProductReaction(Reaction reaction) {
        if (reaction.containsProduct(this).booleanValue()) {
            this.productReactions.add(reaction);
        }
    }

    public List<Reaction> getReactantReactions() {
        return this.reactantReactions;
    }

    public List<Reaction> getProductReactions() {
        return this.productReactions;
    }

    @Override
    public Component getName(boolean iupac) {
        if (this.isNovel()) {
            return Component.m_237113_((String)this.getSerlializedMolecularFormula(true));
        }
        return Component.m_237115_((String)this.getTranslationKey(iupac));
    }

    public String getTranslationKey(boolean iupac) {
        if (this.isNovel()) {
            return "destroy.chemical.unknown";
        }
        String key = this.nameSpace + ".chemical." + this.translationKey;
        String iupacKey = key + ".iupac";
        if (iupac && I18n.m_118936_((String)iupacKey)) {
            key = iupacKey;
        }
        return key;
    }

    public int getColor() {
        return this.color;
    }

    public boolean isColorless() {
        return this.color >> 24 == 0;
    }

    public String getSerializedCharge(boolean alwaysShowNumber) {
        Object chargeString = "";
        if (this.charge == 0) {
            return chargeString;
        }
        if (alwaysShowNumber || this.charge != 1 && this.charge != -1) {
            chargeString = (String)chargeString + Math.abs(this.charge);
        }
        chargeString = (String)chargeString + (this.charge < 0 ? "-" : "+");
        return chargeString;
    }

    public List<Group<?>> getFunctionalGroups() {
        return this.structure.getFunctionalGroups();
    }

    public Branch getRenderBranch() {
        return this.structure.getRenderBranch();
    }

    public List<Pair<Vec3, Atom>> getCyclicAtomsForRendering() {
        if (!this.isCyclic()) {
            return List.of();
        }
        return this.structure.getCyclicAtomsForRendering();
    }

    public List<Bond> getCyclicBondsForRendering() {
        if (!this.isCyclic()) {
            return List.of();
        }
        return this.structure.getCyclicBondsForRendering();
    }

    public List<Pair<Formula.Topology.SideChainInformation, Branch>> getSideChainsForRendering() {
        if (!this.isCyclic()) {
            return List.of();
        }
        return this.structure.getSideChainsForRendering();
    }

    public MoleculeRenderer getRenderer() {
        if (this.renderer == null) {
            this.renderer = new MoleculeRenderer(this);
        }
        return this.renderer;
    }

    private void refreshFunctionalGroups() {
        this.structure.refreshFunctionalGroups();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ID", (Object)this.getFullID()).toString();
    }

    public static class MoleculeBuilder {
        private Molecule molecule;
        private Boolean hasForcedDensity = false;
        private Boolean hasForcedBoilingPoint = false;
        private Boolean hasForcedDipoleMoment = false;
        private Boolean hasForcedMolarHeatCapacity = false;
        private Boolean hasForcedLatentHeat = false;
        private String translationKey;

        public MoleculeBuilder(String nameSpace) {
            this.molecule = new Molecule(nameSpace);
            if (FORBIDDEN_NAMESPACES.contains(nameSpace)) {
                throw this.e("Cannot use name space '" + nameSpace + "'.");
            }
            NAMESPACES.add(nameSpace);
            this.molecule.charge = 0;
            this.molecule.density = 1000.0f;
        }

        public MoleculeBuilder id(String id) {
            this.molecule.id = id;
            this.translationKey(id);
            return this;
        }

        public MoleculeBuilder structure(Formula structure) {
            try {
                this.molecule.structure = structure;
                return this;
            }
            catch (ChemistryException.FormulaException.FormulaModificationException e) {
                throw this.e("Cannot use structure.", e);
            }
        }

        public MoleculeBuilder density(float density) {
            this.molecule.density = density;
            this.hasForcedDensity = true;
            return this;
        }

        public MoleculeBuilder charge(int charge) {
            this.molecule.charge = charge;
            if (charge != 0) {
                this.boilingPointInKelvins(Float.MAX_VALUE);
            }
            return this;
        }

        public MoleculeBuilder boilingPoint(float boilingPoint) {
            return this.boilingPointInKelvins(boilingPoint + 273.0f);
        }

        public MoleculeBuilder boilingPointInKelvins(float boilingPoint) {
            this.molecule.boilingPoint = boilingPoint;
            this.hasForcedBoilingPoint = true;
            return this;
        }

        public MoleculeBuilder dipoleMoment(int dipoleMoment) {
            this.molecule.dipoleMoment = dipoleMoment;
            this.hasForcedDipoleMoment = true;
            return this;
        }

        public MoleculeBuilder specificHeatCapacity(float specificHeatCapacity) {
            return this.molarHeatCapacity(specificHeatCapacity / this.calculateMass());
        }

        public MoleculeBuilder molarHeatCapacity(float molarHeatCapacity) {
            if (molarHeatCapacity <= 0.0f) {
                throw this.e("Molar heat capacity must be greater than 0.");
            }
            this.molecule.molarHeatCapacity = molarHeatCapacity;
            this.hasForcedMolarHeatCapacity = true;
            return this;
        }

        public MoleculeBuilder latentHeat(float latentHeat) {
            if (latentHeat <= 0.0f) {
                throw this.e("Latent heat of fusion must be greater than 0.");
            }
            this.molecule.latentHeat = latentHeat;
            this.hasForcedLatentHeat = true;
            return this;
        }

        public MoleculeBuilder translationKey(String translationKey) {
            this.translationKey = translationKey;
            return this;
        }

        public MoleculeBuilder color(int color) {
            this.molecule.color = color;
            return this;
        }

        public MoleculeBuilder hypothetical() {
            return this.tag(DestroyMolecules.Tags.HYPOTHETICAL);
        }

        public MoleculeBuilder tag(MoleculeTag ... tags) {
            for (MoleculeTag tag : tags) {
                MoleculeTag.registerMoleculeToTag(this.molecule, tag);
            }
            this.molecule.tags.addAll(List.of(tags));
            return this;
        }

        public Molecule build() {
            Molecule equivalentMolecule;
            this.molecule.mass = this.calculateMass();
            this.molecule.translationKey = this.translationKey;
            if (this.molecule.structure == null) {
                throw this.e("Molecule's structure has not been declared.");
            }
            if (this.molecule.getAtoms().size() >= 100) {
                throw this.e("Molecule has too many Atoms");
            }
            if (this.molecule.nameSpace == "novel" && (equivalentMolecule = this.molecule.getEquivalent()) != this.molecule) {
                return equivalentMolecule;
            }
            if (this.molecule.getMolecularFormula().containsKey((Object)Element.R_GROUP)) {
                this.tag(DestroyMolecules.Tags.HYPOTHETICAL);
            }
            if (!this.hasForcedDensity.booleanValue() && this.molecule.charge != 0) {
                this.molecule.density = MoleculeBuilder.estimateDensity(this.molecule);
            }
            if (!this.hasForcedBoilingPoint.booleanValue()) {
                this.molecule.boilingPoint = MoleculeBuilder.estimateBoilingPoint(this.molecule);
            }
            if (!this.hasForcedDipoleMoment.booleanValue()) {
                this.molecule.dipoleMoment = MoleculeBuilder.estimateDipoleMoment(this.molecule);
            }
            if (!this.hasForcedMolarHeatCapacity.booleanValue()) {
                this.molecule.molarHeatCapacity = 100.0f;
            }
            if (!this.hasForcedLatentHeat.booleanValue()) {
                this.molecule.latentHeat = 20000.0f;
            }
            if (this.molecule.color == 0) {
                this.molecule.color = 0x20FFFFFF;
            }
            this.molecule.refreshFunctionalGroups();
            this.molecule.structure.updateSideChainStructures();
            if (this.molecule.nameSpace != "novel") {
                if (this.molecule.id == null) {
                    throw this.e("Molecule's ID has not been declared.");
                }
                MOLECULES.put(this.molecule.nameSpace + ":" + this.molecule.id, this.molecule);
            }
            return this.molecule;
        }

        private float calculateMass() {
            float total = 0.0f;
            Set<Atom> atoms = this.molecule.structure.getAllAtoms();
            for (Atom atom : atoms) {
                total += atom.getElement().getMass().floatValue();
            }
            return total;
        }

        private static final float estimateDensity(Molecule molecule) {
            return 1000.0f;
        }

        private static float estimateBoilingPoint(Molecule molecule) {
            int hydrogenBondingGroups = 0;
            int carbonyls = 0;
            int halogens = 0;
            int nitriles = 0;
            for (Group<?> group : molecule.getFunctionalGroups()) {
                GroupType<?> type = group.getType();
                if (type == DestroyGroupTypes.ALCOHOL || type == DestroyGroupTypes.NON_TERTIARY_AMINE || type == DestroyGroupTypes.CARBOXYLIC_ACID || type == DestroyGroupTypes.UNSUBSTITUTED_AMIDE) {
                    ++hydrogenBondingGroups;
                }
                if (type == DestroyGroupTypes.CARBONYL || type == DestroyGroupTypes.CARBOXYLIC_ACID || type == DestroyGroupTypes.UNSUBSTITUTED_AMIDE) {
                    ++carbonyls;
                }
                if (type == DestroyGroupTypes.HALIDE) {
                    ++halogens;
                }
                if (type != DestroyGroupTypes.NITRILE) continue;
                ++nitriles;
            }
            return 2.042599f * molecule.getMass() + 34.32621f * (float)hydrogenBondingGroups + 13.089986f * (float)carbonyls - 44.779274f * (float)halogens + 63.981052f * (float)nitriles + 178.17686f;
        }

        private static int estimateDipoleMoment(Molecule molecule) {
            return 0;
        }

        private MoleculeConstructionException e(String message) {
            return new MoleculeConstructionException(this.addInfoToMessage(message));
        }

        private MoleculeConstructionException e(String message, Throwable e) {
            return new MoleculeConstructionException(this.addInfoToMessage(message), e);
        }

        private String addInfoToMessage(String message) {
            String id = this.molecule.id == null ? "Unknown ID" : this.molecule.nameSpace + ":" + this.molecule.id;
            return "Problem building Molecule (" + id + "): " + message;
        }

        public class MoleculeConstructionException
        extends ChemistryException {
            private MoleculeConstructionException(String message) {
                super(message);
            }

            private MoleculeConstructionException(String message, Throwable e) {
                super(message, e);
            }
        }
    }
}

