/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.chemistry;

import com.petrolpark.destroy.chemistry.Molecule;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

public class MoleculeTag {
    private final String nameSpace;
    private final String id;
    private int color;
    public static final Map<String, MoleculeTag> MOLECULE_TAGS = new HashMap<String, MoleculeTag>();
    public static final Map<MoleculeTag, Set<Molecule>> MOLECULES_WITH_TAGS = new HashMap<MoleculeTag, Set<Molecule>>();

    public MoleculeTag(String nameSpace, String id) {
        this.nameSpace = nameSpace;
        this.id = id;
        this.color = 0xFFFFFF;
        MOLECULE_TAGS.put(nameSpace + ":" + id, this);
    }

    public MoleculeTag withColor(int color) {
        this.color = color;
        return this;
    }

    public static void registerMoleculeToTag(Molecule molecule, MoleculeTag moleculeTag) {
        MOLECULES_WITH_TAGS.putIfAbsent(moleculeTag, new HashSet());
        MOLECULES_WITH_TAGS.get(moleculeTag).add(molecule);
    }

    public String getId() {
        return this.nameSpace + ":" + this.id;
    }

    public Component getFormattedName() {
        return Component.m_237115_((String)(this.nameSpace + ".molecule_tag." + this.id)).m_130948_(Style.f_131099_.m_178520_(this.color));
    }
}

