/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.chemistry;

import com.petrolpark.destroy.Destroy;
import com.petrolpark.destroy.chemistry.IItemReactant;
import com.petrolpark.destroy.chemistry.Molecule;
import com.petrolpark.destroy.chemistry.ReactionResult;
import com.petrolpark.destroy.chemistry.error.ChemistryException;
import com.petrolpark.destroy.chemistry.index.DestroyMolecules;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;

public class Reaction {
    public static final Float GAS_CONSTANT = Float.valueOf(8.3145f);
    public static final Map<String, Reaction> REACTIONS = new HashMap<String, Reaction>();
    private Map<Molecule, Integer> reactants;
    private Map<Molecule, Integer> products;
    private Map<Molecule, Integer> orders;
    private List<IItemReactant> itemReactants;
    private float molesPerItem;
    private boolean isCatalysedByUV;
    private ReactionResult result;
    private float preexponentialFactor;
    private float activationEnergy;
    private float enthalpyChange;
    private String nameSpace;
    private String id;
    private boolean includeInJei;
    private boolean displayAsReversible;
    private Reaction reverseReaction;

    public static ReactionBuilder generatedReactionBuilder() {
        return new ReactionBuilder(new Reaction("novel"), true);
    }

    public static Reaction get(String reactionId) {
        return REACTIONS.get(reactionId);
    }

    private Reaction(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    public Boolean containsReactant(Molecule molecule) {
        return this.reactants.keySet().contains(molecule);
    }

    public Boolean containsProduct(Molecule molecule) {
        return this.products.keySet().contains(molecule);
    }

    public Set<Molecule> getReactants() {
        return this.reactants.keySet();
    }

    public boolean consumesItem() {
        for (IItemReactant itemReactant : this.itemReactants) {
            if (itemReactant.isCatalyst()) continue;
            return true;
        }
        return false;
    }

    public List<IItemReactant> getItemReactants() {
        return this.itemReactants;
    }

    public float getMolesPerItem() {
        return this.molesPerItem;
    }

    public boolean needsUV() {
        return this.isCatalysedByUV;
    }

    public Set<Molecule> getProducts() {
        return this.products.keySet();
    }

    public float getActivationEnergy() {
        return this.activationEnergy;
    }

    public float getPreexponentialFactor() {
        return this.preexponentialFactor;
    }

    public float getRateConstant(float temperature) {
        return this.preexponentialFactor * (float)Math.exp(-(this.activationEnergy * 1000.0f / (GAS_CONSTANT.floatValue() * temperature)));
    }

    public float getEnthalpyChange() {
        return this.enthalpyChange;
    }

    public boolean hasResult() {
        return this.result != null;
    }

    public ReactionResult getResult() {
        return this.result;
    }

    public String getId() {
        return this.id;
    }

    public String getFullId() {
        return this.nameSpace + ":" + this.id;
    }

    public boolean includeInJei() {
        return this.includeInJei;
    }

    public boolean displayAsReversible() {
        return this.displayAsReversible;
    }

    public Optional<Reaction> getReverseReactionForDisplay() {
        return Optional.ofNullable(this.reverseReaction);
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public Integer getReactantMolarRatio(Molecule reactant) {
        if (!this.reactants.keySet().contains(reactant)) {
            return 0;
        }
        return this.reactants.get(reactant);
    }

    public Integer getProductMolarRatio(Molecule product) {
        if (!this.products.keySet().contains(product)) {
            return 0;
        }
        return this.products.get(product);
    }

    public Map<Molecule, Integer> getOrders() {
        return this.orders;
    }

    public static class ReactionBuilder {
        private String namespace;
        final boolean generated;
        Reaction reaction;
        private boolean hasForcedPreExponentialFactor;
        private boolean hasForcedActivationEnergy;
        private boolean hasForcedEnthalpyChange;

        private ReactionBuilder(Reaction reaction, boolean generated) {
            this.generated = generated;
            this.reaction = reaction;
            reaction.reactants = new HashMap<Molecule, Integer>();
            reaction.products = new HashMap<Molecule, Integer>();
            reaction.orders = new HashMap<Molecule, Integer>();
            reaction.itemReactants = new ArrayList<IItemReactant>();
            reaction.molesPerItem = 0.0f;
            reaction.includeInJei = !generated;
            reaction.displayAsReversible = false;
            this.hasForcedPreExponentialFactor = false;
            this.hasForcedActivationEnergy = false;
            this.hasForcedEnthalpyChange = false;
        }

        public ReactionBuilder(String namespace) {
            this(new Reaction(namespace), false);
            this.namespace = namespace;
        }

        private void checkNull(Molecule molecule) {
            if (molecule == null) {
                throw this.e("Molecules cannot be null");
            }
        }

        public ReactionBuilder addReactant(Molecule molecule) {
            return this.addReactant(molecule, 1);
        }

        public ReactionBuilder addReactant(Molecule molecule, int ratio) {
            return this.addReactant(molecule, ratio, ratio);
        }

        public ReactionBuilder addReactant(Molecule molecule, int ratio, int order) {
            this.checkNull(molecule);
            this.reaction.reactants.put(molecule, ratio);
            this.reaction.orders.put(molecule, order);
            return this;
        }

        public ReactionBuilder setOrder(Molecule molecule, int order) {
            if (!this.reaction.reactants.keySet().contains(molecule)) {
                throw this.e("Cannot modify order of a Molecule (" + molecule.getFullID() + ") that is not a reactant.");
            }
            this.addCatalyst(molecule, order);
            return this;
        }

        public ReactionBuilder addItemReactant(IItemReactant itemReactant, float moles) {
            if (this.reaction.molesPerItem != 0.0f && this.reaction.molesPerItem != moles) {
                throw this.e("The number of moles of Reaction which occur when all Item Requirements are met is constant for a Reaction, not individual per Item Reactant. The same number must be supplied each time an Item Reactant is added.");
            }
            this.reaction.molesPerItem = moles;
            this.reaction.itemReactants.add(itemReactant);
            return this;
        }

        public ReactionBuilder addSimpleItemReactant(Supplier<Item> item, float moles) {
            return this.addItemReactant(new IItemReactant.SimpleItemReactant(item), moles);
        }

        public ReactionBuilder addSimpleItemTagReactant(TagKey<Item> tag, float moles) {
            return this.addItemReactant(new IItemReactant.SimpleItemTagReactant(tag), moles);
        }

        public ReactionBuilder addSimpleItemCatalyst(Supplier<Item> item, float moles) {
            return this.addItemReactant(new IItemReactant.SimpleItemCatalyst(item), moles);
        }

        public ReactionBuilder addSimpleItemTagCatalyst(TagKey<Item> tag, float moles) {
            return this.addItemReactant(new IItemReactant.SimpleItemTagCatalyst(tag), moles);
        }

        public ReactionBuilder requireUV() {
            this.reaction.isCatalysedByUV = true;
            return this;
        }

        public ReactionBuilder addProduct(Molecule molecule) {
            return this.addProduct(molecule, 1);
        }

        public ReactionBuilder addProduct(Molecule molecule, int ratio) {
            this.checkNull(molecule);
            this.reaction.products.put(molecule, ratio);
            return this;
        }

        public ReactionBuilder addCatalyst(Molecule molecule, int order) {
            this.checkNull(molecule);
            this.reaction.orders.put(molecule, order);
            return this;
        }

        public ReactionBuilder dontIncludeInJei() {
            this.reaction.includeInJei = false;
            return this;
        }

        public ReactionBuilder displayAsReversible() {
            this.reaction.displayAsReversible = true;
            return this;
        }

        public ReactionBuilder id(String id) {
            this.reaction.id = id;
            return this;
        }

        public ReactionBuilder preexponentialFactor(float preexponentialFactor) {
            this.reaction.preexponentialFactor = preexponentialFactor;
            this.hasForcedPreExponentialFactor = true;
            return this;
        }

        public ReactionBuilder activationEnergy(float activationEnergy) {
            this.reaction.activationEnergy = activationEnergy;
            this.hasForcedActivationEnergy = true;
            return this;
        }

        public ReactionBuilder enthalpyChange(float enthalpyChange) {
            this.reaction.enthalpyChange = enthalpyChange;
            this.hasForcedEnthalpyChange = true;
            return this;
        }

        public ReactionBuilder withResult(float moles, BiFunction<Float, Reaction, ReactionResult> reactionresultFactory) {
            if (this.reaction.result != null) {
                throw this.e("Reaction already has a Reaction Result. Use a CombinedReactionResult to have multiple.");
            }
            this.reaction.result = reactionresultFactory.apply(Float.valueOf(moles), this.reaction);
            return this;
        }

        public Reaction acid(Molecule acid, Molecule conjugateBase, float pKa) {
            if (conjugateBase.getCharge() + 1 != acid.getCharge()) {
                throw this.e("Acids must not violate the conservation of charge.");
            }
            Reaction dissociationReaction = this.id(acid.getFullID().split(":")[1] + ".dissociation").addReactant(acid).addCatalyst(DestroyMolecules.WATER, 0).addProduct(DestroyMolecules.PROTON).addProduct(conjugateBase).activationEnergy(GAS_CONSTANT.floatValue() * 0.298f).preexponentialFactor((float)Math.pow(10.0, -pKa)).dontIncludeInJei().build();
            new ReactionBuilder(this.namespace).id(acid.getFullID().split(":")[1] + ".association").addReactant(conjugateBase).addReactant(DestroyMolecules.PROTON).addProduct(acid).activationEnergy(GAS_CONSTANT.floatValue() * 0.298f).preexponentialFactor(1.0f).dontIncludeInJei().build();
            return dissociationReaction;
        }

        public ReactionBuilder reverseReaction(Consumer<ReactionBuilder> reverseReactionModifier) {
            if (this.generated) {
                throw this.e("Generated Reactions cannot be reversible. Add another Generic Reaction instead.");
            }
            this.reaction.displayAsReversible = true;
            ReactionBuilder reverseBuilder = new ReactionBuilder(this.namespace);
            for (Map.Entry<Molecule, Integer> reactant : this.reaction.reactants.entrySet()) {
                reverseBuilder.addProduct(reactant.getKey(), reactant.getValue());
            }
            for (Map.Entry<Molecule, Integer> product : this.reaction.products.entrySet()) {
                reverseBuilder.addReactant(product.getKey(), product.getValue());
            }
            for (Map.Entry<Molecule, Integer> rateAffecter : this.reaction.orders.entrySet()) {
                if (this.reaction.reactants.keySet().contains(rateAffecter.getKey())) continue;
                reverseBuilder.addCatalyst(rateAffecter.getKey(), rateAffecter.getValue());
            }
            this.reaction.reverseReaction = reverseBuilder.reaction;
            reverseBuilder.id(this.reaction.id + ".reverse").dontIncludeInJei();
            if (this.hasForcedEnthalpyChange && this.hasForcedActivationEnergy) {
                reverseBuilder.activationEnergy(this.reaction.activationEnergy - this.reaction.enthalpyChange).enthalpyChange(-this.reaction.enthalpyChange);
            }
            if (this.reaction.needsUV()) {
                reverseBuilder.requireUV();
            }
            reverseReactionModifier.accept(reverseBuilder);
            if (this.reaction.activationEnergy - this.reaction.enthalpyChange != reverseBuilder.reaction.activationEnergy || this.reaction.enthalpyChange != -reverseBuilder.reaction.enthalpyChange) {
                throw this.e("Activation energies and enthalpy changes for reversible Reactions must obey Hess' Law");
            }
            reverseBuilder.build();
            return this;
        }

        public Reaction build() {
            if (this.reaction.id == null && !this.generated) {
                throw this.e("Reaction is missing an ID.");
            }
            if (!this.hasForcedActivationEnergy) {
                this.reaction.activationEnergy = 2.5f;
            }
            if (!this.hasForcedPreExponentialFactor || this.reaction.preexponentialFactor <= 0.0f) {
                this.reaction.preexponentialFactor = 10000.0f;
            }
            if (!this.hasForcedEnthalpyChange) {
                this.reaction.enthalpyChange = 0.0f;
            }
            if (this.reaction.consumesItem() && this.reaction.molesPerItem == 0.0f) {
                Destroy.LOGGER.warn("Reaction '" + this.reactionString() + "' does not do anything when its required Items are consumed.");
            }
            if (!this.generated) {
                for (Molecule reactant : this.reaction.reactants.keySet()) {
                    reactant.addReactantReaction(this.reaction);
                }
                for (Molecule product : this.reaction.products.keySet()) {
                    product.addProductReaction(this.reaction);
                }
                REACTIONS.put(this.reaction.getFullId(), this.reaction);
            }
            return this.reaction;
        }

        private ReactionConstructionException e(String message) {
            String id = this.reaction.id == null ? this.reactionString() : this.reaction.nameSpace + ":" + this.reaction.id;
            return new ReactionConstructionException("Problem generating reation (" + id + "): " + message);
        }

        private String reactionString() {
            Object reactionString = "";
            for (Molecule reactant : this.reaction.reactants.keySet()) {
                reactionString = (String)reactionString + reactant.getSerlializedMolecularFormula(false);
                reactionString = (String)reactionString + " + ";
            }
            reactionString = ((String)reactionString).substring(0, ((String)reactionString).length() - 3) + " => ";
            for (Molecule product : this.reaction.products.keySet()) {
                reactionString = (String)reactionString + product.getSerlializedMolecularFormula(false);
                reactionString = (String)reactionString + " + ";
            }
            reactionString = ((String)reactionString).substring(0, ((String)reactionString).length() - 3);
            return reactionString;
        }

        public class ReactionConstructionException
        extends ChemistryException {
            public ReactionConstructionException(String message) {
                super(message);
            }
        }
    }
}

