/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.chemistry;

import com.petrolpark.destroy.Destroy;
import com.petrolpark.destroy.chemistry.Molecule;
import com.petrolpark.destroy.chemistry.index.DestroyMolecules;
import com.petrolpark.destroy.util.DestroyLang;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;

public class ReadOnlyMixture {
    private static DecimalFormat df = new DecimalFormat();
    public static final float IMPURITY_THRESHOLD = 0.1f;
    protected Component name;
    protected String translationKey = "";
    protected Integer color;
    protected float temperature = 298.0f;
    protected Map<Molecule, Float> contents = new HashMap<Molecule, Float>();
    protected Map<Molecule, Float> states = new HashMap<Molecule, Float>();

    public CompoundTag writeNBT() {
        CompoundTag compound = new CompoundTag();
        if (this.translationKey != "" && this.translationKey != null) {
            compound.m_128359_("TranslationKey", this.translationKey);
        }
        compound.m_128350_("Temperature", this.temperature);
        compound.m_128365_("Contents", (Tag)NBTHelper.writeCompoundList(this.contents.entrySet().stream().filter(e -> ((Float)e.getValue()).floatValue() > 0.0f).toList(), entry -> {
            CompoundTag moleculeTag = new CompoundTag();
            moleculeTag.m_128359_("Molecule", ((Molecule)entry.getKey()).getFullID());
            moleculeTag.m_128350_("Concentration", ((Float)entry.getValue()).floatValue());
            float gaseous = this.states.get(entry.getKey()).floatValue();
            if (gaseous != 1.0f && gaseous != 0.0f) {
                moleculeTag.m_128350_("Gaseous", this.states.get(entry.getKey()).floatValue());
            }
            return moleculeTag;
        }));
        return compound;
    }

    public static <T extends ReadOnlyMixture> T readNBT(Supplier<T> newMixture, CompoundTag compound) {
        ReadOnlyMixture mixture = (ReadOnlyMixture)newMixture.get();
        if (compound == null) {
            Destroy.LOGGER.warn("Null Mixture read");
            return (T)mixture;
        }
        mixture.translationKey = compound.m_128461_("TranslationKey");
        if (compound.m_128441_("Temperature")) {
            mixture.temperature = compound.m_128457_("Temperature");
        }
        ListTag contents = compound.m_128437_("Contents", 10);
        contents.forEach(tag -> {
            CompoundTag moleculeTag = (CompoundTag)tag;
            Molecule molecule = Molecule.getMolecule(moleculeTag.m_128461_("Molecule"));
            mixture.addMolecule(molecule, moleculeTag.m_128457_("Concentration"));
            mixture.states.put(molecule, Float.valueOf(moleculeTag.m_128457_("Gaseous")));
        });
        mixture.updateName();
        mixture.updateColor();
        return (T)mixture;
    }

    public Component getName() {
        if (this.name == null) {
            this.updateName();
        }
        return this.name;
    }

    public int getColor() {
        if (this.color == null) {
            this.updateColor();
        }
        return this.color;
    }

    public void setTranslationKey(String translationKey) {
        this.translationKey = translationKey;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    public float getConcentrationOf(Molecule molecule) {
        if (this.contents.containsKey(molecule)) {
            return this.contents.get(molecule).floatValue();
        }
        return 0.0f;
    }

    public float getTotalConcentration() {
        float total = 0.0f;
        for (Float concentration : this.contents.values()) {
            total += concentration.floatValue();
        }
        return total;
    }

    public boolean hasUsableMolecule(Molecule molecule, float minConcentration, float maxConcentration, @Nullable Predicate<Molecule> ignore) {
        return this.hasUsableMolecules(molecule::equals, minConcentration, maxConcentration, ignore);
    }

    public boolean hasUsableMolecules(Predicate<Molecule> molecules, float minConcentration, float maxConcentration, @Nullable Predicate<Molecule> ignore) {
        if (ignore == null) {
            ignore = m -> false;
        }
        float combinedConcentration = 0.0f;
        for (Map.Entry<Molecule, Float> entry : this.contents.entrySet()) {
            if (ignore.test(entry.getKey())) continue;
            if (molecules.test(entry.getKey())) {
                combinedConcentration += entry.getValue().floatValue();
                continue;
            }
            if (entry.getKey().hasTag(DestroyMolecules.Tags.SOLVENT) || !(entry.getValue().floatValue() > 0.1f)) continue;
            return false;
        }
        return combinedConcentration < maxConcentration + 0.05f && combinedConcentration > minConcentration - 0.05f;
    }

    public ReadOnlyMixture addMolecule(Molecule molecule, float concentration) {
        if (molecule == null || concentration == 0.0f) {
            return this;
        }
        if (molecule.isHypothetical()) {
            Destroy.LOGGER.warn("Could not add hypothetical Molecule '" + molecule.getFullID() + "'' to a real Mixture.");
            return this;
        }
        this.contents.put(molecule, Float.valueOf(concentration));
        this.states.put(molecule, Float.valueOf(molecule.getBoilingPoint() < this.temperature ? 1.0f : 0.0f));
        return this;
    }

    public List<Molecule> getContents(boolean excludeNovel) {
        return this.contents.keySet().stream().filter(molecule -> !molecule.isNovel() || !excludeNovel).toList();
    }

    public String getContentsString() {
        Object string = "";
        if (this.contents.isEmpty()) {
            return string;
        }
        for (Map.Entry<Molecule, Float> entry : this.contents.entrySet()) {
            string = (String)string + entry.getKey().getFullID() + " (" + entry.getValue() + "M), ";
        }
        return ((String)string).substring(0, ((String)string).length() - 2);
    }

    public List<Component> getContentsTooltip(boolean iupac, boolean monospace, boolean useMoles, int amount, DecimalFormat concentrationFormatter) {
        int i = 0;
        ArrayList<Component> tooltip = new ArrayList<Component>();
        ArrayList<Molecule> molecules = new ArrayList<Molecule>(this.contents.keySet());
        Collections.sort(molecules, (m1, m2) -> this.contents.get(m2).compareTo(this.contents.get(m1)));
        Function<Float, String> quantityTranslator = q -> DestroyLang.translate(useMoles ? "tooltip.mixture_contents.moles" : "tooltip.mixture_contents.concentration", concentrationFormatter.format(q)).string();
        int quantityLabelLength = quantityTranslator.apply(Float.valueOf(0.0f)).length() + 2;
        for (Molecule molecule : molecules) {
            float quantity = this.contents.get(molecule).floatValue() * (useMoles ? (float)amount / 1000.0f : 1.0f);
            tooltip.add(i, (Component)DestroyLang.builder().space().space().add(Component.m_237113_((String)(monospace ? String.format("%1$" + quantityLabelLength + "s", quantityTranslator.apply(Float.valueOf(quantity))) : quantityTranslator.apply(Float.valueOf(quantity))))).space().add(molecule.getName(iupac).m_6879_()).add(Component.m_237113_((String)(molecule.getCharge() == 0 ? "" : " [" + molecule.getSerializedCharge(false) + "]"))).style(ChatFormatting.GRAY).component());
            ++i;
        }
        return tooltip;
    }

    protected void updateColor() {
        this.color = 0x20FFFFFF;
    }

    protected void updateName() {
        this.name = DestroyLang.translate("mixture.mixture", new Object[0]).component();
    }

    static {
        df.setMinimumFractionDigits(1);
        df.setMinimumFractionDigits(1);
    }
}

