/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.chemistry.genericreaction;

import com.petrolpark.destroy.chemistry.Atom;
import com.petrolpark.destroy.chemistry.Element;
import com.petrolpark.destroy.chemistry.Formula;
import com.petrolpark.destroy.chemistry.Group;
import com.petrolpark.destroy.chemistry.GroupType;
import com.petrolpark.destroy.chemistry.Molecule;
import com.petrolpark.destroy.chemistry.Reaction;
import com.petrolpark.destroy.chemistry.genericreaction.GenericReactant;
import com.petrolpark.destroy.chemistry.genericreaction.GenericReaction;
import net.minecraft.resources.ResourceLocation;

public abstract class DoubleGroupGenericReaction<FirstGroup extends Group<FirstGroup>, SecondGroup extends Group<SecondGroup>>
extends GenericReaction {
    protected final GroupType<FirstGroup> firstType;
    protected final GroupType<SecondGroup> secondType;
    private int i;

    public DoubleGroupGenericReaction(ResourceLocation id, GroupType<FirstGroup> firstType, GroupType<SecondGroup> secondType) {
        super(id);
        this.firstType = firstType;
        this.secondType = secondType;
        Group.groupTypesAndReactions.get(firstType).add(this);
        Group.groupTypesAndReactions.get(secondType).add(this);
        GENERIC_REACTIONS.add(this);
    }

    public abstract Reaction generateReaction(GenericReactant<FirstGroup> var1, GenericReactant<SecondGroup> var2);

    @Override
    public final boolean involvesSingleGroup() {
        return false;
    }

    public final GroupType<FirstGroup> getFirstGroupType() {
        return this.firstType;
    }

    public final GroupType<SecondGroup> getSecondGroupType() {
        return this.secondType;
    }

    @Override
    public Reaction generateExampleReaction() {
        this.i = 1;
        Molecule exampleMolecule1 = this.copyAndNumberRGroups(this.getFirstGroupType().getExampleMolecule());
        Molecule exampleMolecule2 = this.copyAndNumberRGroups(this.getSecondGroupType().getExampleMolecule());
        GenericReactant reactant1 = null;
        GenericReactant reactant2 = null;
        for (Group<?> group : exampleMolecule1.getFunctionalGroups()) {
            if (group.getType() != this.getFirstGroupType()) continue;
            reactant1 = new GenericReactant(exampleMolecule1, group);
        }
        for (Group<?> group : exampleMolecule2.getFunctionalGroups()) {
            if (group.getType() != this.getSecondGroupType()) continue;
            reactant2 = new GenericReactant(exampleMolecule2, group);
        }
        if (reactant1 == null || reactant2 == null) {
            throw new IllegalStateException("Couldn't generate example Reaction for Generic Reaction " + this.id.toString());
        }
        return this.generateReaction(reactant1, reactant2);
    }

    private Molecule copyAndNumberRGroups(Molecule molecule) {
        Formula copiedStructure = molecule.shallowCopyStructure();
        for (Atom atom : molecule.getAtoms()) {
            if (atom.getElement() != Element.R_GROUP) continue;
            Atom newAtom = new Atom(Element.R_GROUP);
            newAtom.rGroupNumber = this.i++;
            copiedStructure.replace(atom, newAtom);
        }
        return DoubleGroupGenericReaction.moleculeBuilder().structure(copiedStructure).build();
    }
}

