/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.chemistry.genericreaction;

import com.petrolpark.destroy.chemistry.Molecule;
import com.petrolpark.destroy.chemistry.Reaction;
import com.petrolpark.destroy.chemistry.error.ChemistryException;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public abstract class GenericReaction {
    public static Set<GenericReaction> GENERIC_REACTIONS = new HashSet<GenericReaction>();
    public final ResourceLocation id;
    private Reaction exampleReaction;

    public GenericReaction(ResourceLocation id) {
        this.id = id;
    }

    public abstract boolean involvesSingleGroup();

    public Reaction getExampleReaction() {
        if (this.exampleReaction == null) {
            this.exampleReaction = this.generateExampleReaction();
        }
        return this.exampleReaction;
    }

    @NotNull
    protected abstract Reaction generateExampleReaction();

    protected static Molecule.MoleculeBuilder moleculeBuilder() {
        return new Molecule.MoleculeBuilder("novel");
    }

    protected static Reaction.ReactionBuilder reactionBuilder() {
        return Reaction.generatedReactionBuilder();
    }

    protected GenericReactionGenerationException exception(String string) {
        return new GenericReactionGenerationException("Problem generating " + (this.involvesSingleGroup() ? "single" : "double") + "-Group Generic Reaction '" + this.id.toString() + "': " + string);
    }

    public class GenericReactionGenerationException
    extends ChemistryException {
        public GenericReactionGenerationException(String message) {
            super(message);
        }
    }
}

