/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.chemistry.genericreaction;

import com.petrolpark.destroy.Destroy;
import com.petrolpark.destroy.chemistry.Atom;
import com.petrolpark.destroy.chemistry.Element;
import com.petrolpark.destroy.chemistry.Formula;
import com.petrolpark.destroy.chemistry.Group;
import com.petrolpark.destroy.chemistry.GroupType;
import com.petrolpark.destroy.chemistry.Molecule;
import com.petrolpark.destroy.chemistry.Reaction;
import com.petrolpark.destroy.chemistry.genericreaction.GenericReactant;
import com.petrolpark.destroy.chemistry.genericreaction.GenericReaction;
import net.minecraft.resources.ResourceLocation;

public abstract class SingleGroupGenericReaction<G extends Group<G>>
extends GenericReaction {
    protected final GroupType<G> type;

    public SingleGroupGenericReaction(ResourceLocation id, GroupType<G> type) {
        super(id);
        this.type = type;
        Group.groupTypesAndReactions.get(type).add(this);
        GENERIC_REACTIONS.add(this);
    }

    public abstract Reaction generateReaction(GenericReactant<G> var1);

    public final GroupType<G> getGroupType() {
        return this.type;
    }

    @Override
    public final boolean involvesSingleGroup() {
        return true;
    }

    @Override
    public Reaction generateExampleReaction() {
        Molecule exampleMolecule = this.getGroupType().getExampleMolecule();
        int i = 1;
        Formula copiedStructure = exampleMolecule.shallowCopyStructure();
        for (Atom atom : exampleMolecule.getAtoms()) {
            if (atom.getElement() != Element.R_GROUP) continue;
            Atom newAtom = new Atom(Element.R_GROUP);
            newAtom.rGroupNumber = i++;
            copiedStructure.replace(atom, newAtom);
        }
        copiedStructure.refreshFunctionalGroups();
        Molecule copiedExampleMolecule = SingleGroupGenericReaction.moleculeBuilder().structure(copiedStructure).build();
        for (Group<?> group : copiedExampleMolecule.getFunctionalGroups()) {
            if (!group.getType().equals(this.getGroupType())) continue;
            Reaction reaction = this.generateReaction(new GenericReactant(copiedExampleMolecule, group));
            return reaction;
        }
        Destroy.LOGGER.warn("Couldn't generate example Reaction for Generic Reaction " + this.id.toString());
        return null;
    }

    protected static final void collapseWavefunction(Molecule molecule) {
        String fuckShitBollocks = molecule.getFullID();
    }
}

