/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.chemistry.index;

import com.petrolpark.destroy.chemistry.Atom;
import com.petrolpark.destroy.chemistry.Bond;
import com.petrolpark.destroy.chemistry.Element;
import com.petrolpark.destroy.chemistry.Group;
import com.petrolpark.destroy.chemistry.GroupFinder;
import com.petrolpark.destroy.chemistry.index.group.AcidAnhydrideGroup;
import com.petrolpark.destroy.chemistry.index.group.AcylChlorideGroup;
import com.petrolpark.destroy.chemistry.index.group.AlcoholGroup;
import com.petrolpark.destroy.chemistry.index.group.AlkeneGroup;
import com.petrolpark.destroy.chemistry.index.group.CarbonylGroup;
import com.petrolpark.destroy.chemistry.index.group.CarboxylicAcidGroup;
import com.petrolpark.destroy.chemistry.index.group.EsterGroup;
import com.petrolpark.destroy.chemistry.index.group.HalideGroup;
import com.petrolpark.destroy.chemistry.index.group.NitrileGroup;
import com.petrolpark.destroy.chemistry.index.group.NonTertiaryAmineGroup;
import com.petrolpark.destroy.chemistry.index.group.UnsubstitutedAmideGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DestroyGroupFinder
extends GroupFinder {
    @Override
    public List<Group<?>> findGroups(Map<Atom, List<Bond>> structure) {
        ArrayList groups = new ArrayList();
        ArrayList<Object> carbonsToIgnore = new ArrayList<Object>();
        ArrayList<Atom> carbonsToIgnoreForAlkenes = new ArrayList<Atom>();
        for (Atom carbon : structure.keySet()) {
            if (carbon.getElement() != Element.CARBON || carbonsToIgnore.contains(carbon)) continue;
            List<Atom> carbonylOxygens = DestroyGroupFinder.bondedAtomsOfElementTo(structure, carbon, Element.OXYGEN, Bond.BondType.DOUBLE);
            List<Atom> singleBondOxygens = DestroyGroupFinder.bondedAtomsOfElementTo(structure, carbon, Element.OXYGEN, Bond.BondType.SINGLE);
            List<Atom> chlorines = DestroyGroupFinder.bondedAtomsOfElementTo(structure, carbon, Element.CHLORINE, Bond.BondType.SINGLE);
            ArrayList<Atom> halogens = new ArrayList<Atom>(chlorines);
            halogens.addAll(DestroyGroupFinder.bondedAtomsOfElementTo(structure, carbon, Element.IODINE, Bond.BondType.SINGLE));
            List<Atom> nitrogens = DestroyGroupFinder.bondedAtomsOfElementTo(structure, carbon, Element.NITROGEN, Bond.BondType.SINGLE);
            List<Atom> hydrogens = DestroyGroupFinder.bondedAtomsOfElementTo(structure, carbon, Element.HYDROGEN, Bond.BondType.SINGLE);
            List<Atom> carbons = DestroyGroupFinder.bondedAtomsOfElementTo(structure, carbon, Element.CARBON, Bond.BondType.SINGLE);
            List<Atom> alkeneCarbons = DestroyGroupFinder.bondedAtomsOfElementTo(structure, carbon, Element.CARBON, Bond.BondType.DOUBLE);
            List<Atom> nitrileNitrogens = DestroyGroupFinder.bondedAtomsOfElementTo(structure, carbon, Element.NITROGEN, Bond.BondType.TRIPLE);
            List<Atom> rGroups = DestroyGroupFinder.bondedAtomsOfElementTo(structure, carbon, Element.R_GROUP);
            if (carbonylOxygens.size() == 1) {
                Atom carbonylOxygen = carbonylOxygens.get(0);
                if (singleBondOxygens.size() == 1) {
                    Atom alcoholOxygen = singleBondOxygens.get(0);
                    if (DestroyGroupFinder.bondedAtomsOfElementTo(structure, alcoholOxygen, Element.CARBON, Bond.BondType.SINGLE).size() == 2) {
                        Atom otherCarbon = this.getCarbonBondedToOxygenWhichIsntThisCarbonInThisStructure(alcoholOxygen, carbon, structure);
                        if (DestroyGroupFinder.bondedAtomsOfElementTo(structure, otherCarbon, Element.OXYGEN, Bond.BondType.DOUBLE).size() == 1) {
                            groups.add(new AcidAnhydrideGroup(carbon, carbonylOxygen, otherCarbon, DestroyGroupFinder.bondedAtomsOfElementTo(structure, otherCarbon, Element.OXYGEN, Bond.BondType.DOUBLE).get(0), alcoholOxygen));
                        } else {
                            groups.add(new EsterGroup(carbon, otherCarbon, carbonylOxygen, alcoholOxygen));
                        }
                        carbonsToIgnore.add(otherCarbon);
                        continue;
                    }
                    if (DestroyGroupFinder.bondedAtomsOfElementTo(structure, alcoholOxygen, Element.HYDROGEN, Bond.BondType.SINGLE).size() == 1) {
                        groups.add(new CarboxylicAcidGroup(carbon, carbonylOxygen, alcoholOxygen, DestroyGroupFinder.bondedAtomsOfElementTo(structure, alcoholOxygen, Element.HYDROGEN, Bond.BondType.SINGLE).get(0)));
                        continue;
                    }
                } else if (nitrogens.size() == 1) {
                    List<Atom> amideHydrogens = DestroyGroupFinder.bondedAtomsOfElementTo(structure, nitrogens.get(0), Element.HYDROGEN);
                    if (amideHydrogens.size() == 2) {
                        groups.add(new UnsubstitutedAmideGroup(carbon, carbonylOxygen, nitrogens.get(0), amideHydrogens.get(0), amideHydrogens.get(1)));
                        continue;
                    }
                } else {
                    if (chlorines.size() == 1) {
                        groups.add(new AcylChlorideGroup(carbon, carbonylOxygen, chlorines.get(0)));
                        continue;
                    }
                    if (carbons.size() == 2) {
                        groups.add(new CarbonylGroup(carbon, carbonylOxygen, true));
                    } else if (carbons.size() + hydrogens.size() + rGroups.size() == 2) {
                        groups.add(new CarbonylGroup(carbon, carbonylOxygen, false));
                    }
                }
            } else {
                for (Atom halogen : halogens) {
                    groups.add(new HalideGroup(carbon, halogen, carbons.size()));
                }
                for (Atom oxygen : singleBondOxygens) {
                    if (DestroyGroupFinder.bondedAtomsOfElementTo(structure, oxygen, Element.HYDROGEN).size() != 1) continue;
                    groups.add(new AlcoholGroup(carbon, oxygen, DestroyGroupFinder.bondedAtomsOfElementTo(structure, oxygen, Element.HYDROGEN).get(0), carbons.size()));
                }
                for (Atom nitrogen : nitrogens) {
                    for (Atom hydrogen : DestroyGroupFinder.bondedAtomsOfElementTo(structure, nitrogen, Element.HYDROGEN)) {
                        groups.add(new NonTertiaryAmineGroup(carbon, nitrogen, hydrogen));
                    }
                }
                if (nitrileNitrogens.size() == 1 && carbons.size() == 1) {
                    groups.add(new NitrileGroup(carbon, nitrileNitrogens.get(0)));
                }
            }
            for (Atom alkeneCarbon : alkeneCarbons) {
                int secondCarbonDegree;
                if (carbonsToIgnoreForAlkenes.contains(alkeneCarbon)) continue;
                int firstCarbonDegree = DestroyGroupFinder.bondedAtomsOfElementTo(structure, carbon, Element.CARBON).size() - 1;
                if (firstCarbonDegree >= (secondCarbonDegree = DestroyGroupFinder.bondedAtomsOfElementTo(structure, alkeneCarbon, Element.CARBON).size() - 1)) {
                    groups.add(new AlkeneGroup(carbon, alkeneCarbon));
                }
                if (secondCarbonDegree >= firstCarbonDegree) {
                    groups.add(new AlkeneGroup(alkeneCarbon, carbon));
                }
                carbonsToIgnoreForAlkenes.add(carbon);
            }
        }
        return groups;
    }

    private Atom getCarbonBondedToOxygenWhichIsntThisCarbonInThisStructure(Atom oxygen, Atom carbon, Map<Atom, List<Bond>> structure) {
        List<Atom> carbonsBondedToOxygen = DestroyGroupFinder.bondedAtomsOfElementTo(structure, oxygen, Element.CARBON);
        carbonsBondedToOxygen.remove(carbon);
        return carbonsBondedToOxygen.get(0);
    }

    public static void register() {
        new DestroyGroupFinder();
    }
}

