/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.chemistry.index.genericreaction;

import com.petrolpark.destroy.chemistry.Bond;
import com.petrolpark.destroy.chemistry.Formula;
import com.petrolpark.destroy.chemistry.Molecule;
import com.petrolpark.destroy.chemistry.Reaction;
import com.petrolpark.destroy.chemistry.genericreaction.GenericReactant;
import com.petrolpark.destroy.chemistry.genericreaction.SingleGroupGenericReaction;
import com.petrolpark.destroy.chemistry.index.DestroyGroupTypes;
import com.petrolpark.destroy.chemistry.index.group.AlkeneGroup;
import net.minecraft.resources.ResourceLocation;

public abstract class AlkeneAddition
extends SingleGroupGenericReaction<AlkeneGroup> {
    public AlkeneAddition(ResourceLocation id) {
        super(id, DestroyGroupTypes.ALKENE);
    }

    @Override
    public Reaction generateReaction(GenericReactant<AlkeneGroup> reactant) {
        AlkeneGroup alkeneGroup = reactant.getGroup();
        Molecule alkene = reactant.getMolecule();
        Molecule product = AlkeneAddition.moleculeBuilder().structure(alkene.shallowCopyStructure().moveTo(alkeneGroup.highDegreeCarbon).replaceBondTo(alkeneGroup.lowDegreeCarbon, Bond.BondType.SINGLE).addGroup(this.getHighDegreeGroup(), true).moveTo(alkeneGroup.lowDegreeCarbon).addGroup(this.getLowDegreeGroup(), true)).build();
        Reaction.ReactionBuilder builder = AlkeneAddition.reactionBuilder().addReactant(alkene).addProduct(product);
        this.transform(builder);
        return builder.build();
    }

    public abstract Formula getLowDegreeGroup();

    public abstract Formula getHighDegreeGroup();

    public abstract void transform(Reaction.ReactionBuilder var1);
}

