/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.chemistry.index.genericreaction;

import com.petrolpark.destroy.chemistry.Atom;
import com.petrolpark.destroy.chemistry.Formula;
import com.petrolpark.destroy.chemistry.Molecule;
import com.petrolpark.destroy.chemistry.Reaction;
import com.petrolpark.destroy.chemistry.genericreaction.GenericReactant;
import com.petrolpark.destroy.chemistry.genericreaction.GenericReaction;
import com.petrolpark.destroy.chemistry.genericreaction.SingleGroupGenericReaction;
import com.petrolpark.destroy.chemistry.index.DestroyGroupTypes;
import com.petrolpark.destroy.chemistry.index.DestroyMolecules;
import com.petrolpark.destroy.chemistry.index.group.HalideGroup;
import net.minecraft.resources.ResourceLocation;

public abstract class HalideSubstitution
extends SingleGroupGenericReaction<HalideGroup> {
    public HalideSubstitution(ResourceLocation id) {
        super(id, DestroyGroupTypes.HALIDE);
    }

    @Override
    public Reaction generateReaction(GenericReactant<HalideGroup> reactant) {
        Molecule reactantMolecule = reactant.getMolecule();
        HalideGroup halideGroup = reactant.getGroup();
        Molecule productMolecule = HalideSubstitution.moleculeBuilder().structure(reactantMolecule.shallowCopyStructure().moveTo(halideGroup.carbon).addGroup(this.getSubstitutedGroup(), true).remove(halideGroup.halogen)).build();
        Reaction.ReactionBuilder builder = HalideSubstitution.reactionBuilder().addReactant(reactantMolecule).addProduct(productMolecule).addProduct(this.getIon(halideGroup.halogen));
        this.transform(builder, halideGroup);
        return builder.build();
    }

    public abstract Formula getSubstitutedGroup();

    public abstract void transform(Reaction.ReactionBuilder var1, HalideGroup var2);

    public Molecule getIon(Atom atom) {
        switch (atom.getElement()) {
            case FLUORINE: {
                return DestroyMolecules.FLUORIDE;
            }
            case CHLORINE: {
                return DestroyMolecules.CHLORIDE;
            }
            case IODINE: {
                return DestroyMolecules.IODIDE;
            }
        }
        throw new GenericReaction.GenericReactionGenerationException(atom.getElement().toString() + " is not a halogen.");
    }
}

