/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.chemistry.index.genericreaction;

import com.petrolpark.destroy.Destroy;
import com.petrolpark.destroy.chemistry.Element;
import com.petrolpark.destroy.chemistry.Formula;
import com.petrolpark.destroy.chemistry.Reaction;
import com.petrolpark.destroy.chemistry.genericreaction.GenericReactant;
import com.petrolpark.destroy.chemistry.genericreaction.SingleGroupGenericReaction;
import com.petrolpark.destroy.chemistry.index.DestroyGroupTypes;
import com.petrolpark.destroy.chemistry.index.DestroyMolecules;
import com.petrolpark.destroy.chemistry.index.group.NitrileGroup;
import com.simibubi.create.AllTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;

public class NitrileHydrogenation
extends SingleGroupGenericReaction<NitrileGroup> {
    public NitrileHydrogenation() {
        super(Destroy.asResource("nitrile_hydrogenation"), DestroyGroupTypes.NITRILE);
    }

    @Override
    public Reaction generateReaction(GenericReactant<NitrileGroup> reactant) {
        NitrileGroup group = reactant.getGroup();
        Formula structure = reactant.getMolecule().shallowCopyStructure();
        structure.moveTo(group.carbon).remove(group.nitrogen).addAtom(Element.HYDROGEN).addAtom(Element.HYDROGEN).addGroup(Formula.atom(Element.NITROGEN).addAtom(Element.HYDROGEN).addAtom(Element.HYDROGEN));
        return NitrileHydrogenation.reactionBuilder().addReactant(reactant.getMolecule()).addReactant(DestroyMolecules.HYDROGEN, 2).addSimpleItemTagCatalyst((TagKey<Item>)AllTags.forgeItemTag((String)"dusts/nickel"), 1.0f).addProduct(NitrileHydrogenation.moleculeBuilder().structure(structure).build()).build();
    }
}

