/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.chemistry.naming;

import com.petrolpark.destroy.chemistry.Molecule;
import com.petrolpark.destroy.chemistry.naming.INameableProduct;
import com.petrolpark.destroy.chemistry.naming.SaltNameOverrides;
import com.petrolpark.destroy.util.DestroyLang;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NamedSalt
implements INameableProduct {
    public final Molecule cation;
    public final Molecule anion;

    public NamedSalt(Molecule cation, Molecule anion) {
        this.cation = cation;
        this.anion = anion;
    }

    @Override
    public Component getName(boolean iupac) {
        Component anionName;
        Component cationName;
        Object genericOverrideKey;
        SaltNameOverrides cationOverrides = SaltNameOverrides.ALL_OVERRIDES.get(this.cation);
        SaltNameOverrides anionOverrides = SaltNameOverrides.ALL_OVERRIDES.get(this.anion);
        if (cationOverrides != null) {
            Object cationKey = this.cation.getTranslationKey(iupac);
            Object withAnionKey = cationOverrides.specificOverrideKeys.get(this.anion);
            if (withAnionKey != null) {
                if (iupac) {
                    withAnionKey = (String)withAnionKey + ".iupac";
                }
                if (I18n.m_118936_((String)withAnionKey)) {
                    return Component.m_237115_((String)withAnionKey);
                }
            }
            if ((genericOverrideKey = cationOverrides.genericOverrideKey) != null) {
                if (iupac) {
                    genericOverrideKey = (String)genericOverrideKey + ".iupac";
                }
                if (I18n.m_118936_((String)genericOverrideKey)) {
                    cationKey = genericOverrideKey;
                }
            }
            cationName = Component.m_237115_((String)cationKey);
        } else {
            cationName = this.cation.getName(iupac);
        }
        if (anionOverrides != null) {
            Object anionKey = this.cation.getTranslationKey(iupac);
            Object withCationKey = anionOverrides.specificOverrideKeys.get(this.cation);
            if (withCationKey != null) {
                if (iupac) {
                    withCationKey = (String)withCationKey + ".iupac";
                }
                if (I18n.m_118936_((String)withCationKey)) {
                    return Component.m_237115_((String)withCationKey);
                }
            }
            if ((genericOverrideKey = anionOverrides.genericOverrideKey) != null) {
                if (iupac) {
                    genericOverrideKey = (String)genericOverrideKey + ".iupac";
                }
                if (I18n.m_118936_((String)genericOverrideKey)) {
                    anionKey = genericOverrideKey;
                }
            }
            anionName = Component.m_237115_((String)anionKey);
        } else {
            anionName = this.anion.getName(iupac);
        }
        return DestroyLang.translate("mixture.simple_salt", cationName, anionName).component();
    }
}

