/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.chemistry.naming;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.petrolpark.destroy.Destroy;
import com.petrolpark.destroy.chemistry.Molecule;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;

public class SaltNameOverrides {
    public static final Map<Molecule, SaltNameOverrides> ALL_OVERRIDES = new HashMap<Molecule, SaltNameOverrides>();
    public static final Manager MANAGER = new Manager();
    @Nullable
    public String genericOverrideKey;
    public Map<Molecule, String> specificOverrideKeys = new HashMap<Molecule, String>();
    private static final Gson GSON = new Gson();

    public static void loadOverridesFromJson(InputStream inputStream) {
        try {
            JsonObject jsonObject = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8), JsonObject.class);
            jsonObject.entrySet().forEach(moleculeEntry -> {
                JsonObject overridesObject;
                String moleculeId = (String)moleculeEntry.getKey();
                Molecule molecule = Molecule.getMolecule(moleculeId);
                if (molecule == null) {
                    throw new IllegalStateException("Unknown molecule in overrides: " + moleculeId);
                }
                SaltNameOverrides overrides = ALL_OVERRIDES.get(molecule);
                if (overrides == null) {
                    overrides = new SaltNameOverrides();
                }
                if ((overridesObject = ((JsonElement)moleculeEntry.getValue()).getAsJsonObject()).has("generic")) {
                    overrides.genericOverrideKey = overridesObject.get("generic").getAsString();
                }
                if (overridesObject.has("specifics")) {
                    JsonObject specificsObject = overridesObject.getAsJsonObject("specifics");
                    for (Map.Entry overrideEntry : specificsObject.entrySet()) {
                        String partnerId = (String)overrideEntry.getKey();
                        Molecule partner = Molecule.getMolecule(partnerId);
                        if (partner == null) {
                            throw new IllegalStateException("Unknown molecule in overrides of " + moleculeId + ": " + partnerId);
                        }
                        overrides.specificOverrideKeys.put(partner, ((JsonElement)overrideEntry.getValue()).getAsString());
                    }
                }
                ALL_OVERRIDES.put(molecule, overrides);
            });
        }
        catch (Throwable e) {
            Destroy.LOGGER.error("Error loading salt name overrides.", e);
        }
    }

    public static void loadOverrideFiles(ResourceManager resourceManager) {
        Minecraft minecraft = Minecraft.m_91087_();
        ALL_OVERRIDES.clear();
        for (String namespace : resourceManager.m_7187_()) {
            ResourceLocation location = new ResourceLocation(namespace, "lang/salt_name_overrides/" + minecraft.m_91102_().m_264236_() + ".json");
            Optional resource = resourceManager.m_213713_(location);
            if (!resource.isPresent()) continue;
            try {
                InputStream inputStream = ((Resource)resource.get()).m_215507_();
                try {
                    SaltNameOverrides.loadOverridesFromJson(inputStream);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException e) {
                Destroy.LOGGER.error("Failed to read salt name overrides: " + location, (Throwable)e);
            }
        }
    }

    public static class Manager
    implements ResourceManagerReloadListener {
        public void m_6213_(ResourceManager resourceManager) {
            SaltNameOverrides.loadOverrideFiles(resourceManager);
        }
    }
}

