/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.chemistry.reactionresult;

import com.petrolpark.destroy.block.entity.VatControllerBlockEntity;
import com.petrolpark.destroy.chemistry.Reaction;
import com.petrolpark.destroy.chemistry.ReactionResult;
import com.petrolpark.destroy.util.ExplosionHelper;
import com.petrolpark.destroy.world.explosion.SmartExplosion;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.function.BiFunction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ExplosionReactionResult
extends ReactionResult {
    protected final BiFunction<Level, Vec3, SmartExplosion> explosionFactory;

    public static ExplosionReactionResult small(Float moles, Reaction reaction) {
        return new ExplosionReactionResult(moles.floatValue(), reaction, (level, pos) -> new SmartExplosion((Level)level, null, null, null, (Vec3)pos, 2.0f, 0.5f));
    }

    public ExplosionReactionResult(float moles, Reaction reaction, BiFunction<Level, Vec3, SmartExplosion> explosionFactory) {
        super(moles, reaction);
        this.explosionFactory = explosionFactory;
    }

    @Override
    public void onBasinReaction(Level level, BasinBlockEntity basin) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ExplosionHelper.explode(serverLevel, this.explosionFactory.apply((Level)serverLevel, VecHelper.getCenterOf((Vec3i)basin.m_58899_())));
        }
    }

    @Override
    public void onVatReaction(Level level, VatControllerBlockEntity vatController) {
        vatController.explode(this.explosionFactory);
    }
}

