/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.chemistry.serializer;

import com.petrolpark.destroy.chemistry.Atom;
import com.petrolpark.destroy.chemistry.Bond;
import com.petrolpark.destroy.chemistry.Element;
import com.petrolpark.destroy.chemistry.serializer.Edge;
import com.petrolpark.destroy.chemistry.serializer.Node;
import java.util.ArrayList;
import java.util.List;

public class Branch {
    private List<Node> nodes = new ArrayList<Node>();
    private Node startNode;
    private Node endNode;

    public Branch(Node node) {
        this.nodes.add(node);
        this.startNode = node;
        this.endNode = node;
    }

    public String serialize() {
        return this.startNode.serialize();
    }

    public Node getStartNode() {
        return this.startNode;
    }

    public Node getEndNode() {
        return this.endNode;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public Branch add(Node node, Bond.BondType bondType) {
        this.nodes.add(node);
        Edge newEdge = new Edge(this.endNode, node, bondType);
        this.endNode.addEdge(newEdge);
        node.addEdge(newEdge);
        node.setBranch(this);
        node.visited = true;
        this.endNode = node;
        return this;
    }

    public Branch add(Branch branchToAdd, Bond.BondType bondType) {
        Edge newEdge = new Edge(this.endNode, branchToAdd.getStartNode(), bondType);
        this.nodes.addAll(branchToAdd.getNodes());
        for (Node node : branchToAdd.getNodes()) {
            node.setBranch(this);
        }
        branchToAdd.getStartNode().addEdge(newEdge);
        this.endNode.addEdge(newEdge);
        this.endNode = branchToAdd.endNode;
        return this;
    }

    public Branch flip() {
        for (Node node : this.nodes) {
            for (Edge edge : node.getEdges()) {
                if (edge.marked.booleanValue()) continue;
                edge.flip();
                edge.marked = true;
            }
        }
        for (Node node : this.nodes) {
            for (Edge edge : node.getEdges()) {
                edge.marked = false;
            }
        }
        Node temp = this.startNode;
        this.startNode = this.endNode;
        this.endNode = temp;
        return this;
    }

    public Float getMass() {
        float total = 0.0f;
        for (Node node : this.nodes) {
            total += Branch.getMassForComparisonInSerialization(node.getAtom()).floatValue();
            for (Branch branch : node.getSideBranches().keySet()) {
                total += branch.getMass().floatValue();
            }
        }
        return Float.valueOf(total);
    }

    public Float getMassOfLongestChain() {
        float total = 0.0f;
        for (Node node : this.nodes) {
            total += Branch.getMassForComparisonInSerialization(node.getAtom()).floatValue();
        }
        return Float.valueOf(total);
    }

    public static Float getMassForComparisonInSerialization(Atom atom) {
        return Float.valueOf(atom.getElement().getMass().floatValue() * (float)(atom.getElement() == Element.R_GROUP ? atom.rGroupNumber : 1));
    }
}

