/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.chemistry.serializer;

import com.petrolpark.destroy.chemistry.Atom;
import com.petrolpark.destroy.chemistry.Bond;
import com.petrolpark.destroy.chemistry.Element;
import com.petrolpark.destroy.chemistry.serializer.Branch;
import com.petrolpark.destroy.chemistry.serializer.Edge;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Node {
    private Atom atom;
    public Boolean visited;
    private List<Edge> edges;
    private Branch branch;
    private Map<Branch, Bond.BondType> sideBranches;

    public Node(Atom atom) {
        this.atom = atom;
        this.visited = false;
        this.edges = new ArrayList<Edge>();
        this.sideBranches = new HashMap<Branch, Bond.BondType>();
    }

    public String serialize() {
        Object string = this.getAtom().getElement().getSymbol();
        Boolean isTerminal = true;
        Edge nextEdge = null;
        for (Edge edge : this.edges) {
            if (edge.getSourceNode() != this) continue;
            isTerminal = false;
            nextEdge = edge;
            break;
        }
        if (this.atom.rGroupNumber != 0 && this.atom.getElement() == Element.R_GROUP) {
            string = (String)string + this.atom.rGroupNumber;
        }
        if (!isTerminal.booleanValue() && nextEdge != null) {
            string = (String)string + nextEdge.bondType.getFROWNSCode();
        }
        for (Map.Entry entry : this.getSideBranches().entrySet()) {
            string = (String)string + "(" + ((Bond.BondType)((Object)entry.getValue())).getFROWNSCode() + ((Branch)entry.getKey()).serialize() + ")";
        }
        if (!isTerminal.booleanValue() && nextEdge != null) {
            string = (String)string + nextEdge.getDestinationNode().serialize();
        }
        return string;
    }

    public Atom getAtom() {
        return this.atom;
    }

    public Node addEdge(Edge edge) {
        this.edges.add(edge);
        return this;
    }

    public Node deleteEdge(Edge edge) {
        this.edges.remove(edge);
        return this;
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public Node setBranch(Branch branch) {
        this.branch = branch;
        return this;
    }

    public Branch getBranch() {
        return this.branch;
    }

    public Node addSideBranch(Branch branch, Bond.BondType bondType) {
        this.sideBranches.put(branch, bondType);
        return this;
    }

    public Map<Branch, Bond.BondType> getSideBranches() {
        return this.sideBranches;
    }

    public List<Map.Entry<Branch, Bond.BondType>> getOrderedSideBranches() {
        ArrayList<Map.Entry<Branch, Bond.BondType>> sideBranchesAndBondTypes = new ArrayList<Map.Entry<Branch, Bond.BondType>>(this.getSideBranches().entrySet());
        Collections.sort(sideBranchesAndBondTypes, (entry1, entry2) -> ((Branch)entry1.getKey()).getMassOfLongestChain().compareTo(((Branch)entry2.getKey()).getMassOfLongestChain()));
        return sideBranchesAndBondTypes;
    }
}

