/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.petrolpark.destroy.Destroy;
import com.petrolpark.destroy.util.RedstoneProgram;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.utility.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

public class DestroyIcons
extends AllIcons {
    public static final ResourceLocation DESTROY_ICON_ATLAS = Destroy.asResource("textures/gui/icons.png");
    public static final int DESTROY_ICON_ATLAS_SIZE = 256;
    protected final int iconX;
    protected final int iconY;
    public static final DestroyIcons RADIOACTIVITY = new DestroyIcons(0, 0);
    public static final DestroyIcons ACID_RAIN = new DestroyIcons(1, 0);
    public static final DestroyIcons OZONE_DEPLETION = new DestroyIcons(2, 0);
    public static final DestroyIcons GREENHOUSE = new DestroyIcons(3, 0);
    public static final DestroyIcons SMOG = new DestroyIcons(4, 0);
    public static final DestroyIcons QUESTION_MARK = new DestroyIcons(0, 1);
    public static final DestroyIcons VAT_SOLUTION = new DestroyIcons(0, 3);
    public static final DestroyIcons VAT_GAS = new DestroyIcons(1, 3);
    public static final DestroyIcons VAT_ALL = new DestroyIcons(2, 3);
    private static final DestroyIcons[] redstoneProgrammerModeIcons = new DestroyIcons[RedstoneProgram.PlayMode.values().length];

    public static DestroyIcons get(RedstoneProgram.PlayMode mode) {
        return redstoneProgrammerModeIcons[mode.ordinal()];
    }

    public DestroyIcons(int x, int y) {
        super(x, y);
        this.iconX = x * 16;
        this.iconY = y * 16;
    }

    public void bind() {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)DESTROY_ICON_ATLAS);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics graphics, int x, int y) {
        graphics.m_280398_(DESTROY_ICON_ATLAS, x, y, 0, (float)this.iconX, (float)this.iconY, 16, 16, 256, 256);
    }

    public void render(PoseStack ms, MultiBufferSource buffer, int color) {
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110497_((ResourceLocation)DESTROY_ICON_ATLAS));
        Matrix4f matrix = ms.m_85850_().m_252922_();
        Color rgb = new Color(color);
        int light = 0xF000F0;
        float u1 = (float)this.iconX * 1.0f / 256.0f;
        float u2 = (float)(this.iconX + 16) * 1.0f / 256.0f;
        float v1 = (float)this.iconY * 1.0f / 256.0f;
        float v2 = (float)(this.iconY + 16) * 1.0f / 256.0f;
        this.vertex(builder, matrix, new Vec3(0.0, 0.0, 0.0), rgb, u1, v1, light);
        this.vertex(builder, matrix, new Vec3(0.0, 1.0, 0.0), rgb, u1, v2, light);
        this.vertex(builder, matrix, new Vec3(1.0, 1.0, 0.0), rgb, u2, v2, light);
        this.vertex(builder, matrix, new Vec3(1.0, 0.0, 0.0), rgb, u2, v1, light);
    }

    private void vertex(VertexConsumer builder, Matrix4f matrix, Vec3 vec, Color rgb, float u, float v, int light) {
        builder.m_252986_(matrix, (float)vec.f_82479_, (float)vec.f_82480_, (float)vec.f_82481_).m_6122_(rgb.getRed(), rgb.getGreen(), rgb.getBlue(), 255).m_7421_(u, v).m_85969_(light).m_5752_();
    }

    static {
        for (int i = 0; i < redstoneProgrammerModeIcons.length; ++i) {
            DestroyIcons.redstoneProgrammerModeIcons[i] = new DestroyIcons(i, 2);
        }
    }
}

