/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.client.gui;

import com.google.common.collect.ImmutableList;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.petrolpark.destroy.chemistry.Atom;
import com.petrolpark.destroy.chemistry.Bond;
import com.petrolpark.destroy.chemistry.Formula;
import com.petrolpark.destroy.chemistry.Molecule;
import com.petrolpark.destroy.chemistry.serializer.Branch;
import com.petrolpark.destroy.chemistry.serializer.Edge;
import com.petrolpark.destroy.chemistry.serializer.Node;
import com.petrolpark.destroy.util.MathsHelper;
import com.simibubi.create.foundation.gui.ILightingSettings;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class MoleculeRenderer {
    protected String moleculeID;
    protected int width;
    protected int height;
    protected int xOffset;
    protected int yOffset;
    protected int zOffset;
    protected static final double SCALE = 23.0;
    protected static final double BOND_LENGTH = 11.5;
    List<Pair<Vec3, IRenderableMoleculePart>> RENDERED_OBJECTS;

    public MoleculeRenderer(Molecule molecule) {
        this.moleculeID = molecule.getFullID();
        this.width = 0;
        this.height = 0;
        this.xOffset = 5;
        this.yOffset = 0;
        this.zOffset = 0;
        this.RENDERED_OBJECTS = new ArrayList<Pair<Vec3, IRenderableMoleculePart>>();
        if (molecule.getAtoms().size() == 1) {
            this.RENDERED_OBJECTS.add((Pair<Vec3, IRenderableMoleculePart>)Pair.of((Object)Vec3.f_82478_, (Object)new AtomRenderInstance(molecule.getAtoms().iterator().next())));
        } else if (molecule.isCyclic()) {
            HashMap cyclicAtomsAndLocations = new HashMap();
            molecule.getCyclicAtomsForRendering().forEach(pair -> {
                cyclicAtomsAndLocations.put((Atom)pair.getSecond(), (Vec3)pair.getFirst());
                this.RENDERED_OBJECTS.add((Pair<Vec3, IRenderableMoleculePart>)Pair.of((Object)((Vec3)pair.getFirst()).m_82490_(11.5), (Object)new AtomRenderInstance((Atom)pair.getSecond())));
            });
            molecule.getCyclicBondsForRendering().forEach(bond -> {
                Vec3 sourceAtomLocation = (Vec3)cyclicAtomsAndLocations.get(bond.getSourceAtom());
                Vec3 zig = ((Vec3)cyclicAtomsAndLocations.get(bond.getDestinationAtom())).m_82546_(sourceAtomLocation).m_82541_();
                this.RENDERED_OBJECTS.add((Pair<Vec3, IRenderableMoleculePart>)Pair.of((Object)sourceAtomLocation.m_82490_(11.5).m_82549_(zig.m_82490_(5.75)), (Object)BondRenderInstance.fromZig(bond.getType(), zig)));
            });
            molecule.getSideChainsForRendering().forEach(pair -> {
                Formula.Topology.SideChainInformation sideChainInfo = (Formula.Topology.SideChainInformation)pair.getFirst();
                Vec3 zig = sideChainInfo.bondDirection();
                Vec3 cyclicAtomLocation = ((Vec3)cyclicAtomsAndLocations.get(sideChainInfo.atom())).m_82490_(11.5);
                Vec3 startLocation = cyclicAtomLocation.m_82549_(zig.m_82490_(11.5));
                Vec3 startDirection = sideChainInfo.branchDirection();
                Vec3 startPlane = sideChainInfo.bondDirection().m_82537_(sideChainInfo.branchDirection());
                this.RENDERED_OBJECTS.add((Pair<Vec3, IRenderableMoleculePart>)Pair.of((Object)cyclicAtomLocation.m_82549_(zig.m_82490_(5.75)), (Object)BondRenderInstance.fromZig(sideChainInfo.bondType(), zig)));
                this.generateBranch((Branch)pair.getSecond(), startLocation, startDirection, startPlane, zig, true);
            });
        } else {
            Vec3 startLocation = new Vec3(0.0, 0.0, 0.0);
            Vec3 startDirection = new Vec3(1.0, 0.0, -1.0).m_82541_();
            Vec3 startPlane = new Vec3(1.0, 0.0, 1.0).m_82541_();
            this.generateBranch(molecule.getRenderBranch(), startLocation, startDirection, startPlane, MathsHelper.rotate(startDirection, startPlane, 180.0 + this.getGeometry(molecule.getRenderBranch().getNodes().get(1), false).getAngle() * 0.5), false);
        }
        Collections.sort(this.RENDERED_OBJECTS, (pair1, pair2) -> Double.compare(((Vec3)pair1.getFirst()).f_82481_, ((Vec3)pair2.getFirst()).f_82481_));
        for (Pair<Vec3, IRenderableMoleculePart> pair3 : this.RENDERED_OBJECTS) {
            this.width = Math.max((int)this.width, (int)((int)((Vec3)pair3.getFirst()).f_82479_));
            this.height = Math.max((int)this.height, (int)((int)((Vec3)pair3.getFirst()).f_82480_));
            this.xOffset = -((int)Math.min((double)(-this.xOffset), (double)((Vec3)pair3.getFirst()).f_82479_));
            this.yOffset = -((int)Math.min((double)(-this.yOffset), (double)((Vec3)pair3.getFirst()).f_82480_));
            this.zOffset = -((int)Math.min((double)(-this.zOffset), (double)((Vec3)pair3.getFirst()).f_82481_));
        }
        this.width += this.xOffset;
        this.height += this.yOffset;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void render(int xPosition, int yPosition, GuiGraphics graphics) {
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)xPosition + (float)this.width / 2.0f, (float)(yPosition + this.yOffset), -200.0f);
        TransformStack.cast((PoseStack)poseStack).rotateY((double)AnimationTickHolder.getRenderTime());
        poseStack.m_252880_(-((float)this.width) / 2.0f + (float)this.xOffset, 0.0f, 0.0f);
        for (Pair<Vec3, IRenderableMoleculePart> pair : this.RENDERED_OBJECTS) {
            ((IRenderableMoleculePart)pair.getSecond()).render(graphics, (Vec3)pair.getFirst());
        }
        poseStack.m_85849_();
    }

    public void generateBranch(Branch branch, Vec3 startLocation, Vec3 direction, Vec3 plane, Vec3 zig, boolean addOneConnectionToFirstNode) {
        Vec3 location = new Vec3(startLocation.f_82479_, startLocation.f_82480_, startLocation.f_82481_);
        Vec3 zag = new Vec3(zig.f_82479_, zig.f_82480_, zig.f_82481_);
        int i = 0;
        for (Node node : branch.getNodes()) {
            this.RENDERED_OBJECTS.add((Pair<Vec3, IRenderableMoleculePart>)Pair.of((Object)new Vec3(location.f_82479_, location.f_82480_, location.f_82481_), (Object)new AtomRenderInstance(node.getAtom())));
            ++i;
            Geometry geometry = this.getGeometry(node, addOneConnectionToFirstNode);
            if (addOneConnectionToFirstNode) {
                addOneConnectionToFirstNode = false;
            }
            ConfinedGeometry confinedGeometry = geometry.confine(zag, plane, direction);
            zag = confinedGeometry.getZag();
            int j = 1;
            for (Map.Entry<Branch, Bond.BondType> sideBranchAndBondType : node.getOrderedSideBranches()) {
                Vec3 sideZag = j == geometry.connections.size() ? confinedGeometry.getInverseZig() : confinedGeometry.getZag(j);
                Branch sideBranch = sideBranchAndBondType.getKey();
                Vec3 newPlane = confinedGeometry.getZig().m_82537_(sideZag);
                this.RENDERED_OBJECTS.add((Pair<Vec3, IRenderableMoleculePart>)Pair.of((Object)location.m_82549_(sideZag.m_82490_(5.75)), (Object)BondRenderInstance.fromZig(sideBranchAndBondType.getValue(), sideZag)));
                this.generateBranch(sideBranch, location.m_82549_(sideZag.m_82490_(11.5)), MathsHelper.rotate(sideZag, newPlane, 90.0), newPlane, sideZag, false);
                ++j;
            }
            if (i >= branch.getNodes().size()) break;
            Bond.BondType bondType = Bond.BondType.SINGLE;
            for (Edge edge : node.getEdges()) {
                if (edge.getSourceNode() != branch.getNodes().get(i - 1)) continue;
                bondType = edge.bondType;
            }
            this.RENDERED_OBJECTS.add((Pair<Vec3, IRenderableMoleculePart>)Pair.of((Object)location.m_82549_(zag.m_82490_(5.75)), (Object)BondRenderInstance.fromZig(bondType, zag)));
            location = location.m_82549_(zag.m_82490_(11.5));
        }
    }

    private Geometry getGeometry(Node node, boolean addOne) {
        int connections = node.getEdges().size() + node.getSideBranches().size() + (addOne ? 1 : 0);
        return node.getAtom().getElement().getGeometry(connections);
    }

    public static double distanceFromPointToLine(Vec3 point, Vec3 linePoint, Vec3 lineDirection) {
        return point.m_82546_(linePoint).m_82537_(lineDirection).m_82553_() / lineDirection.m_82553_();
    }

    protected record AtomRenderInstance(Atom atom) implements IRenderableMoleculePart
    {
        @Override
        public void render(GuiGraphics graphics, Vec3 location) {
            PoseStack poseStack = graphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_85837_(location.f_82479_, location.f_82480_, location.f_82481_);
            GuiGameElement.of((PartialModel)this.atom.getPartial()).scale(23.0).render(graphics, 0, 0);
            poseStack.m_85849_();
        }
    }

    public static enum Geometry {
        LINEAR(new Vec3(1.0, 0.0, 0.0)),
        V_SHAPE(new Vec3(0.333333, -0.942809, 0.0).m_82541_()),
        TRIGONAL_PLANAR(new Vec3(0.5, 0.86602540378, 0.0).m_82541_(), new Vec3(0.5, -0.86602540378, 0.0).m_82541_()),
        TRIGONAL_PYRAMIDAL(new Vec3(0.333333, -0.942809, 0.0).m_82541_(), new Vec3(0.333333, 0.471405, 0.816497).m_82541_()),
        TETRAHEDRAL(new Vec3(0.333333, -0.942809, 0.0).m_82541_(), new Vec3(0.333333, 0.471405, 0.816497).m_82541_(), new Vec3(0.333333, 0.471405, -0.816497).m_82541_()),
        OCTAHEDRAL(new Vec3(1.0, 0.0, 0.0), new Vec3(0.0, 1.0, 0.0), new Vec3(0.0, -1.0, 0.0), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 0.0, -1.0));

        private static final Vec3 standardDirection;
        private static final Vec3 inverseStandardDirection;
        final ImmutableList<Vec3> connections;

        private Geometry(Vec3 ... connections) {
            this.connections = ImmutableList.copyOf((Object[])connections);
        }

        public double getAngle() {
            double angle = MathsHelper.angleBetween(standardDirection, (Vec3)this.connections.get(0), new Vec3(0.0, 0.0, 1.0));
            return angle < 90.0 ? 180.0 - angle : angle;
        }

        public ConfinedGeometry confine(Vec3 zig, Vec3 plane, Vec3 direction) {
            if (plane.m_82526_(direction) > 1.0E-6) {
                throw new IllegalStateException("Chains of Molecules being rendered in a plane must continue in a direction in that plane.");
            }
            Vec3 rotationVec = zig.m_82537_(standardDirection);
            double angle = MathsHelper.angleBetween(standardDirection, zig, rotationVec);
            Vec3 zag = MathsHelper.rotate((Vec3)this.connections.get(0), rotationVec, angle);
            boolean flip = MoleculeRenderer.distanceFromPointToLine(zig.m_82549_(MathsHelper.rotate(zag, zig, 180.0)), Vec3.f_82478_, direction) < MoleculeRenderer.distanceFromPointToLine(zig.m_82549_(zag), Vec3.f_82478_, direction);
            return new ConfinedGeometry(this, rotationVec, angle, flip);
        }

        public List<Vec3> getConnections(boolean includeInput) {
            if (!includeInput) {
                return this.connections;
            }
            ArrayList<Vec3> connectionsAndInput = new ArrayList<Vec3>(this.connections.size() + 1);
            connectionsAndInput.addAll((Collection<Vec3>)this.connections);
            connectionsAndInput.add(inverseStandardDirection);
            return connectionsAndInput;
        }

        static {
            standardDirection = new Vec3(1.0, 0.0, 0.0);
            inverseStandardDirection = new Vec3(-1.0, 0.0, 0.0);
        }
    }

    protected static interface IRenderableMoleculePart {
        public void render(GuiGraphics var1, Vec3 var2);
    }

    private static class ConfinedGeometry {
        final Geometry geometry;
        final Vec3 rotationAxis;
        final double angle;
        final boolean flip;

        private ConfinedGeometry(Geometry geometry, Vec3 rotationAxis, double angle, boolean flip) {
            this.geometry = geometry;
            this.rotationAxis = rotationAxis;
            this.angle = angle;
            this.flip = flip;
        }

        private Vec3 getZig() {
            return MathsHelper.rotate(Geometry.standardDirection, this.rotationAxis, this.angle);
        }

        private Vec3 getInverseZig() {
            return MathsHelper.rotate(Geometry.inverseStandardDirection, this.rotationAxis, this.angle);
        }

        private Vec3 getZag() {
            return this.getZag(0);
        }

        private Vec3 getZag(int index) {
            Vec3 unflipped = MathsHelper.rotate((Vec3)this.geometry.connections.get(index), this.rotationAxis, this.angle);
            if (!this.flip) {
                return unflipped;
            }
            return MathsHelper.rotate(unflipped, MathsHelper.rotate(Geometry.standardDirection, this.rotationAxis, this.angle), 180.0);
        }
    }

    protected record BondRenderInstance(Bond.BondType type, Quaternionf rotation) implements IRenderableMoleculePart
    {
        private static Vec3 bond = new Vec3(1.0, 0.0, 0.0);

        public static BondRenderInstance fromZig(Bond.BondType type, Vec3 zig) {
            Vec3 z = zig.m_82541_();
            Vec3 axis = bond.m_82537_(z);
            Quaternionf q = new Quaternionf(axis.m_7096_(), axis.m_7098_(), axis.m_7094_(), (double)((float)bond.m_82526_(z) + (float)Math.sqrt((double)(bond.m_82556_() * z.m_82556_()))));
            return new BondRenderInstance(type, new Quaternionf((Quaternionfc)q.normalize()));
        }

        @Override
        public void render(GuiGraphics graphics, Vec3 location) {
            PoseStack poseStack = graphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_85837_(location.f_82479_, location.f_82480_, location.f_82481_);
            TransformStack.cast((PoseStack)poseStack).rotateCentered(this.rotation);
            GuiGameElement.of((PartialModel)this.type().getPartial()).lighting(ILightingSettings.DEFAULT_FLAT).scale(23.0).render(graphics, 0, 0);
            poseStack.m_85849_();
        }
    }
}

