/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.client.gui.menu;

import com.petrolpark.destroy.client.gui.menu.DestroyMenuTypes;
import com.petrolpark.destroy.util.RedstoneProgram;
import com.simibubi.create.content.redstone.link.RedstoneLinkNetworkHandler;
import com.simibubi.create.foundation.gui.menu.GhostItemMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class RedstoneProgrammerMenu
extends GhostItemMenu<RedstoneProgram> {
    protected RedstoneProgrammerMenu(MenuType<?> type, int id, Inventory inv, FriendlyByteBuf buf) {
        super(type, id, inv, buf);
    }

    protected RedstoneProgrammerMenu(MenuType<?> type, int id, Inventory inv, RedstoneProgram contentHolder) {
        super(type, id, inv, (Object)contentHolder);
    }

    public static RedstoneProgrammerMenu create(int id, Inventory inv, RedstoneProgram program) {
        return new RedstoneProgrammerMenu((MenuType)DestroyMenuTypes.REDSTONE_PROGRAMMER.get(), id, inv, program);
    }

    protected RedstoneProgram createOnClient(FriendlyByteBuf extraData) {
        DummyRedstoneProgram program = new DummyRedstoneProgram();
        program.read(extraData);
        return program;
    }

    protected ItemStackHandler createGhostInventory() {
        return new ItemStackHandler(((RedstoneProgram)this.contentHolder).getChannels().size() * 2);
    }

    protected boolean allowRepeats() {
        return true;
    }

    protected void addSlots() {
        this.refreshSlots(0, 100, 19);
    }

    public void refreshSlots(int offset, int max, int channelSpacing) {
        this.ghostInventory = this.createGhostInventory();
        int position = -offset;
        for (int channel = 0; channel < ((RedstoneProgram)this.contentHolder).getChannels().size(); ++channel) {
            if ((position += channelSpacing) < 0 || position > max) continue;
            this.m_38897_((Slot)new FrequencySlotItemHandler(channel * 2, 0, position));
            this.m_38897_((Slot)new FrequencySlotItemHandler(channel * 2 + 1, 18, position));
        }
    }

    protected void saveData(RedstoneProgram contentHolder) {
    }

    public static class DummyRedstoneProgram
    extends RedstoneProgram {
        @Override
        public boolean hasPower() {
            return false;
        }

        @Override
        public BlockPos getBlockPos() {
            return null;
        }

        @Override
        public boolean shouldTransmit() {
            return false;
        }

        @Override
        public LevelAccessor getWorld() {
            return null;
        }
    }

    public class FrequencySlotItemHandler
    extends SlotItemHandler {
        public FrequencySlotItemHandler(int index, int xPosition, int yPosition) {
            super((IItemHandler)RedstoneProgrammerMenu.this.ghostInventory, index, xPosition, yPosition);
        }

        public void m_5852_(@NotNull ItemStack stack) {
            if (stack != null) {
                RedstoneProgram.Channel channel = (RedstoneProgram.Channel)((RedstoneProgram)RedstoneProgrammerMenu.this.contentHolder).getChannels().get(this.getSlotIndex() / 2);
                channel.networkKey.set(this.getSlotIndex() % 2 == 0, (Object)RedstoneLinkNetworkHandler.Frequency.of((ItemStack)stack));
                if (channel.networkKey.both(f -> f.getStack().m_41619_())) {
                    ((RedstoneProgram)RedstoneProgrammerMenu.this.contentHolder).remove(channel);
                }
            }
            super.m_5852_(stack);
        }
    }
}

